/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsMessagePropertyIntercepter;
import org.apache.qpid.jms.message.JmsMessageTransformation;
import org.apache.qpid.jms.message.facade.JmsMessageFacade;
import org.apache.qpid.jms.util.TypeConversionSupport;

public class JmsMessage
implements Message {
    private static final String ID_PREFIX = "ID:";
    protected transient Callable<Void> acknowledgeCallback;
    protected transient JmsConnection connection;
    protected final JmsMessageFacade facade;
    protected boolean readOnlyBody;
    protected boolean readOnlyProperties;
    protected boolean validatePropertyNames = true;

    public JmsMessage(JmsMessageFacade facade) {
        this.facade = facade;
    }

    public JmsMessage copy() throws JMSException {
        JmsMessage other = new JmsMessage(this.facade.copy());
        other.copy(this);
        return other;
    }

    protected void copy(JmsMessage other) {
        this.readOnlyBody = other.readOnlyBody;
        this.readOnlyProperties = other.readOnlyBody;
        this.acknowledgeCallback = other.acknowledgeCallback;
        this.connection = other.connection;
        this.validatePropertyNames = other.validatePropertyNames;
    }

    public int hashCode() {
        String id = this.facade.getMessageId();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JmsMessage msg = (JmsMessage)o;
        String oMsg = msg.facade.getMessageId();
        String thisMsg = this.facade.getMessageId();
        return thisMsg != null && oMsg != null && oMsg.equals(thisMsg);
    }

    public void acknowledge() throws JMSException {
        if (this.acknowledgeCallback != null) {
            try {
                this.acknowledgeCallback.call();
            }
            catch (Throwable e) {
                throw JmsExceptionSupport.create(e);
            }
        }
    }

    public void clearBody() throws JMSException {
        this.readOnlyBody = false;
        this.facade.clearBody();
    }

    public boolean isValidatePropertyNames() {
        return this.validatePropertyNames;
    }

    public void setValidatePropertyNames(boolean validatePropertyNames) {
        this.validatePropertyNames = validatePropertyNames;
    }

    public boolean isReadOnlyBody() {
        return this.readOnlyBody;
    }

    public void setReadOnlyBody(boolean readOnlyBody) {
        this.readOnlyBody = readOnlyBody;
    }

    public boolean isReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    public void setReadOnlyProperties(boolean readOnlyProperties) {
        this.readOnlyProperties = readOnlyProperties;
    }

    public String getJMSMessageID() throws JMSException {
        String value = this.facade.getMessageId();
        if (value != null && !value.toString().startsWith(ID_PREFIX)) {
            value = ID_PREFIX + value;
        }
        return value == null ? null : value.toString();
    }

    public void setJMSMessageID(String value) throws JMSException {
        this.facade.setMessageId(value);
    }

    public long getJMSTimestamp() throws JMSException {
        return this.facade.getTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.facade.setTimestamp(timestamp);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.facade.getCorrelationId();
    }

    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.facade.setCorrelationId(correlationId);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.facade.getCorrelationIdBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        this.facade.setCorrelationIdBytes(correlationId);
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.facade.getReplyTo();
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.facade.setReplyTo(JmsMessageTransformation.transformDestination(this.connection, destination));
    }

    public Destination getJMSDestination() throws JMSException {
        return this.facade.getDestination();
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.facade.setDestination(JmsMessageTransformation.transformDestination(this.connection, destination));
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.facade.isPersistent() ? 2 : 1;
    }

    public void setJMSDeliveryMode(int mode) throws JMSException {
        this.facade.setPersistent(mode == 2);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.facade.isRedelivered();
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.facade.setRedelivered(redelivered);
    }

    public String getJMSType() throws JMSException {
        return this.facade.getType();
    }

    public void setJMSType(String type) throws JMSException {
        this.facade.setType(type);
    }

    public long getJMSExpiration() throws JMSException {
        return this.facade.getExpiration();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.facade.setExpiration(expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this.facade.getPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.facade.setPriority(priority);
    }

    public void clearProperties() throws JMSException {
        JmsMessagePropertyIntercepter.clearProperties(this.facade, true);
    }

    public boolean propertyExists(String name) throws JMSException {
        try {
            this.checkPropertyNameIsValid(name);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return JmsMessagePropertyIntercepter.propertyExists(this.facade, name);
    }

    public Enumeration<?> getPropertyNames() throws JMSException {
        HashSet<String> result = new HashSet<String>();
        Set<String> propertyNames = JmsMessagePropertyIntercepter.getPropertyNames(this.facade, true);
        for (String name : propertyNames) {
            try {
                this.checkPropertyNameIsValid(name);
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            result.add(name);
        }
        return Collections.enumeration(result);
    }

    public Enumeration<?> getAllPropertyNames() throws JMSException {
        HashSet<String> result = new HashSet<String>();
        result.addAll(JmsMessagePropertyIntercepter.getAllPropertyNames(this.facade));
        return Collections.enumeration(result);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkReadOnlyProperties();
        this.checkPropertyNameIsValid(name);
        this.checkValidObject(value);
        JmsMessagePropertyIntercepter.setProperty(this.facade, name, value);
    }

    protected void checkValidObject(Object value) throws MessageFormatException {
        boolean valid;
        boolean bl = valid = value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value == null;
        if (!valid) {
            throw new MessageFormatException("Only objectified primitive objects and String types are allowed but was: " + value + " type: " + value.getClass());
        }
    }

    public Object getObjectProperty(String name) throws JMSException {
        this.checkPropertyNameIsValid(name);
        return JmsMessagePropertyIntercepter.getProperty(this.facade, name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return false;
        }
        Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a boolean");
        }
        return rc;
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Byte rc = (Byte)TypeConversionSupport.convert(value, Byte.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a byte");
        }
        return rc;
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Short rc = (Short)TypeConversionSupport.convert(value, Short.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a short");
        }
        return rc;
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as an integer");
        }
        return rc;
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a long");
        }
        return rc;
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Float rc = (Float)TypeConversionSupport.convert(value, Float.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a float");
        }
        return rc.floatValue();
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Double rc = (Double)TypeConversionSupport.convert(value, Double.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a double");
        }
        return rc;
    }

    public String getStringProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return null;
        }
        String rc = (String)TypeConversionSupport.convert(value, String.class);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a String");
        }
        return rc;
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public Callable<Void> getAcknowledgeCallback() {
        return this.acknowledgeCallback;
    }

    public void setAcknowledgeCallback(Callable<Void> acknowledgeCallback) {
        this.acknowledgeCallback = acknowledgeCallback;
    }

    public void onSend(long producerTtl) throws JMSException {
        this.setReadOnlyBody(true);
        this.setReadOnlyProperties(true);
        this.facade.onSend(producerTtl);
    }

    public void onDispatch() throws JMSException {
        this.setReadOnlyBody(true);
        this.setReadOnlyProperties(true);
        this.facade.onDispatch();
    }

    public JmsConnection getConnection() {
        return this.connection;
    }

    public void setConnection(JmsConnection connection) {
        this.connection = connection;
    }

    public JmsMessageFacade getFacade() {
        return this.facade;
    }

    public boolean isExpired() {
        long expireTime = this.facade.getExpiration();
        return expireTime > 0L && System.currentTimeMillis() > expireTime;
    }

    public String toString() {
        return "JmsMessage { " + this.facade + " }";
    }

    protected void checkReadOnlyProperties() throws MessageNotWriteableException {
        if (this.readOnlyProperties) {
            throw new MessageNotWriteableException("Message properties are read-only");
        }
    }

    protected void checkReadOnlyBody() throws MessageNotWriteableException {
        if (this.readOnlyBody) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
    }

    protected void checkWriteOnlyBody() throws MessageNotReadableException {
        if (!this.readOnlyBody) {
            throw new MessageNotReadableException("Message body is write-only");
        }
    }

    private void checkPropertyNameIsValid(String propertyName) throws IllegalArgumentException {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        if (this.isValidatePropertyNames()) {
            this.checkIdentifierLetterAndDigitRequirements(propertyName);
            this.checkIdentifierIsntNullTrueFalse(propertyName);
            this.checkIdentifierIsntLogicOperator(propertyName);
        }
    }

    private void checkIdentifierIsntLogicOperator(String identifier) {
        if ("NOT".equals(identifier) || "AND".equals(identifier) || "OR".equals(identifier) || "BETWEEN".equals(identifier) || "LIKE".equals(identifier) || "IN".equals(identifier) || "IS".equals(identifier) || "ESCAPE".equals(identifier)) {
            throw new IllegalArgumentException("Identifier not allowed in JMS: '" + identifier + "'");
        }
    }

    private void checkIdentifierIsntNullTrueFalse(String identifier) {
        if ("NULL".equals(identifier) || "TRUE".equals(identifier) || "FALSE".equals(identifier)) {
            throw new IllegalArgumentException("Identifier not allowed in JMS: '" + identifier + "'");
        }
    }

    private void checkIdentifierLetterAndDigitRequirements(String identifier) {
        char startChar = identifier.charAt(0);
        if (!Character.isJavaIdentifierStart(startChar)) {
            throw new IllegalArgumentException("Identifier does not begin with a valid JMS identifier start character: '" + identifier + "' ");
        }
        int length = identifier.length();
        for (int i = 1; i < length; ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            throw new IllegalArgumentException("Identifier contains invalid JMS identifier character '" + ch + "': '" + identifier + "' ");
        }
    }
}

