/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpRedirect;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.proton.amqp.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnectionProperties {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnectionProperties.class);
    private final JmsConnectionInfo connectionInfo;
    private final AmqpProvider provider;
    private boolean delayedDeliverySupported = false;
    private boolean anonymousRelaySupported = false;
    private boolean sharedSubsSupported = false;
    private boolean connectionOpenFailed = false;
    private final List<AmqpRedirect> failoverServerList = new ArrayList<AmqpRedirect>();

    public AmqpConnectionProperties(JmsConnectionInfo connectionInfo, AmqpProvider provider) {
        this.connectionInfo = connectionInfo;
        this.provider = provider;
    }

    public void initialize(Symbol[] capabilities, Map<Symbol, Object> properties) {
        if (capabilities != null) {
            this.processCapabilities(capabilities);
        }
        if (properties != null) {
            this.processProperties(properties);
        }
    }

    protected void processCapabilities(Symbol[] capabilities) {
        List<Symbol> list = Arrays.asList(capabilities);
        if (list.contains(AmqpSupport.ANONYMOUS_RELAY)) {
            this.anonymousRelaySupported = true;
        }
        if (list.contains(AmqpSupport.DELAYED_DELIVERY)) {
            this.delayedDeliverySupported = true;
        }
        if (list.contains(AmqpSupport.SHARED_SUBS)) {
            this.sharedSubsSupported = true;
        }
    }

    protected void processProperties(Map<Symbol, Object> properties) {
        Object o;
        if (properties.containsKey(AmqpSupport.QUEUE_PREFIX) && (o = properties.get(AmqpSupport.QUEUE_PREFIX)) instanceof String) {
            LOG.trace("Remote sent Queue prefix value of: {}", o);
            this.connectionInfo.setQueuePrefix((String)o);
        }
        if (properties.containsKey(AmqpSupport.TOPIC_PREFIX) && (o = properties.get(AmqpSupport.TOPIC_PREFIX)) instanceof String) {
            LOG.trace("Remote sent Topic prefix value of: {}", o);
            this.connectionInfo.setTopicPrefix((String)o);
        }
        if (properties.containsKey(AmqpSupport.CONNECTION_OPEN_FAILED)) {
            LOG.trace("Remote sent Connection Establishment Failed marker.");
            this.connectionOpenFailed = true;
        }
        if (properties.containsKey(AmqpSupport.FAILOVER_SERVER_LIST)) {
            LOG.trace("Remote sent Failover Server List.");
            o = properties.get(AmqpSupport.FAILOVER_SERVER_LIST);
            if (o instanceof List) {
                for (Map redirection : (List)o) {
                    try {
                        this.failoverServerList.add(new AmqpRedirect(redirection, this.provider).validate());
                    }
                    catch (Exception ex) {
                        LOG.debug("Invalid redirection value given in failover server list: {}", (Object)ex.getMessage());
                    }
                }
                LOG.trace("Failover Server List: {}", this.failoverServerList);
            }
        }
    }

    public List<AmqpRedirect> getFailoverServerList() {
        return this.failoverServerList;
    }

    public boolean isSharedSubsSupported() {
        return this.sharedSubsSupported;
    }

    public void setSharedSubsSupported(boolean sharedSubsSupported) {
        this.sharedSubsSupported = sharedSubsSupported;
    }

    public boolean isDelayedDeliverySupported() {
        return this.delayedDeliverySupported;
    }

    public void setDeliveryDelaySupported(boolean deliveryDelaySupported) {
        this.delayedDeliverySupported = deliveryDelaySupported;
    }

    public boolean isAnonymousRelaySupported() {
        return this.anonymousRelaySupported;
    }

    public void setAnonymousRelaySupported(boolean anonymousRelaySupported) {
        this.anonymousRelaySupported = anonymousRelaySupported;
    }

    public String getQueuePrefix() {
        return this.connectionInfo.getQueuePrefix();
    }

    public void setQueuePrefix(String queuePrefix) {
        this.connectionInfo.setQueuePrefix(queuePrefix);
    }

    public String getTopicPrefix() {
        return this.connectionInfo.getTopicPrefix();
    }

    public void setTopicPrefix(String topicPrefix) {
        this.connectionInfo.setTopicPrefix(topicPrefix);
    }

    public boolean isConnectionOpenFailed() {
        return this.connectionOpenFailed;
    }

    public void setConnectionOpenFailed(boolean connectionOpenFailed) {
        this.connectionOpenFailed = connectionOpenFailed;
    }
}

