/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.failover;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.JmsOperationTimedOutException;
import org.apache.qpid.jms.JmsSendTimedOutException;
import org.apache.qpid.jms.exceptions.JMSSecuritySaslException;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.DefaultProviderListener;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderFutureFactory;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.provider.ProviderRedirectedException;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.failover.FailoverUriPool;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.jms.util.QpidJMSThreadFactory;
import org.apache.qpid.jms.util.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverProvider
extends DefaultProviderListener
implements Provider {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverProvider.class);
    public static final int UNLIMITED = -1;
    private static final int UNDEFINED = -1;
    private static final int DISABLED = 0;
    private static final int MINIMUM_TIMEOUT = 1000;
    public static final int DEFAULT_MAX_RECONNECT_ATTEMPTS = -1;
    public static final int DEFAULT_STARTUP_MAX_RECONNECT_ATTEMPTS = -1;
    public static final long DEFAULT_INITIAL_RECONNECT_DELAY = 0L;
    public static final long DEFAULT_RECONNECT_DELAY = 10L;
    public static final long DEFAULT_MAX_RECONNECT_DELAY = TimeUnit.SECONDS.toMillis(30L);
    public static final boolean DEFAULT_USE_RECONNECT_BACKOFF = true;
    public static final double DEFAULT_RECONNECT_BACKOFF_MULTIPLIER = 2.0;
    public static final int DEFAULT_WARN_AFTER_RECONNECT_ATTEMPTS = 10;
    private ProviderListener listener;
    private Provider provider;
    private final FailoverUriPool uris;
    private ScheduledFuture<?> requestTimeoutTask;
    private final ScheduledThreadPoolExecutor serializer;
    private final ScheduledThreadPoolExecutor connectionHub;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean failed = new AtomicBoolean();
    private final AtomicBoolean closingConnection = new AtomicBoolean(false);
    private final AtomicLong requestId = new AtomicLong();
    private final Map<Long, FailoverRequest> requests = Collections.synchronizedMap(new LinkedHashMap());
    private final DefaultProviderListener closedListener = new DefaultProviderListener();
    private final AtomicReference<JmsMessageFactory> messageFactory = new AtomicReference();
    private final ProviderFutureFactory futureFactory;
    private final ReconnectControls reconnectControl = new ReconnectControls();
    private IOException failureCause;
    private URI connectedURI;
    private volatile JmsConnectionInfo connectionInfo;
    private long closeTimeout = 60000L;
    private long sendTimeout = -1L;
    private long requestTimeout = -1L;
    private long initialReconnectDelay = 0L;
    private long reconnectDelay = 10L;
    private long maxReconnectDelay = DEFAULT_MAX_RECONNECT_DELAY;
    private boolean useReconnectBackOff = true;
    private double reconnectBackOffMultiplier = 2.0;
    private int maxReconnectAttempts = -1;
    private int startupMaxReconnectAttempts = -1;
    private int warnAfterReconnectAttempts = 10;
    private FailoverServerListAction amqpOpenServerListAction = FailoverServerListAction.REPLACE;

    public FailoverProvider(Map<String, String> nestedOptions, ProviderFutureFactory futureFactory) {
        this(null, nestedOptions, futureFactory);
    }

    public FailoverProvider(List<URI> uris, ProviderFutureFactory futureFactory) {
        this(uris, null, futureFactory);
    }

    public FailoverProvider(List<URI> uris, Map<String, String> nestedOptions, ProviderFutureFactory futureFactory) {
        this.uris = new FailoverUriPool(uris, nestedOptions);
        this.futureFactory = futureFactory;
        this.serializer = new ScheduledThreadPoolExecutor(1, new QpidJMSThreadFactory("FailoverProvider: serialization thread", true));
        this.serializer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.serializer.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.connectionHub = new ScheduledThreadPoolExecutor(1, new QpidJMSThreadFactory("FailoverProvider: connect thread", true));
        this.connectionHub.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.connectionHub.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
    }

    @Override
    public void connect(JmsConnectionInfo connectionInfo) throws IOException {
        this.checkClosed();
        this.connectionInfo = connectionInfo;
        LOG.debug("Initiating initial connection attempt task");
        this.triggerReconnectionAttempt();
    }

    @Override
    public void start() throws IOException, IllegalStateException {
        this.checkClosed();
        if (this.listener == null) {
            throw new IllegalStateException("No ProviderListener registered.");
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            final ProviderFuture request = this.futureFactory.createFuture();
            this.serializer.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ArrayList pending;
                        IOException error = FailoverProvider.this.failureCause != null ? FailoverProvider.this.failureCause : new IOException("Connection closed");
                        Map map = FailoverProvider.this.requests;
                        synchronized (map) {
                            pending = new ArrayList(FailoverProvider.this.requests.values());
                        }
                        for (FailoverRequest request2 : pending) {
                            if (request2.isComplete()) continue;
                            request2.onFailure(error);
                        }
                        if (FailoverProvider.this.requestTimeoutTask != null) {
                            FailoverProvider.this.requestTimeoutTask.cancel(false);
                        }
                        if (FailoverProvider.this.provider != null) {
                            FailoverProvider.this.provider.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("Caught exception while closing connection");
                    }
                    finally {
                        ThreadPoolUtils.shutdownGraceful(FailoverProvider.this.connectionHub);
                        if (FailoverProvider.this.serializer != null) {
                            FailoverProvider.this.serializer.shutdown();
                        }
                        request.onSuccess();
                    }
                }
            });
            try {
                if (this.closeTimeout < 0L) {
                    request.sync();
                } else {
                    request.sync(Math.max(1000L, this.closeTimeout), TimeUnit.MILLISECONDS);
                }
            }
            catch (IOException e) {
                LOG.warn("Error caught while closing Provider: ", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void create(final JmsResource resource, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = null;
        pending = resource instanceof JmsConnectionInfo ? new CreateConnectionRequest(request){

            @Override
            public void doTask() throws Exception {
                JmsConnectionInfo connectionInfo = (JmsConnectionInfo)resource;
                FailoverProvider.this.closeTimeout = connectionInfo.getCloseTimeout();
                FailoverProvider.this.sendTimeout = connectionInfo.getSendTimeout();
                FailoverProvider.this.requestTimeout = connectionInfo.getRequestTimeout();
                FailoverProvider.this.provider.create(resource, this);
            }

            public String toString() {
                return "create -> " + resource;
            }
        } : new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.create(resource, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                if (resource instanceof JmsTransactionInfo) {
                    JmsTransactionInfo transactionInfo = (JmsTransactionInfo)resource;
                    transactionInfo.setInDoubt(true);
                    return true;
                }
                return false;
            }

            public String toString() {
                return "create -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void start(final JmsResource resource, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.start(resource, this);
            }

            public String toString() {
                return "start -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void stop(final JmsResource resource, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.stop(resource, this);
            }

            public String toString() {
                return "stop -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void destroy(final JmsResource resourceId, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws IOException, JMSException, UnsupportedOperationException {
                if (resourceId instanceof JmsConnectionInfo) {
                    FailoverProvider.this.closingConnection.set(true);
                }
                FailoverProvider.this.provider.destroy(resourceId, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "destroy -> " + resourceId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void send(final JmsOutboundMessageDispatch envelope, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.sendTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.send(envelope, this);
            }

            public String toString() {
                return "send -> " + envelope;
            }

            @Override
            public JMSException createTimedOutException() {
                return new JmsSendTimedOutException("Timed out waiting on " + this, envelope.getMessage());
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void acknowledge(final JmsSessionId sessionId, final ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.acknowledge(sessionId, ackType, (AsyncResult)this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "session acknowledge -> " + sessionId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void acknowledge(final JmsInboundMessageDispatch envelope, final ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.acknowledge(envelope, ackType, (AsyncResult)this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "message acknowledge -> " + envelope + " ackType: " + (Object)((Object)ackType);
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void commit(final JmsTransactionInfo transactionInfo, final JmsTransactionInfo nextTransactionInfo, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.commit(transactionInfo, nextTransactionInfo, this);
            }

            @Override
            public boolean failureWhenOffline() {
                return true;
            }

            public String toString() {
                return "TX commit -> " + transactionInfo.getId();
            }

            @Override
            protected Exception createOfflineFailureException(IOException error) {
                TransactionRolledBackException ex = new TransactionRolledBackException("Commit failed, connection offline: " + error.getMessage());
                ex.initCause(error);
                return ex;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void rollback(final JmsTransactionInfo transactionInfo, final JmsTransactionInfo nextTransactionInfo, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.rollback(transactionInfo, nextTransactionInfo, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "TX rollback -> " + transactionInfo.getId();
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void recover(final JmsSessionId sessionId, AsyncResult request) throws IOException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.recover(sessionId, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "recover -> " + sessionId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void unsubscribe(final String subscription, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.unsubscribe(subscription, this);
            }

            public String toString() {
                return "unsubscribe -> " + subscription;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void pull(final JmsConsumerId consumerId, final long timeout, AsyncResult request) throws IOException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.pull(consumerId, timeout, this);
            }

            public String toString() {
                return "message pull -> " + consumerId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public JmsMessageFactory getMessageFactory() {
        return this.messageFactory.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProviderFailure(IOException cause) {
        if (this.provider != null) {
            LOG.debug("handling Provider failure: {}", (Object)cause.getMessage());
            LOG.trace("stack", (Throwable)cause);
            this.provider.setProviderListener(this.closedListener);
            URI failedURI = this.provider.getRemoteURI();
            try {
                this.provider.close();
            }
            catch (Throwable error) {
                LOG.trace("Caught exception while closing failed provider: {}", (Object)error.getMessage());
            }
            this.provider = null;
            if (this.reconnectControl.isReconnectAllowed(cause)) {
                long sweeperInterval;
                ArrayList<FailoverRequest> pending;
                ProviderListener listener;
                if (cause instanceof ProviderRedirectedException) {
                    ProviderRedirectedException redirect = (ProviderRedirectedException)cause;
                    try {
                        this.uris.addFirst(redirect.getRedirectionURI());
                    }
                    catch (Exception error) {
                        LOG.warn("Could not construct redirection URI from remote provided information");
                    }
                }
                if ((listener = this.listener) != null) {
                    listener.onConnectionInterrupted(failedURI);
                }
                Map<Long, FailoverRequest> map = this.requests;
                synchronized (map) {
                    pending = new ArrayList<FailoverRequest>(this.requests.values());
                }
                for (FailoverRequest request : pending) {
                    request.whenOffline(cause);
                }
                if (this.requestTimeoutTask == null && (sweeperInterval = this.getRequestSweeperInterval()) > 0L) {
                    LOG.trace("Request timeout monitoring enabled: interval = {}ms", (Object)sweeperInterval);
                    this.requestTimeoutTask = this.serializer.scheduleWithFixedDelay(new FailoverRequestSweeper(), sweeperInterval, sweeperInterval, TimeUnit.MILLISECONDS);
                }
                this.triggerReconnectionAttempt();
            } else {
                ProviderListener listener = this.listener;
                if (listener != null) {
                    listener.onConnectionFailure(cause);
                }
            }
        }
    }

    private void initializeNewConnection(final Provider provider) {
        this.serializer.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FailoverProvider.this.provider = provider;
                    provider.setProviderListener(FailoverProvider.this);
                    FailoverProvider.this.connectedURI = provider.getRemoteURI();
                    if (FailoverProvider.this.reconnectControl.isRecoveryRequired()) {
                        ArrayList pending;
                        LOG.debug("Signalling connection recovery: {}", (Object)provider);
                        try {
                            FailoverProvider.this.listener.onConnectionRecovery(provider);
                        }
                        finally {
                            FailoverProvider.this.processAlternates(provider.getAlternateURIs());
                        }
                        FailoverProvider.this.messageFactory.set(provider.getMessageFactory());
                        FailoverProvider.this.listener.onConnectionRecovered(provider);
                        FailoverProvider.this.listener.onConnectionRestored(provider.getRemoteURI());
                        Map map = FailoverProvider.this.requests;
                        synchronized (map) {
                            pending = new ArrayList(FailoverProvider.this.requests.values());
                        }
                        for (FailoverRequest request : pending) {
                            if (request.isComplete()) continue;
                            request.run();
                        }
                        FailoverProvider.this.reconnectControl.connectionEstablished();
                    } else {
                        ArrayList pending;
                        FailoverProvider.this.processAlternates(provider.getAlternateURIs());
                        Map map = FailoverProvider.this.requests;
                        synchronized (map) {
                            pending = new ArrayList(FailoverProvider.this.requests.values());
                        }
                        for (FailoverRequest request : pending) {
                            if (request.isComplete()) continue;
                            request.run();
                        }
                    }
                    if (FailoverProvider.this.requestTimeoutTask != null) {
                        FailoverProvider.this.requestTimeoutTask.cancel(false);
                        FailoverProvider.this.requestTimeoutTask = null;
                    }
                }
                catch (Throwable error) {
                    LOG.trace("Connection attempt:[{}] to: {} failed", (Object)FailoverProvider.this.reconnectControl.reconnectAttempts, (Object)provider.getRemoteURI());
                    FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(error));
                }
            }
        });
    }

    private void triggerReconnectionAttempt() {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.reconnectControl.scheduleReconnect(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block22: {
                    if (FailoverProvider.this.provider != null || FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get()) {
                        return;
                    }
                    Throwable failure = null;
                    Provider provider = null;
                    long reconnectAttempts = FailoverProvider.this.reconnectControl.recordNextAttempt();
                    try {
                        if (!FailoverProvider.this.uris.isEmpty()) {
                            for (int i = 0; i < FailoverProvider.this.uris.size(); ++i) {
                                URI target = FailoverProvider.this.uris.getNext();
                                if (target == null) {
                                    LOG.trace("Failover URI collection unexpectedly modified during connection attempt.");
                                    failure = new ConcurrentModificationException("Failover URIs changed unexpectedly");
                                    continue;
                                }
                                try {
                                    LOG.debug("Connection attempt:[{}] to: {} in-progress", (Object)reconnectAttempts, (Object)(target.getScheme() + "://" + target.getHost() + ":" + target.getPort()));
                                    provider = ProviderFactory.create(target, FailoverProvider.this.futureFactory);
                                    provider.connect(FailoverProvider.this.connectionInfo);
                                    FailoverProvider.this.initializeNewConnection(provider);
                                    return;
                                }
                                catch (Throwable e) {
                                    LOG.info("Connection attempt:[{}] to: {} failed", (Object)reconnectAttempts, (Object)(target.getScheme() + "://" + target.getHost() + ":" + target.getPort()));
                                    failure = e;
                                    try {
                                        if (provider != null) {
                                            provider.close();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                    }
                                    finally {
                                        provider = null;
                                    }
                                    if (!FailoverProvider.this.reconnectControl.isStoppageCause(e)) continue;
                                    LOG.trace("Stopping attempt due to type of failure");
                                    break block22;
                                }
                            }
                            break block22;
                        }
                        LOG.debug("No remote URI available to connect to in failover list");
                        failure = new IOException("No remote URI available for reconnection during connection attempt: " + reconnectAttempts);
                    }
                    catch (Throwable unknownFailure) {
                        LOG.warn("Connection attempt:[{}] failed abnormally.", (Object)reconnectAttempts);
                        failure = failure == null ? unknownFailure : failure;
                    }
                    finally {
                        if (provider == null) {
                            LOG.trace("Connection attempt:[{}] failed error: {}", (Object)FailoverProvider.this.reconnectControl.reconnectAttempts, (Object)failure.getMessage());
                            if (!FailoverProvider.this.reconnectControl.isReconnectAllowed(failure)) {
                                FailoverProvider.this.reportReconnectFailure(failure);
                            } else {
                                FailoverProvider.this.reconnectControl.scheduleReconnect(this);
                            }
                        }
                    }
                }
            }
        });
    }

    private void reportReconnectFailure(Throwable lastFailure) {
        this.serializer.execute(() -> {
            LOG.error("Failed to connect after: " + this.reconnectControl.reconnectAttempts + " attempt(s)");
            if (this.failed.compareAndSet(false, true)) {
                this.failureCause = lastFailure == null ? new IOException("Failed to connect after: " + this.reconnectControl.reconnectAttempts + " attempt(s)") : IOExceptionSupport.create(lastFailure);
                if (this.listener != null) {
                    this.listener.onConnectionFailure(this.failureCause);
                }
            }
        });
    }

    protected void checkClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("The Provider is already closed");
        }
    }

    @Override
    public void onInboundMessage(JmsInboundMessageDispatch envelope) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.listener.onInboundMessage(envelope);
    }

    @Override
    public void onCompletedMessageSend(JmsOutboundMessageDispatch envelope) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.listener.onCompletedMessageSend(envelope);
    }

    @Override
    public void onFailedMessageSend(JmsOutboundMessageDispatch envelope, Throwable cause) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.listener.onFailedMessageSend(envelope, cause);
    }

    @Override
    public void onConnectionFailure(final IOException ex) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                if (!(FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get())) {
                    LOG.debug("Failover: the provider reports failure: {}", (Object)ex.getMessage());
                    FailoverProvider.this.handleProviderFailure(ex);
                }
            }
        });
    }

    @Override
    public void onResourceClosed(JmsResource resource, Throwable cause) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.listener.onResourceClosed(resource, cause);
    }

    @Override
    public void onProviderException(final Exception ex) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                if (!(FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get())) {
                    LOG.debug("Failover: the provider reports an async error: {}", (Object)ex.getMessage());
                    FailoverProvider.this.listener.onProviderException(ex);
                }
            }
        });
    }

    private void processAlternates(List<URI> alternates) {
        if (!alternates.isEmpty()) {
            ArrayList<URI> newRemotes = new ArrayList<URI>(alternates);
            LOG.debug("Processing alternates uris:{} with new set: {}", (Object)this.uris, newRemotes);
            switch (this.amqpOpenServerListAction) {
                case ADD: {
                    try {
                        this.uris.addAll(alternates);
                    }
                    catch (Throwable err) {
                        LOG.warn("Error while attempting to add discovered URIs: {}", alternates);
                    }
                    break;
                }
                case REPLACE: {
                    newRemotes.add(0, this.connectedURI);
                    try {
                        LOG.debug("Replacing uris:{} with new set: {}", (Object)this.uris, newRemotes);
                        this.uris.replaceAll(newRemotes);
                    }
                    catch (Throwable err) {
                        LOG.warn("Error while attempting to add discovered URIs: {}", alternates);
                    }
                    break;
                }
                case IGNORE: {
                    break;
                }
            }
            LOG.debug("Processing alternates done new uris:{}", (Object)this.uris);
        }
    }

    public void add(final URI uri) {
        this.connectionHub.execute(new Runnable(){

            @Override
            public void run() {
                FailoverProvider.this.uris.add(uri);
            }
        });
    }

    public void remove(final URI uri) {
        this.connectionHub.execute(new Runnable(){

            @Override
            public void run() {
                FailoverProvider.this.uris.remove(uri);
            }
        });
    }

    @Override
    public URI getRemoteURI() {
        Provider provider = this.provider;
        if (provider != null) {
            return provider.getRemoteURI();
        }
        return null;
    }

    @Override
    public List<URI> getAlternateURIs() {
        Provider provider = this.provider;
        if (provider != null) {
            return provider.getAlternateURIs();
        }
        return null;
    }

    @Override
    public void setProviderListener(ProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public ProviderListener getProviderListener() {
        return this.listener;
    }

    public boolean isRandomize() {
        return this.uris.isRandomize();
    }

    public void setRandomize(boolean value) {
        this.uris.setRandomize(value);
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDealy) {
        this.reconnectDelay = reconnectDealy;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public int getStartupMaxReconnectAttempts() {
        return this.startupMaxReconnectAttempts;
    }

    public void setStartupMaxReconnectAttempts(int startupMaxReconnectAttempts) {
        this.startupMaxReconnectAttempts = startupMaxReconnectAttempts;
    }

    public int getWarnAfterReconnectAttempts() {
        return this.warnAfterReconnectAttempts;
    }

    public void setWarnAfterReconnectAttempts(int warnAfterReconnectAttempts) {
        this.warnAfterReconnectAttempts = warnAfterReconnectAttempts;
    }

    public double getReconnectBackOffMultiplier() {
        return this.reconnectBackOffMultiplier;
    }

    public void setReconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        this.reconnectBackOffMultiplier = reconnectBackOffMultiplier;
    }

    public boolean isUseReconnectBackOff() {
        return this.useReconnectBackOff;
    }

    public void setUseReconnectBackOff(boolean useReconnectBackOff) {
        this.useReconnectBackOff = useReconnectBackOff;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getAmqpOpenServerListAction() {
        return this.amqpOpenServerListAction.toString();
    }

    public void setAmqpOpenServerListAction(String amqpOpenServerListAction) {
        this.amqpOpenServerListAction = FailoverServerListAction.valueOf(amqpOpenServerListAction.toUpperCase(Locale.ENGLISH));
    }

    public Map<String, String> getNestedOptions() {
        return this.uris.getNestedOptions();
    }

    @Override
    public ProviderFuture newProviderFuture() {
        return this.futureFactory.createFuture();
    }

    @Override
    public ProviderFuture newProviderFuture(ProviderSynchronization synchronization) {
        return this.futureFactory.createFuture(synchronization);
    }

    public String toString() {
        return "FailoverProvider: " + (this.connectedURI == null ? "unconnected" : this.connectedURI.toString());
    }

    protected final long getRequestSweeperInterval() {
        long[] timeouts = new long[]{this.requestTimeout, this.sendTimeout};
        Arrays.sort(timeouts);
        for (long timeout : timeouts) {
            if (timeout == -1L) continue;
            return Math.max(Math.max(1L, timeout) / 3L, 1000L);
        }
        return 0L;
    }

    private class ReconnectControls {
        private volatile boolean recoveryRequired;
        private volatile long reconnectAttempts;
        private volatile long nextReconnectDelay = -1L;

        private ReconnectControls() {
        }

        public void scheduleReconnect(Runnable runnable) {
            try {
                int warnInterval = FailoverProvider.this.getWarnAfterReconnectAttempts();
                if (this.reconnectAttempts > 0L && warnInterval > 0 && this.reconnectAttempts % (long)warnInterval == 0L) {
                    LOG.warn("Failed to connect after: {} attempt(s) continuing to retry.", (Object)this.reconnectAttempts);
                }
                if (!this.recoveryRequired) {
                    if (this.reconnectAttempts == 0L) {
                        LOG.trace("Initial connect attempt will be performed immediately");
                        FailoverProvider.this.connectionHub.execute(runnable);
                    } else if (this.reconnectAttempts == 1L && FailoverProvider.this.initialReconnectDelay > 0L) {
                        LOG.trace("Delayed initial reconnect attempt will be in {} milliseconds", (Object)FailoverProvider.this.initialReconnectDelay);
                        FailoverProvider.this.connectionHub.schedule(runnable, FailoverProvider.this.initialReconnectDelay, TimeUnit.MILLISECONDS);
                    } else {
                        long delay = FailoverProvider.this.reconnectControl.nextReconnectDelay();
                        LOG.trace("Next reconnect attempt will be in {} milliseconds", (Object)delay);
                        FailoverProvider.this.connectionHub.schedule(runnable, delay, TimeUnit.MILLISECONDS);
                    }
                } else if (this.reconnectAttempts == 0L) {
                    if (FailoverProvider.this.initialReconnectDelay > 0L) {
                        LOG.trace("Delayed initial reconnect attempt will be in {} milliseconds", (Object)FailoverProvider.this.initialReconnectDelay);
                        FailoverProvider.this.connectionHub.schedule(runnable, FailoverProvider.this.initialReconnectDelay, TimeUnit.MILLISECONDS);
                    } else {
                        LOG.trace("Initial Reconnect attempt will be performed immediately");
                        FailoverProvider.this.connectionHub.execute(runnable);
                    }
                } else {
                    long delay = FailoverProvider.this.reconnectControl.nextReconnectDelay();
                    LOG.trace("Next reconnect attempt will be in {} milliseconds", (Object)delay);
                    FailoverProvider.this.connectionHub.schedule(runnable, delay, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable unrecoverable) {
                FailoverProvider.this.reportReconnectFailure(unrecoverable);
            }
        }

        public void connectionEstablished() {
            this.recoveryRequired = true;
            this.nextReconnectDelay = -1L;
            this.reconnectAttempts = 0L;
            FailoverProvider.this.uris.connected();
        }

        public long recordNextAttempt() {
            return ++this.reconnectAttempts;
        }

        public boolean isRecoveryRequired() {
            return this.recoveryRequired;
        }

        public boolean isLimitExceeded() {
            int reconnectLimit = this.reconnectAttemptLimit();
            return reconnectLimit != -1 && this.reconnectAttempts >= (long)reconnectLimit;
        }

        public boolean isReconnectAllowed(Throwable cause) {
            if (this.isStoppageCause(cause)) {
                return false;
            }
            return !this.isLimitExceeded();
        }

        private boolean isStoppageCause(Throwable cause) {
            if (cause.getCause() instanceof JMSSecuritySaslException) {
                JMSSecuritySaslException saslFailure = (JMSSecuritySaslException)((Object)cause.getCause());
                return !saslFailure.isSysTempFailure();
            }
            return cause.getCause() instanceof JMSSecurityException;
        }

        private int reconnectAttemptLimit() {
            int maxReconnectValue = FailoverProvider.this.maxReconnectAttempts;
            if (!this.recoveryRequired && FailoverProvider.this.startupMaxReconnectAttempts != -1) {
                maxReconnectValue = FailoverProvider.this.startupMaxReconnectAttempts;
            }
            return maxReconnectValue;
        }

        private long nextReconnectDelay() {
            if (this.nextReconnectDelay == -1L) {
                this.nextReconnectDelay = FailoverProvider.this.reconnectDelay;
            }
            if (FailoverProvider.this.isUseReconnectBackOff() && this.reconnectAttempts > 1L) {
                this.nextReconnectDelay = (long)((double)this.nextReconnectDelay * FailoverProvider.this.getReconnectBackOffMultiplier());
                if (this.nextReconnectDelay > FailoverProvider.this.maxReconnectDelay) {
                    this.nextReconnectDelay = FailoverProvider.this.maxReconnectDelay;
                }
            }
            return this.nextReconnectDelay;
        }
    }

    private static enum FailoverServerListAction {
        ADD,
        REPLACE,
        IGNORE;

    }

    protected abstract class CreateConnectionRequest
    extends FailoverRequest {
        public CreateConnectionRequest(AsyncResult watcher) {
            super(watcher);
        }

        @Override
        public void onSuccess() {
            FailoverProvider.this.serializer.execute(() -> {
                LOG.trace("First connection requst has completed:");
                FailoverProvider.this.messageFactory.set(FailoverProvider.this.provider.getMessageFactory());
                FailoverProvider.this.processAlternates(FailoverProvider.this.provider.getAlternateURIs());
                FailoverProvider.this.listener.onConnectionEstablished(FailoverProvider.this.provider.getRemoteURI());
                FailoverProvider.this.reconnectControl.connectionEstablished();
                this.signalConnected();
            });
        }

        @Override
        public void onFailure(Throwable result) {
            if (FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get()) {
                FailoverProvider.this.requests.remove(this.id);
                super.onFailure(result);
            } else {
                LOG.debug("Request received error: {}", (Object)result.getMessage());
                FailoverProvider.this.serializer.execute(() -> {
                    FailoverProvider.this.processAlternates(FailoverProvider.this.provider.getAlternateURIs());
                    FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(result));
                });
            }
        }

        public void signalConnected() {
            super.onSuccess();
        }
    }

    protected abstract class FailoverRequest
    extends WrappedAsyncResult
    implements Runnable {
        protected final long id;
        private final long requestStarted;
        private final long requestTimeout;

        public FailoverRequest(AsyncResult watcher) {
            this(watcher, -1L);
        }

        public FailoverRequest(AsyncResult watcher, long requestTimeout) {
            super(watcher);
            this.id = FailoverProvider.this.requestId.incrementAndGet();
            this.requestStarted = System.nanoTime();
            this.requestTimeout = requestTimeout;
            LOG.trace("Created Failover Task: {} ({})", (Object)this, (Object)this.id);
        }

        @Override
        public void run() {
            FailoverProvider.this.requests.put(this.id, this);
            if (FailoverProvider.this.provider == null) {
                this.whenOffline(new IOException("Connection failed."));
            } else {
                try {
                    LOG.debug("Executing Failover Task: {} ({})", (Object)this, (Object)this.id);
                    this.doTask();
                }
                catch (UnsupportedOperationException e) {
                    FailoverProvider.this.requests.remove(this.id);
                    this.getWrappedRequest().onFailure(e);
                }
                catch (JMSException jmsEx) {
                    FailoverProvider.this.requests.remove(this.id);
                    this.getWrappedRequest().onFailure(jmsEx);
                }
                catch (Throwable e) {
                    LOG.debug("Caught exception while executing task: {} - {}", (Object)this, (Object)e.getMessage());
                    this.whenOffline(IOExceptionSupport.create(e));
                    FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(e));
                }
            }
        }

        @Override
        public void onFailure(final Throwable error) {
            if (error instanceof JMSException || FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get()) {
                FailoverProvider.this.requests.remove(this.id);
                super.onFailure(error);
            } else {
                LOG.debug("Request received error: {}", (Object)error.getMessage());
                FailoverProvider.this.serializer.execute(new Runnable(){

                    @Override
                    public void run() {
                        IOException ioError = IOExceptionSupport.create(error);
                        FailoverRequest.this.whenOffline(ioError);
                        FailoverProvider.this.handleProviderFailure(ioError);
                    }
                });
            }
        }

        @Override
        public void onSuccess() {
            FailoverProvider.this.requests.remove(this.id);
            super.onSuccess();
        }

        public abstract void doTask() throws Exception;

        public boolean succeedsWhenOffline() {
            return false;
        }

        public boolean failureWhenOffline() {
            return false;
        }

        public boolean isExpired() {
            if (this.requestTimeout != -1L) {
                return System.nanoTime() - this.requestStarted > TimeUnit.MILLISECONDS.toNanos(this.requestTimeout);
            }
            return false;
        }

        protected JMSException createTimedOutException() {
            return new JmsOperationTimedOutException("Timed out waiting on " + this);
        }

        protected Exception createOfflineFailureException(IOException error) {
            return IOExceptionSupport.create(error);
        }

        private void whenOffline(IOException error) {
            if (this.failureWhenOffline()) {
                FailoverProvider.this.requests.remove(this.id);
                this.getWrappedRequest().onFailure(this.createOfflineFailureException(error));
            } else if (this.succeedsWhenOffline()) {
                this.onSuccess();
            } else {
                LOG.trace("Failover task held until connection recovered: {} ({})", (Object)this, (Object)this.id);
            }
        }
    }

    protected final class FailoverRequestSweeper
    implements Runnable {
        protected FailoverRequestSweeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList pending;
            Map map = FailoverProvider.this.requests;
            synchronized (map) {
                pending = new ArrayList(FailoverProvider.this.requests.values());
            }
            for (FailoverRequest request : pending) {
                if (!request.isExpired()) continue;
                LOG.trace("Task {} has timed out, sending failure notice.", (Object)request);
                request.onFailure(request.createTimedOutException());
            }
        }
    }
}

