/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.util;

import org.slf4j.LoggerFactory;

public final class Logger {
    private final org.slf4j.Logger log;

    public static final Logger get(Class<?> klass) {
        return new Logger(LoggerFactory.getLogger(klass));
    }

    private Logger(org.slf4j.Logger log) {
        this.log = log;
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(String message, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format(message, args));
        }
    }

    public void debug(Throwable t, String message, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format(message, args), t);
        }
    }

    public void error(String message, Object ... args) {
        if (this.log.isErrorEnabled()) {
            this.log.error(String.format(message, args));
        }
    }

    public void error(Throwable t, String message, Object ... args) {
        if (this.log.isErrorEnabled()) {
            this.log.error(String.format(message, args), t);
        }
    }

    public void warn(String message, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(String.format(message, args));
        }
    }

    public void warn(Throwable t, String message, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(String.format(message, args), t);
        }
    }

    public void info(String message, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format(message, args));
        }
    }

    public void info(Throwable t, String message, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format(message, args), t);
        }
    }

    public void trace(String message, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format(message, args));
        }
    }

    public void trace(Throwable t, String message, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format(message, args), t);
        }
    }
}

