/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.IncomingNetworkTransport;
import org.apache.qpid.transport.network.NetworkTransport;
import org.apache.qpid.transport.network.OutgoingNetworkTransport;

public class Transport {
    public static final String QPID_TRANSPORT_PROPNAME = "qpid.transport";
    public static final String QPID_TRANSPORT_V0_8_PROPNAME = "qpid.transport.v0_8";
    public static final String QPID_TRANSPORT_V0_9_PROPNAME = "qpid.transport.v0_9";
    public static final String QPID_TRANSPORT_V0_9_1_PROPNAME = "qpid.transport.v0_9_1";
    public static final String QPID_TRANSPORT_V0_10_PROPNAME = "qpid.transport.v0_10";
    public static final String QPID_BROKER_TRANSPORT_PROPNAME = "qpid.broker.transport";
    private static final String IO_TRANSPORT_CLASSNAME = "org.apache.qpid.transport.network.io.IoNetworkTransport";
    public static final String TCP = "tcp";
    private static final Map<ProtocolVersion, String> OUTGOING_PROTOCOL_TO_IMPLDEFAULTS_MAP;

    private Transport() {
    }

    public static IncomingNetworkTransport getIncomingTransportInstance() {
        return (IncomingNetworkTransport)Transport.loadTransportClass(System.getProperty(QPID_BROKER_TRANSPORT_PROPNAME, IO_TRANSPORT_CLASSNAME));
    }

    public static OutgoingNetworkTransport getOutgoingTransportInstance(ProtocolVersion protocolVersion) {
        String overrride = Transport.getOverrideClassNameFromSystemProperty(protocolVersion);
        String networkTransportClassName = overrride != null ? overrride : OUTGOING_PROTOCOL_TO_IMPLDEFAULTS_MAP.get(protocolVersion);
        return (OutgoingNetworkTransport)Transport.loadTransportClass(networkTransportClassName);
    }

    private static NetworkTransport loadTransportClass(String networkTransportClassName) {
        if (networkTransportClassName == null) {
            throw new IllegalArgumentException("transport class name must not be null");
        }
        try {
            Class<?> clazz = Class.forName(networkTransportClassName);
            return (NetworkTransport)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new TransportException("Unable to instantiate transport class " + networkTransportClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new TransportException("Access exception " + networkTransportClassName, e);
        }
        catch (ClassNotFoundException e) {
            throw new TransportException("Unable to load transport class " + networkTransportClassName, e);
        }
    }

    private static String getOverrideClassNameFromSystemProperty(ProtocolVersion protocolVersion) {
        String protocolSpecificSystemProperty;
        if (ProtocolVersion.v0_10.equals(protocolVersion)) {
            protocolSpecificSystemProperty = QPID_TRANSPORT_V0_10_PROPNAME;
        } else if (ProtocolVersion.v0_91.equals(protocolVersion)) {
            protocolSpecificSystemProperty = QPID_TRANSPORT_V0_9_1_PROPNAME;
        } else if (ProtocolVersion.v0_9.equals(protocolVersion)) {
            protocolSpecificSystemProperty = QPID_TRANSPORT_V0_9_PROPNAME;
        } else if (ProtocolVersion.v8_0.equals(protocolVersion)) {
            protocolSpecificSystemProperty = QPID_TRANSPORT_V0_8_PROPNAME;
        } else {
            throw new IllegalArgumentException("Unknown ProtocolVersion " + protocolVersion);
        }
        return System.getProperty(protocolSpecificSystemProperty, System.getProperty(QPID_TRANSPORT_PROPNAME));
    }

    static {
        HashMap<ProtocolVersion, String> map = new HashMap<ProtocolVersion, String>();
        map.put(ProtocolVersion.v8_0, IO_TRANSPORT_CLASSNAME);
        map.put(ProtocolVersion.v0_9, IO_TRANSPORT_CLASSNAME);
        map.put(ProtocolVersion.v0_91, IO_TRANSPORT_CLASSNAME);
        map.put(ProtocolVersion.v0_10, IO_TRANSPORT_CLASSNAME);
        OUTGOING_PROTOCOL_TO_IMPLDEFAULTS_MAP = Collections.unmodifiableMap(map);
    }
}

