/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.HashMap;
import java.util.List;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.properties.ConnectionStartProperties;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionHeartbeat;
import org.apache.qpid.transport.ConnectionOpenOk;
import org.apache.qpid.transport.ConnectionRedirect;
import org.apache.qpid.transport.ConnectionSecure;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.ConnectionStart;
import org.apache.qpid.transport.ConnectionTune;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.ProtocolVersionException;
import org.apache.qpid.transport.util.Logger;

public class ClientDelegate
extends ConnectionDelegate {
    private static final Logger log = Logger.get(ClientDelegate.class);
    private final ConnectionSettings _connectionSettings;

    public ClientDelegate(ConnectionSettings settings) {
        this._connectionSettings = settings;
    }

    @Override
    public void init(Connection conn, ProtocolHeader hdr) {
        if (hdr.getMajor() != 0 || hdr.getMinor() != 10) {
            conn.exception(new ProtocolVersionException(hdr.getMajor(), hdr.getMinor()));
        }
    }

    @Override
    public void connectionStart(Connection conn, ConnectionStart start) {
        HashMap<String, Object> clientProperties = new HashMap<String, Object>();
        if (this._connectionSettings.getClientProperties() != null) {
            clientProperties.putAll(this._connectionSettings.getClientProperties());
        }
        clientProperties.put("qpid.session_flow", 1);
        clientProperties.put("qpid.client_pid", ConnectionStartProperties.getPID());
        clientProperties.put("qpid.client_process", System.getProperty("qpid.client_process", "Qpid Java Client"));
        clientProperties.put("qpid.client_version", QpidProperties.getReleaseVersion());
        clientProperties.put("product", QpidProperties.getProductName());
        clientProperties.put("platform", ConnectionStartProperties.getPlatformInfo());
        List<Object> brokerMechs = start.getMechanisms();
        if (brokerMechs == null || brokerMechs.isEmpty()) {
            conn.connectionStartOk(clientProperties, null, null, conn.getLocale(), new Option[0]);
            return;
        }
        conn.setServerProperties(start.getServerProperties());
        try {
            SaslClient sc = this.createSaslClient(brokerMechs);
            conn.setSaslClient(sc);
            byte[] response = sc.hasInitialResponse() ? sc.evaluateChallenge(new byte[0]) : null;
            conn.connectionStartOk(clientProperties, sc.getMechanismName(), response, conn.getLocale(), new Option[0]);
        }
        catch (ConnectionException ce) {
            conn.exception(ce);
        }
        catch (SaslException e) {
            conn.exception(e);
        }
    }

    protected SaslClient createSaslClient(List<Object> brokerMechs) throws ConnectionException, SaslException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectionSecure(Connection conn, ConnectionSecure secure) {
        SaslClient sc = conn.getSaslClient();
        try {
            byte[] response = sc.evaluateChallenge(secure.getChallenge());
            conn.connectionSecureOk(response, new Option[0]);
        }
        catch (SaslException e) {
            conn.exception(e);
        }
    }

    @Override
    public void connectionTune(Connection conn, ConnectionTune tune) {
        int heartbeatInterval = this._connectionSettings.getHeartbeatInterval010();
        float heartbeatTimeoutFactor = this._connectionSettings.getHeartbeatTimeoutFactor();
        int actualHeartbeatInterval = this.calculateHeartbeatInterval(heartbeatInterval, tune.getHeartbeatMin(), tune.getHeartbeatMax());
        conn.connectionTuneOk(tune.getChannelMax(), tune.getMaxFrameSize(), actualHeartbeatInterval, new Option[0]);
        int idleTimeout = (int)((float)(actualHeartbeatInterval * 1000) * heartbeatTimeoutFactor);
        conn.getNetworkConnection().setMaxReadIdle((int)((float)actualHeartbeatInterval * heartbeatTimeoutFactor));
        conn.getNetworkConnection().setMaxWriteIdle(actualHeartbeatInterval);
        conn.setIdleTimeout(idleTimeout);
        int channelMax = tune.getChannelMax();
        conn.setChannelMax(channelMax == 0 ? 65535 : channelMax);
        conn.connectionOpen(this._connectionSettings.getVhost(), null, Option.INSIST);
    }

    @Override
    public void connectionOpenOk(Connection conn, ConnectionOpenOk ok) {
        if (conn.isConnectionResuming()) {
            conn.setState(Connection.State.RESUMING);
        } else {
            conn.setState(Connection.State.OPEN);
        }
    }

    @Override
    public void connectionRedirect(Connection conn, ConnectionRedirect redir) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectionHeartbeat(Connection conn, ConnectionHeartbeat hearbeat) {
        conn.connectionHeartbeat(new Option[0]);
    }

    private int calculateHeartbeatInterval(int heartbeat, int min, int max) {
        int i = heartbeat;
        if (i == 0) {
            log.info("Heartbeat interval is 0 sec. Heartbeats are disabled.", new Object[0]);
            return 0;
        }
        if (i >= min && i <= max) {
            return i;
        }
        log.info("The broker does not support the configured connection heartbeat interval of %s sec, using the brokers max supported value of %s sec instead.", i, max);
        return max;
    }

    public ConnectionSettings getConnectionSettings() {
        return this._connectionSettings;
    }
}

