/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class BasicDeliverBodyImpl
extends AMQMethodBody_8_0
implements BasicDeliverBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new BasicDeliverBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 60;
    private final AMQShortString _consumerTag;
    private final long _deliveryTag;
    private final byte _bitfield0;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public BasicDeliverBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._consumerTag = this.readAMQShortString(buffer);
        this._deliveryTag = this.readLong(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
    }

    public BasicDeliverBodyImpl(AMQShortString consumerTag, long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey) {
        this._consumerTag = consumerTag;
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (redelivered) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
        this._exchange = exchange;
        this._routingKey = routingKey;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 60;
    }

    @Override
    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    @Override
    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    @Override
    public final boolean getRedelivered() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    @Override
    protected int getBodySize() {
        int size = 9;
        size += this.getSizeOf(this._consumerTag);
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._routingKey);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchBasicDeliver(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicDeliverBodyImpl: ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("redelivered=");
        buf.append(this.getRedelivered());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append("]");
        return buf.toString();
    }
}

