/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.FileQosBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class FileQosBodyImpl
extends AMQMethodBody_0_9
implements FileQosBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new FileQosBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 10;
    private final long _prefetchSize;
    private final int _prefetchCount;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FileQosBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._prefetchSize = this.readUnsignedInteger(buffer);
        this._prefetchCount = this.readUnsignedShort(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public FileQosBodyImpl(long prefetchSize, int prefetchCount, boolean global) {
        this._prefetchSize = prefetchSize;
        this._prefetchCount = prefetchCount;
        byte bitfield0 = 0;
        if (global) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 70;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    @Override
    public final long getPrefetchSize() {
        return this._prefetchSize;
    }

    @Override
    public final int getPrefetchCount() {
        return this._prefetchCount;
    }

    @Override
    public final boolean getGlobal() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 7;
        return size;
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedInteger(buffer, this._prefetchSize);
        this.writeUnsignedShort(buffer, this._prefetchCount);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchFileQos(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[FileQosBodyImpl: ");
        buf.append("prefetchSize=");
        buf.append(this.getPrefetchSize());
        buf.append(", ");
        buf.append("prefetchCount=");
        buf.append(this.getPrefetchCount());
        buf.append(", ");
        buf.append("global=");
        buf.append(this.getGlobal());
        buf.append("]");
        return buf.toString();
    }
}

