/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionExpected
extends Method {
    public static final int TYPE = 520;
    private short packing_flags = 0;
    private RangeSet commands;
    private List<Object> fragments;

    @Override
    public final int getStructType() {
        return 520;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 2;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public SessionExpected() {
    }

    public SessionExpected(RangeSet commands, List<Object> fragments, Option ... _options) {
        if (commands != null) {
            this.setCommands(commands);
        }
        if (fragments != null) {
            this.setFragments(fragments);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.sessionExpected(context, this);
    }

    public final boolean hasCommands() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final SessionExpected clearCommands() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.commands = null;
        this.setDirty(true);
        return this;
    }

    public final RangeSet getCommands() {
        return this.commands;
    }

    public final SessionExpected setCommands(RangeSet value) {
        this.commands = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final SessionExpected commands(RangeSet value) {
        return this.setCommands(value);
    }

    public final boolean hasFragments() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final SessionExpected clearFragments() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.fragments = null;
        this.setDirty(true);
        return this;
    }

    public final List<Object> getFragments() {
        return this.fragments;
    }

    public final SessionExpected setFragments(List<Object> value) {
        this.fragments = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final SessionExpected fragments(List<Object> value) {
        return this.setFragments(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeSequenceSet(this.commands);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeArray(this.fragments);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.commands = dec.readSequenceSet();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.fragments = dec.readArray();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("commands", this.getCommands());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("fragments", this.getFragments());
        }
        return result;
    }
}

