/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionCompleted
extends Method {
    public static final int TYPE = 522;
    private short packing_flags = 0;
    private RangeSet commands;

    @Override
    public final int getStructType() {
        return 522;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 2;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public SessionCompleted() {
    }

    public SessionCompleted(RangeSet commands, Option ... _options) {
        if (commands != null) {
            this.setCommands(commands);
        }
        block7: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case TIMELY_REPLY: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block7;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block7;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block7;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block7;
                }
                case NONE: {
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.sessionCompleted(context, this);
    }

    public final boolean hasCommands() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final SessionCompleted clearCommands() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.commands = null;
        this.setDirty(true);
        return this;
    }

    public final RangeSet getCommands() {
        return this.commands;
    }

    public final SessionCompleted setCommands(RangeSet value) {
        this.commands = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final SessionCompleted commands(RangeSet value) {
        return this.setCommands(value);
    }

    public final boolean hasTimelyReply() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final SessionCompleted clearTimelyReply() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getTimelyReply() {
        return this.hasTimelyReply();
    }

    public final SessionCompleted setTimelyReply(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final SessionCompleted timelyReply(boolean value) {
        return this.setTimelyReply(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeSequenceSet(this.commands);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.commands = dec.readSequenceSet();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("commands", this.getCommands());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("timelyReply", this.getTimelyReply());
        }
        return result;
    }
}

