/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_91;

import java.io.IOException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRecoverSyncBody;
import org.apache.qpid.framing.BasicRecoverSyncOkBody;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ExchangeDeleteOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.QueueUnbindOkBody;
import org.apache.qpid.framing.TxCommitBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.framing.TxRollbackBody;
import org.apache.qpid.framing.TxRollbackOkBody;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;
import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;
import org.apache.qpid.framing.amqp_0_91.BasicAckBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicCancelBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicCancelOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicConsumeBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicConsumeOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicDeliverBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicGetBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicGetEmptyBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicGetOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicPublishBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicQosBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicQosOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicRecoverBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicRecoverSyncBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicRecoverSyncOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicRejectBodyImpl;
import org.apache.qpid.framing.amqp_0_91.BasicReturnBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ChannelCloseBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ChannelCloseOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ChannelFlowBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ChannelFlowOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ChannelOpenBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ChannelOpenOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionCloseBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionCloseOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionOpenBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionOpenOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionSecureBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionSecureOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionStartBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionStartOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionTuneBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ConnectionTuneOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ExchangeBoundBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ExchangeBoundOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ExchangeDeclareBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ExchangeDeclareOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ExchangeDeleteBodyImpl;
import org.apache.qpid.framing.amqp_0_91.ExchangeDeleteOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.MethodConverter_0_91;
import org.apache.qpid.framing.amqp_0_91.QueueBindBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueueBindOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueueDeclareBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueueDeclareOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueueDeleteBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueueDeleteOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueuePurgeBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueuePurgeOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueueUnbindBodyImpl;
import org.apache.qpid.framing.amqp_0_91.QueueUnbindOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.TxCommitBodyImpl;
import org.apache.qpid.framing.amqp_0_91.TxCommitOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.TxRollbackBodyImpl;
import org.apache.qpid.framing.amqp_0_91.TxRollbackOkBodyImpl;
import org.apache.qpid.framing.amqp_0_91.TxSelectBodyImpl;
import org.apache.qpid.framing.amqp_0_91.TxSelectOkBodyImpl;
import org.apache.qpid.protocol.AMQConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodRegistry_0_91
extends MethodRegistry {
    private static final Logger _log = LoggerFactory.getLogger(MethodRegistry.class);
    private ProtocolVersionMethodConverter _protocolVersionConverter = new MethodConverter_0_91();
    private final AMQMethodBodyInstanceFactory[][] _factories = new AMQMethodBodyInstanceFactory[91][];

    public MethodRegistry_0_91() {
        this(new ProtocolVersion(0, 91));
    }

    public MethodRegistry_0_91(ProtocolVersion pv) {
        super(pv);
        this._factories[10] = new AMQMethodBodyInstanceFactory[52];
        this._factories[10][10] = ConnectionStartBodyImpl.getFactory();
        this._factories[10][11] = ConnectionStartOkBodyImpl.getFactory();
        this._factories[10][20] = ConnectionSecureBodyImpl.getFactory();
        this._factories[10][21] = ConnectionSecureOkBodyImpl.getFactory();
        this._factories[10][30] = ConnectionTuneBodyImpl.getFactory();
        this._factories[10][31] = ConnectionTuneOkBodyImpl.getFactory();
        this._factories[10][40] = ConnectionOpenBodyImpl.getFactory();
        this._factories[10][41] = ConnectionOpenOkBodyImpl.getFactory();
        this._factories[10][50] = ConnectionCloseBodyImpl.getFactory();
        this._factories[10][51] = ConnectionCloseOkBodyImpl.getFactory();
        this._factories[20] = new AMQMethodBodyInstanceFactory[42];
        this._factories[20][10] = ChannelOpenBodyImpl.getFactory();
        this._factories[20][11] = ChannelOpenOkBodyImpl.getFactory();
        this._factories[20][20] = ChannelFlowBodyImpl.getFactory();
        this._factories[20][21] = ChannelFlowOkBodyImpl.getFactory();
        this._factories[20][40] = ChannelCloseBodyImpl.getFactory();
        this._factories[20][41] = ChannelCloseOkBodyImpl.getFactory();
        this._factories[40] = new AMQMethodBodyInstanceFactory[24];
        this._factories[40][10] = ExchangeDeclareBodyImpl.getFactory();
        this._factories[40][11] = ExchangeDeclareOkBodyImpl.getFactory();
        this._factories[40][20] = ExchangeDeleteBodyImpl.getFactory();
        this._factories[40][21] = ExchangeDeleteOkBodyImpl.getFactory();
        this._factories[40][22] = ExchangeBoundBodyImpl.getFactory();
        this._factories[40][23] = ExchangeBoundOkBodyImpl.getFactory();
        this._factories[50] = new AMQMethodBodyInstanceFactory[52];
        this._factories[50][10] = QueueDeclareBodyImpl.getFactory();
        this._factories[50][11] = QueueDeclareOkBodyImpl.getFactory();
        this._factories[50][20] = QueueBindBodyImpl.getFactory();
        this._factories[50][21] = QueueBindOkBodyImpl.getFactory();
        this._factories[50][30] = QueuePurgeBodyImpl.getFactory();
        this._factories[50][31] = QueuePurgeOkBodyImpl.getFactory();
        this._factories[50][40] = QueueDeleteBodyImpl.getFactory();
        this._factories[50][41] = QueueDeleteOkBodyImpl.getFactory();
        this._factories[50][50] = QueueUnbindBodyImpl.getFactory();
        this._factories[50][51] = QueueUnbindOkBodyImpl.getFactory();
        this._factories[60] = new AMQMethodBodyInstanceFactory[112];
        this._factories[60][10] = BasicQosBodyImpl.getFactory();
        this._factories[60][11] = BasicQosOkBodyImpl.getFactory();
        this._factories[60][20] = BasicConsumeBodyImpl.getFactory();
        this._factories[60][21] = BasicConsumeOkBodyImpl.getFactory();
        this._factories[60][30] = BasicCancelBodyImpl.getFactory();
        this._factories[60][31] = BasicCancelOkBodyImpl.getFactory();
        this._factories[60][40] = BasicPublishBodyImpl.getFactory();
        this._factories[60][50] = BasicReturnBodyImpl.getFactory();
        this._factories[60][60] = BasicDeliverBodyImpl.getFactory();
        this._factories[60][70] = BasicGetBodyImpl.getFactory();
        this._factories[60][71] = BasicGetOkBodyImpl.getFactory();
        this._factories[60][72] = BasicGetEmptyBodyImpl.getFactory();
        this._factories[60][80] = BasicAckBodyImpl.getFactory();
        this._factories[60][90] = BasicRejectBodyImpl.getFactory();
        this._factories[60][100] = BasicRecoverBodyImpl.getFactory();
        this._factories[60][110] = BasicRecoverSyncBodyImpl.getFactory();
        this._factories[60][111] = BasicRecoverSyncOkBodyImpl.getFactory();
        this._factories[90] = new AMQMethodBodyInstanceFactory[32];
        this._factories[90][10] = TxSelectBodyImpl.getFactory();
        this._factories[90][11] = TxSelectOkBodyImpl.getFactory();
        this._factories[90][20] = TxCommitBodyImpl.getFactory();
        this._factories[90][21] = TxCommitOkBodyImpl.getFactory();
        this._factories[90][30] = TxRollbackBodyImpl.getFactory();
        this._factories[90][31] = TxRollbackOkBodyImpl.getFactory();
    }

    public AMQMethodBody convertToBody(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
        AMQMethodBodyInstanceFactory bodyFactory;
        int classId = in.readUnsignedShort();
        int methodId = in.readUnsignedShort();
        try {
            bodyFactory = this._factories[classId][methodId];
        }
        catch (NullPointerException e) {
            throw new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID, "Class " + classId + " unknown in AMQP version 0-91" + " (while trying to decode class " + classId + " method " + methodId + ".");
        }
        catch (IndexOutOfBoundsException e) {
            if (classId >= this._factories.length) {
                throw new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID, "Class " + classId + " unknown in AMQP version 0-91" + " (while trying to decode class " + classId + " method " + methodId + ".");
            }
            throw new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID, "Method " + methodId + " unknown in AMQP version 0-91" + " (while trying to decode class " + classId + " method " + methodId + ".");
        }
        if (bodyFactory == null) {
            throw new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID, "Method " + methodId + " unknown in AMQP version 0-91" + " (while trying to decode class " + classId + " method " + methodId + ".");
        }
        return bodyFactory.newInstance(in, size);
    }

    public int getMaxClassId() {
        return 90;
    }

    public int getMaxMethodId(int classId) {
        return this._factories[classId].length - 1;
    }

    public ConnectionStartBody createConnectionStartBody(short versionMajor, short versionMinor, FieldTable serverProperties, byte[] mechanisms, byte[] locales) {
        return new ConnectionStartBodyImpl(versionMajor, versionMinor, serverProperties, mechanisms, locales);
    }

    public ConnectionStartOkBody createConnectionStartOkBody(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        return new ConnectionStartOkBodyImpl(clientProperties, mechanism, response, locale);
    }

    public ConnectionSecureBody createConnectionSecureBody(byte[] challenge) {
        return new ConnectionSecureBodyImpl(challenge);
    }

    public ConnectionSecureOkBody createConnectionSecureOkBody(byte[] response) {
        return new ConnectionSecureOkBodyImpl(response);
    }

    public ConnectionTuneBody createConnectionTuneBody(int channelMax, long frameMax, int heartbeat) {
        return new ConnectionTuneBodyImpl(channelMax, frameMax, heartbeat);
    }

    public ConnectionTuneOkBody createConnectionTuneOkBody(int channelMax, long frameMax, int heartbeat) {
        return new ConnectionTuneOkBodyImpl(channelMax, frameMax, heartbeat);
    }

    public ConnectionOpenBody createConnectionOpenBody(AMQShortString virtualHost, AMQShortString capabilities, boolean insist) {
        return new ConnectionOpenBodyImpl(virtualHost, capabilities, insist);
    }

    public ConnectionOpenOkBody createConnectionOpenOkBody(AMQShortString knownHosts) {
        return new ConnectionOpenOkBodyImpl(knownHosts);
    }

    public ConnectionCloseBody createConnectionCloseBody(int replyCode, AMQShortString replyText, int classId, int methodId) {
        return new ConnectionCloseBodyImpl(replyCode, replyText, classId, methodId);
    }

    public ConnectionCloseOkBody createConnectionCloseOkBody() {
        return new ConnectionCloseOkBodyImpl();
    }

    public ChannelOpenBody createChannelOpenBody(AMQShortString outOfBand) {
        return new ChannelOpenBodyImpl(outOfBand);
    }

    public ChannelOpenOkBody createChannelOpenOkBody(byte[] channelId) {
        return new ChannelOpenOkBodyImpl(channelId);
    }

    public ChannelFlowBody createChannelFlowBody(boolean active) {
        return new ChannelFlowBodyImpl(active);
    }

    public ChannelFlowOkBody createChannelFlowOkBody(boolean active) {
        return new ChannelFlowOkBodyImpl(active);
    }

    public ChannelCloseBody createChannelCloseBody(int replyCode, AMQShortString replyText, int classId, int methodId) {
        return new ChannelCloseBodyImpl(replyCode, replyText, classId, methodId);
    }

    public ChannelCloseOkBody createChannelCloseOkBody() {
        return new ChannelCloseOkBodyImpl();
    }

    public ExchangeDeclareBody createExchangeDeclareBody(int ticket, AMQShortString exchange, AMQShortString type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, FieldTable arguments) {
        return new ExchangeDeclareBodyImpl(ticket, exchange, type, passive, durable, autoDelete, internal, nowait, arguments);
    }

    public ExchangeDeclareOkBody createExchangeDeclareOkBody() {
        return new ExchangeDeclareOkBodyImpl();
    }

    public ExchangeDeleteBody createExchangeDeleteBody(int ticket, AMQShortString exchange, boolean ifUnused, boolean nowait) {
        return new ExchangeDeleteBodyImpl(ticket, exchange, ifUnused, nowait);
    }

    public ExchangeDeleteOkBody createExchangeDeleteOkBody() {
        return new ExchangeDeleteOkBodyImpl();
    }

    public ExchangeBoundBody createExchangeBoundBody(AMQShortString exchange, AMQShortString routingKey, AMQShortString queue) {
        return new ExchangeBoundBodyImpl(exchange, routingKey, queue);
    }

    public ExchangeBoundOkBody createExchangeBoundOkBody(int replyCode, AMQShortString replyText) {
        return new ExchangeBoundOkBodyImpl(replyCode, replyText);
    }

    public QueueDeclareBody createQueueDeclareBody(int ticket, AMQShortString queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, FieldTable arguments) {
        return new QueueDeclareBodyImpl(ticket, queue, passive, durable, exclusive, autoDelete, nowait, arguments);
    }

    public QueueDeclareOkBody createQueueDeclareOkBody(AMQShortString queue, long messageCount, long consumerCount) {
        return new QueueDeclareOkBodyImpl(queue, messageCount, consumerCount);
    }

    public QueueBindBody createQueueBindBody(int ticket, AMQShortString queue, AMQShortString exchange, AMQShortString routingKey, boolean nowait, FieldTable arguments) {
        return new QueueBindBodyImpl(ticket, queue, exchange, routingKey, nowait, arguments);
    }

    public QueueBindOkBody createQueueBindOkBody() {
        return new QueueBindOkBodyImpl();
    }

    public QueuePurgeBody createQueuePurgeBody(int ticket, AMQShortString queue, boolean nowait) {
        return new QueuePurgeBodyImpl(ticket, queue, nowait);
    }

    public QueuePurgeOkBody createQueuePurgeOkBody(long messageCount) {
        return new QueuePurgeOkBodyImpl(messageCount);
    }

    public QueueDeleteBody createQueueDeleteBody(int ticket, AMQShortString queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
        return new QueueDeleteBodyImpl(ticket, queue, ifUnused, ifEmpty, nowait);
    }

    public QueueDeleteOkBody createQueueDeleteOkBody(long messageCount) {
        return new QueueDeleteOkBodyImpl(messageCount);
    }

    public QueueUnbindBody createQueueUnbindBody(int ticket, AMQShortString queue, AMQShortString exchange, AMQShortString routingKey, FieldTable arguments) {
        return new QueueUnbindBodyImpl(ticket, queue, exchange, routingKey, arguments);
    }

    public QueueUnbindOkBody createQueueUnbindOkBody() {
        return new QueueUnbindOkBodyImpl();
    }

    public BasicQosBody createBasicQosBody(long prefetchSize, int prefetchCount, boolean global) {
        return new BasicQosBodyImpl(prefetchSize, prefetchCount, global);
    }

    public BasicQosOkBody createBasicQosOkBody() {
        return new BasicQosOkBodyImpl();
    }

    public BasicConsumeBody createBasicConsumeBody(int ticket, AMQShortString queue, AMQShortString consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, FieldTable arguments) {
        return new BasicConsumeBodyImpl(ticket, queue, consumerTag, noLocal, noAck, exclusive, nowait, arguments);
    }

    public BasicConsumeOkBody createBasicConsumeOkBody(AMQShortString consumerTag) {
        return new BasicConsumeOkBodyImpl(consumerTag);
    }

    public BasicCancelBody createBasicCancelBody(AMQShortString consumerTag, boolean nowait) {
        return new BasicCancelBodyImpl(consumerTag, nowait);
    }

    public BasicCancelOkBody createBasicCancelOkBody(AMQShortString consumerTag) {
        return new BasicCancelOkBodyImpl(consumerTag);
    }

    public BasicPublishBody createBasicPublishBody(int ticket, AMQShortString exchange, AMQShortString routingKey, boolean mandatory, boolean immediate) {
        return new BasicPublishBodyImpl(ticket, exchange, routingKey, mandatory, immediate);
    }

    public BasicReturnBody createBasicReturnBody(int replyCode, AMQShortString replyText, AMQShortString exchange, AMQShortString routingKey) {
        return new BasicReturnBodyImpl(replyCode, replyText, exchange, routingKey);
    }

    public BasicDeliverBody createBasicDeliverBody(AMQShortString consumerTag, long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey) {
        return new BasicDeliverBodyImpl(consumerTag, deliveryTag, redelivered, exchange, routingKey);
    }

    public BasicGetBody createBasicGetBody(int ticket, AMQShortString queue, boolean noAck) {
        return new BasicGetBodyImpl(ticket, queue, noAck);
    }

    public BasicGetOkBody createBasicGetOkBody(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, long messageCount) {
        return new BasicGetOkBodyImpl(deliveryTag, redelivered, exchange, routingKey, messageCount);
    }

    public BasicGetEmptyBody createBasicGetEmptyBody(AMQShortString clusterId) {
        return new BasicGetEmptyBodyImpl(clusterId);
    }

    public BasicAckBody createBasicAckBody(long deliveryTag, boolean multiple) {
        return new BasicAckBodyImpl(deliveryTag, multiple);
    }

    public BasicRejectBody createBasicRejectBody(long deliveryTag, boolean requeue) {
        return new BasicRejectBodyImpl(deliveryTag, requeue);
    }

    public BasicRecoverBody createBasicRecoverBody(boolean requeue) {
        return new BasicRecoverBodyImpl(requeue);
    }

    public BasicRecoverSyncBody createBasicRecoverSyncBody(boolean requeue) {
        return new BasicRecoverSyncBodyImpl(requeue);
    }

    public BasicRecoverSyncOkBody createBasicRecoverSyncOkBody() {
        return new BasicRecoverSyncOkBodyImpl();
    }

    public TxSelectBody createTxSelectBody() {
        return new TxSelectBodyImpl();
    }

    public TxSelectOkBody createTxSelectOkBody() {
        return new TxSelectOkBodyImpl();
    }

    public TxCommitBody createTxCommitBody() {
        return new TxCommitBodyImpl();
    }

    public TxCommitOkBody createTxCommitOkBody() {
        return new TxCommitOkBodyImpl();
    }

    public TxRollbackBody createTxRollbackBody() {
        return new TxRollbackBodyImpl();
    }

    public TxRollbackOkBody createTxRollbackOkBody() {
        return new TxRollbackOkBodyImpl();
    }

    public ProtocolVersionMethodConverter getProtocolVersionMethodConverter() {
        return this._protocolVersionConverter;
    }
}

