/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.BasicMessageConsumer;
import org.apache.qpid.client.Closeable;

class TopicSubscriberAdaptor<C extends BasicMessageConsumer>
implements TopicSubscriber {
    private final Topic _topic;
    private final C _consumer;
    private final boolean _noLocal;

    TopicSubscriberAdaptor(Topic topic, C consumer, boolean noLocal) {
        this._topic = topic;
        this._consumer = consumer;
        this._noLocal = noLocal;
    }

    TopicSubscriberAdaptor(Topic topic, C consumer) {
        this(topic, consumer, ((BasicMessageConsumer)consumer).isNoLocal());
    }

    public Topic getTopic() throws JMSException {
        this.checkPreConditions();
        return this._topic;
    }

    public boolean getNoLocal() throws JMSException {
        this.checkPreConditions();
        return this._noLocal;
    }

    public String getMessageSelector() throws JMSException {
        this.checkPreConditions();
        return ((BasicMessageConsumer)this._consumer).getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkPreConditions();
        return ((BasicMessageConsumer)this._consumer).getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkPreConditions();
        ((BasicMessageConsumer)this._consumer).setMessageListener(messageListener);
    }

    public Message receive() throws JMSException {
        this.checkPreConditions();
        return ((BasicMessageConsumer)this._consumer).receive();
    }

    public Message receive(long l) throws JMSException {
        return ((BasicMessageConsumer)this._consumer).receive(l);
    }

    public Message receiveNoWait() throws JMSException {
        this.checkPreConditions();
        return ((BasicMessageConsumer)this._consumer).receiveNoWait();
    }

    public void close() throws JMSException {
        ((BasicMessageConsumer)this._consumer).close();
    }

    private void checkPreConditions() throws IllegalStateException {
        C msgConsumer = this._consumer;
        if (((Closeable)msgConsumer).isClosed()) {
            throw new IllegalStateException("Consumer is closed");
        }
        if (this._topic == null) {
            throw new UnsupportedOperationException("Topic is null");
        }
        AMQSession session = ((BasicMessageConsumer)msgConsumer).getSession();
        if (session == null || session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
    }

    C getMessageConsumer() {
        return this._consumer;
    }

    public void addBindingKey(Topic topic, String bindingKey) throws AMQException {
        ((BasicMessageConsumer)this._consumer).addBindingKey((AMQDestination)topic, bindingKey);
    }
}

