/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSession_0_10;
import org.apache.qpid.client.BasicMessageProducer;
import org.apache.qpid.client.message.AMQMessageDelegate_0_10;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.messaging.address.Link;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicMessageProducer_0_10
extends BasicMessageProducer {
    private static final Logger _logger = LoggerFactory.getLogger(BasicMessageProducer_0_10.class);
    private byte[] userIDBytes = Strings.toUTF8((String)this.getUserID());

    BasicMessageProducer_0_10(AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, long producerId, Boolean immediate, Boolean mandatory) throws AMQException {
        super(_logger, connection, destination, transacted, channelId, session, producerId, immediate, mandatory);
    }

    @Override
    void declareDestination(AMQDestination destination) throws AMQException {
        if (destination.getDestSyntax() == AMQDestination.DestSyntax.BURL) {
            if (this.getSession().isDeclareExchanges()) {
                String name = destination.getExchangeName().toString();
                ((AMQSession_0_10)this.getSession()).getQpidSession().exchangeDeclare(name, destination.getExchangeClass().toString(), null, null, new Option[]{name.startsWith("amq.") ? Option.PASSIVE : Option.NONE, destination.isExchangeDurable() ? Option.DURABLE : Option.NONE, destination.isExchangeAutoDelete() ? Option.AUTO_DELETE : Option.NONE});
            }
        } else {
            try {
                this.getSession().resolveAddress(destination, false, false);
                ((AMQSession_0_10)this.getSession()).handleLinkCreation(destination);
                ((AMQSession_0_10)this.getSession()).sync();
            }
            catch (Exception e) {
                AMQException ex = new AMQException("Exception occured while verifying destination", (Throwable)e);
                throw ex;
            }
        }
    }

    @Override
    void sendMessage(AMQDestination destination, Message origMessage, AbstractJMSMessage message, UUID messageId, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        ByteBuffer data;
        String exchangeName;
        message.prepareForSending();
        AMQMessageDelegate_0_10 delegate = (AMQMessageDelegate_0_10)message.getDelegate();
        DeliveryProperties deliveryProp = delegate.getDeliveryProperties();
        MessageProperties messageProps = delegate.getMessageProperties();
        messageProps.setUserId(this.userIDBytes);
        if (messageId != null) {
            messageProps.setMessageId(messageId);
        } else if (messageProps.hasMessageId()) {
            messageProps.clearMessageId();
        }
        long currentTime = 0L;
        if (timeToLive > 0L || !this.isDisableTimestamps()) {
            currentTime = System.currentTimeMillis();
        }
        if (timeToLive > 0L) {
            deliveryProp.setTtl(timeToLive);
            message.setJMSExpiration(currentTime + timeToLive);
        }
        if (!this.isDisableTimestamps()) {
            deliveryProp.setTimestamp(currentTime);
            message.setJMSTimestamp(currentTime);
        }
        if (!deliveryProp.hasDeliveryMode() || deliveryProp.getDeliveryMode().getValue() != deliveryMode) {
            MessageDeliveryMode mode;
            switch (deliveryMode) {
                case 2: {
                    mode = MessageDeliveryMode.PERSISTENT;
                    break;
                }
                case 1: {
                    mode = MessageDeliveryMode.NON_PERSISTENT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal delivery mode: " + deliveryMode);
                }
            }
            deliveryProp.setDeliveryMode(mode);
            message.setJMSDeliveryMode(deliveryMode);
        }
        if (!deliveryProp.hasPriority() || deliveryProp.getPriority().getValue() != priority) {
            deliveryProp.setPriority(MessageDeliveryPriority.get((short)((short)priority)));
            message.setJMSPriority(priority);
        }
        String string = exchangeName = destination.getExchangeName() == null ? "" : destination.getExchangeName().toString();
        if (deliveryProp.getExchange() == null || !deliveryProp.getExchange().equals(exchangeName)) {
            deliveryProp.setExchange(exchangeName);
        }
        String routingKey = destination.getRoutingKey().toString();
        if (deliveryProp.getRoutingKey() == null || !deliveryProp.getRoutingKey().equals(routingKey)) {
            deliveryProp.setRoutingKey(routingKey);
        }
        if (destination.getDestSyntax() == AMQDestination.DestSyntax.ADDR && (destination.getSubject() != null || messageProps.getApplicationHeaders() != null && messageProps.getApplicationHeaders().get("qpid.subject") != null)) {
            HashMap<String, String> appProps = messageProps.getApplicationHeaders();
            if (appProps == null) {
                appProps = new HashMap<String, String>();
                messageProps.setApplicationHeaders(appProps);
            }
            if (appProps.get("qpid.subject") == null) {
                appProps.put("qpid.subject", destination.getSubject());
            }
            if (destination.getAddressType() == 2) {
                deliveryProp.setRoutingKey((String)messageProps.getApplicationHeaders().get("qpid.subject"));
            }
        }
        messageProps.setContentLength((data = message.getData()) == null ? 0L : (long)data.remaining());
        try {
            Session ssn = ((AMQSession_0_10)this.getSession()).getQpidSession();
            boolean sync = false;
            sync = this.getPublishMode() == BasicMessageProducer.PublishMode.SYNC_PUBLISH_ALL || this.getPublishMode() == BasicMessageProducer.PublishMode.SYNC_PUBLISH_PERSISTENT && deliveryMode == 2;
            boolean unreliable = destination.getDestSyntax() == AMQDestination.DestSyntax.ADDR && destination.getLink().getReliability() == Link.Reliability.UNRELIABLE;
            ByteBuffer buffer = data == null ? ByteBuffer.allocate(0) : data.slice();
            ssn.messageTransfer(destination.getExchangeName() == null ? "" : destination.getExchangeName().toString(), MessageAcceptMode.NONE, MessageAcquireMode.PRE_ACQUIRED, new Header(deliveryProp, messageProps), buffer, new Option[]{sync ? Option.SYNC : Option.NONE, unreliable ? Option.UNRELIABLE : Option.NONE});
            if (sync) {
                ssn.sync();
                ((AMQSession_0_10)this.getSession()).getCurrentException();
            }
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Exception when sending message:" + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    @Override
    public boolean isBound(AMQDestination destination) throws JMSException {
        return this.getSession().isQueueBound(destination);
    }

    @Override
    public void close() throws JMSException {
        super.close();
        AMQDestination dest = this.getAMQDestination();
        AMQSession_0_10 ssn = (AMQSession_0_10)this.getSession();
        if (!ssn.isClosed() && dest != null && dest.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            try {
                if (dest.getDelete() == AMQDestination.AddressOption.ALWAYS || dest.getDelete() == AMQDestination.AddressOption.SENDER) {
                    ssn.handleNodeDelete(dest);
                }
                ssn.handleLinkDelete(dest);
            }
            catch (TransportException e) {
                throw this.getSession().toJMSException("Exception while closing producer:" + e.getMessage(), e);
            }
            catch (AMQException e) {
                JMSException ex = new JMSException("Exception while closing producer:" + e.getMessage());
                ex.setLinkedException((Exception)((Object)e));
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
    }
}

