/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

public class AMQBrokerDetails
implements BrokerDetails {
    private String _host;
    private int _port;
    private String _transport;
    private Map<String, String> _options = new HashMap<String, String>();

    public AMQBrokerDetails() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AMQBrokerDetails(String url) throws URLSyntaxException {
        try {
            URI connection = new URI(url);
            String transport = connection.getScheme();
            if (transport != null) {
                if (!transport.equalsIgnoreCase("tcp")) {
                    if (transport.equalsIgnoreCase("localhost")) {
                        connection = new URI("tcp://" + url);
                        transport = connection.getScheme();
                    } else {
                        if (url.charAt(transport.length()) != ':' || url.charAt(transport.length() + 1) == '/') throw URLHelper.parseError((int)0, (int)transport.length(), (String)"Unknown transport", (String)url);
                        connection = new URI("tcp://" + url);
                        transport = connection.getScheme();
                    }
                } else if (url.indexOf("//") == -1) {
                    throw new URLSyntaxException(url, "Missing '//' after the transport In broker URL", transport.length() + 1, 1);
                }
            } else {
                connection = new URI("tcp://" + url);
                transport = connection.getScheme();
            }
            if (transport == null) {
                throw URLHelper.parseError((int)-1, (String)("Unknown transport in broker URL:'" + url + "' Format: " + "<transport>://<hostname>[:<port Default=\"5672\">][?<option>='<value>'[,<option>='<value>']]"), (String)"");
            }
            this.setTransport(transport);
            String host = connection.getHost();
            if (host == null) {
                host = "";
                String auth = connection.getAuthority();
                if (auth != null) {
                    host = auth.contains(":") ? auth.substring(0, auth.indexOf(":")) : auth;
                }
            }
            this.setHost(host);
            int port = connection.getPort();
            if (port == -1) {
                String auth = connection.getAuthority();
                if (auth != null && auth.contains(":")) {
                    int start;
                    int end = start = auth.indexOf(":") + 1;
                    boolean looking = true;
                    boolean found = false;
                    if (start == auth.length()) {
                        throw URLHelper.parseError((int)(connection.toString().indexOf(auth) + end - 1), (int)(connection.toString().indexOf(auth) + end), (String)"Port number must be specified", (String)connection.toString());
                    }
                    while (looking) {
                        try {
                            Integer.parseInt(auth.substring(start, ++end));
                            if (end < auth.length()) continue;
                            looking = false;
                            found = true;
                        }
                        catch (NumberFormatException nfe) {
                            looking = false;
                        }
                    }
                    if (!found) throw URLHelper.parseError((int)(connection.toString().indexOf(connection.getAuthority()) + end - 1), (String)"Illegal character in port number", (String)connection.toString());
                    this.setPort(Integer.parseInt(auth.substring(start, end)));
                } else {
                    this.setPort(5672);
                }
            } else {
                this.setPort(port);
            }
            String queryString = connection.getQuery();
            URLHelper.parseOptions(this._options, (String)queryString);
            return;
        }
        catch (URISyntaxException uris) {
            if (!(uris instanceof URLSyntaxException)) throw URLHelper.parseError((int)uris.getIndex(), (String)uris.getReason(), (String)uris.getInput());
            throw (URLSyntaxException)uris;
        }
    }

    public AMQBrokerDetails(String host, int port) {
        this._host = host;
        this._port = port;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public void setHost(String _host) {
        this._host = _host;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public void setPort(int _port) {
        this._port = _port;
    }

    @Override
    public String getTransport() {
        return this._transport;
    }

    @Override
    public void setTransport(String _transport) {
        this._transport = _transport;
    }

    @Override
    public String getProperty(String key) {
        return this._options.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this._options.put(key, value);
    }

    private int lookupConnectTimeout() {
        if (this._options.containsKey("connecttimeout")) {
            try {
                return Integer.parseInt(this._options.get("connecttimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 30000;
    }

    @Override
    public boolean getBooleanProperty(String propName) {
        return this.getBooleanProperty(propName, false);
    }

    public boolean getBooleanProperty(String propName, boolean defaultValue) {
        if (this._options.containsKey(propName)) {
            if (this._options.get(propName).equalsIgnoreCase("false")) {
                return false;
            }
            if (this._options.get(propName).equalsIgnoreCase("true")) {
                return true;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    private int getIntegerProperty(String key) {
        String stringValue = this.getProperty(key);
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse key " + key + " with value '" + stringValue + "' as integer.", e);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._transport);
        sb.append("://");
        sb.append(this._host);
        sb.append(':');
        sb.append(this._port);
        sb.append(this.printOptionsURL());
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BrokerDetails)) {
            return false;
        }
        BrokerDetails bd = (BrokerDetails)o;
        return this._host.toLowerCase().equals(bd.getHost() == null ? null : bd.getHost().toLowerCase()) && this._port == bd.getPort() && this._transport.toLowerCase().equals(bd.getTransport() == null ? null : bd.getTransport().toLowerCase());
    }

    public int hashCode() {
        int result = this._host != null ? this._host.toLowerCase().hashCode() : 0;
        result = 31 * result + this._port;
        result = 31 * result + (this._transport != null ? this._transport.toLowerCase().hashCode() : 0);
        return result;
    }

    private String printOptionsURL() {
        StringBuffer optionsURL = new StringBuffer();
        optionsURL.append('?');
        if (!this._options.isEmpty()) {
            for (String key : this._options.keySet()) {
                optionsURL.append(key);
                optionsURL.append("='");
                if ("trust_store_password".equals(key) || "key_store_password".equals(key)) {
                    optionsURL.append("********");
                } else {
                    optionsURL.append(this._options.get(key));
                }
                optionsURL.append("'");
                optionsURL.append('&');
            }
        }
        optionsURL.deleteCharAt(optionsURL.length() - 1);
        return optionsURL.toString();
    }

    public static String checkTransport(String broker) {
        if (!broker.contains("://")) {
            return "tcp://" + broker;
        }
        return broker;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._options;
    }

    @Override
    public void setProperties(Map<String, String> props) {
        this._options = props;
    }

    @Override
    public ConnectionSettings buildConnectionSettings() {
        ConnectionSettings conSettings = new ConnectionSettings();
        conSettings.setHost(this.getHost());
        conSettings.setPort(this.getPort());
        if (this.getProperty("sasl_mechs") != null) {
            conSettings.setSaslMechs(this.getProperty("sasl_mechs"));
        }
        if (this.getProperty("sasl_protocol") != null) {
            conSettings.setSaslProtocol(this.getProperty("sasl_protocol"));
        }
        if (this.getProperty("sasl_server") != null) {
            conSettings.setSaslServerName(this.getProperty("sasl_server"));
        }
        conSettings.setUseSASLEncryption(this.getBooleanProperty("sasl_encryption"));
        conSettings.setUseSSL(this.getBooleanProperty("ssl"));
        if (this.getProperty("trust_store") != null) {
            conSettings.setTrustStorePath(this.getProperty("trust_store"));
        }
        if (this.getProperty("trust_store_password") != null) {
            conSettings.setTrustStorePassword(this.getProperty("trust_store_password"));
        }
        if (this.getProperty("key_store") != null) {
            conSettings.setKeyStorePath(this.getProperty("key_store"));
        }
        if (this.getProperty("key_store_password") != null) {
            conSettings.setKeyStorePassword(this.getProperty("key_store_password"));
        }
        if (this.getProperty("ssl_cert_alias") != null) {
            conSettings.setCertAlias(this.getProperty("ssl_cert_alias"));
        }
        conSettings.setVerifyHostname(this.getBooleanProperty("ssl_verify_hostname"));
        if (this.getProperty("tcp_nodelay") != null) {
            conSettings.setTcpNodelay(this.getBooleanProperty("tcp_nodelay", true));
        }
        conSettings.setConnectTimeout(this.lookupConnectTimeout());
        if (this.getProperty("heartbeat") != null) {
            conSettings.setHeartbeatInterval(this.getIntegerProperty("heartbeat"));
        } else if (this.getProperty("idle_timeout") != null) {
            conSettings.setHeartbeatInterval(this.getIntegerProperty("idle_timeout") / 1000);
        }
        return conSettings;
    }
}

