/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.plugins;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.configuration.plugins.SlowConsumerDetectionQueueConfiguration;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredQueueBindingListener
implements Exchange.BindingListener {
    private static final Logger _log = Logger.getLogger(ConfiguredQueueBindingListener.class);
    private String _vhostName;
    private Set<AMQQueue> _cache = Collections.synchronizedSet(new HashSet());

    public ConfiguredQueueBindingListener(String vhostName) {
        this._vhostName = vhostName;
    }

    @Override
    public void bindingAdded(Exchange exchange, Binding binding) {
        this.processBinding(binding);
    }

    @Override
    public void bindingRemoved(Exchange exchange, Binding binding) {
        this.processBinding(binding);
    }

    private void processBinding(Binding binding) {
        AMQQueue queue = binding.getQueue();
        SlowConsumerDetectionQueueConfiguration config = (SlowConsumerDetectionQueueConfiguration)queue.getConfiguration().getConfiguration(SlowConsumerDetectionQueueConfiguration.class.getName());
        if (config != null) {
            this._cache.add(queue);
        } else {
            this._cache.remove(queue);
        }
    }

    public Set<AMQQueue> getQueueCache() {
        return new HashSet<AMQQueue>(this._cache);
    }
}

