/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Xid;

public class DtxBranch {
    private static final Logger _logger = Logger.getLogger(DtxBranch.class);
    private final Xid _xid;
    private final List<ServerTransaction.Action> _postTransactionActions = new ArrayList<ServerTransaction.Action>();
    private State _state = State.ACTIVE;
    private long _timeout;
    private Map<AMQSessionModel, State> _associatedSessions = new HashMap<AMQSessionModel, State>();
    private final List<Record> _enqueueRecords = new ArrayList<Record>();
    private final List<Record> _dequeueRecords = new ArrayList<Record>();
    private Transaction _transaction;
    private long _expiration;
    private VirtualHost _vhost;
    private ScheduledFuture<?> _timeoutFuture;
    private MessageStore _store;

    public DtxBranch(Xid xid, MessageStore store, VirtualHost vhost) {
        this._xid = xid;
        this._store = store;
        this._vhost = vhost;
    }

    public Xid getXid() {
        return this._xid;
    }

    public State getState() {
        return this._state;
    }

    public void setState(State state) {
        this._state = state;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        if (this._timeoutFuture != null) {
            this._timeoutFuture.cancel(false);
        }
        this._timeout = timeout;
        this._expiration = timeout == 0L ? 0L : System.currentTimeMillis() + 1000L * timeout;
        this._timeoutFuture = this._timeout == 0L ? null : this._vhost.scheduleTask(1000L * this._timeout, new Runnable(){

            public void run() {
                DtxBranch.this.setState(State.TIMEDOUT);
                try {
                    DtxBranch.this.rollback();
                }
                catch (AMQStoreException e) {
                    _logger.error((Object)("Unexpected error when attempting to rollback XA transaction (" + DtxBranch.this._xid + ") due to  timeout"), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public boolean expired() {
        return this._timeout != 0L && this._expiration < System.currentTimeMillis();
    }

    public synchronized boolean isAssociated(AMQSessionModel session) {
        return this._associatedSessions.containsKey(session);
    }

    public synchronized boolean hasAssociatedSessions() {
        return !this._associatedSessions.isEmpty();
    }

    public synchronized boolean hasAssociatedActiveSessions() {
        if (this.hasAssociatedSessions()) {
            for (State state : this._associatedSessions.values()) {
                if (state == State.SUSPENDED) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void clearAssociations() {
        this._associatedSessions.clear();
    }

    synchronized boolean associateSession(AMQSessionModel associatedSession) {
        return this._associatedSessions.put(associatedSession, State.ACTIVE) != null;
    }

    synchronized boolean disassociateSession(AMQSessionModel associatedSession) {
        return this._associatedSessions.remove(associatedSession) != null;
    }

    public synchronized boolean resumeSession(AMQSessionModel session) {
        if (this._associatedSessions.containsKey(session) && this._associatedSessions.get(session) == State.SUSPENDED) {
            this._associatedSessions.put(session, State.ACTIVE);
            return true;
        }
        return false;
    }

    public synchronized boolean suspendSession(AMQSessionModel session) {
        if (this._associatedSessions.containsKey(session) && this._associatedSessions.get(session) == State.ACTIVE) {
            this._associatedSessions.put(session, State.SUSPENDED);
            return true;
        }
        return false;
    }

    public void prepare() throws AMQStoreException {
        Transaction txn = this._store.newTransaction();
        txn.recordXid(this._xid.getFormat(), this._xid.getGlobalId(), this._xid.getBranchId(), this._enqueueRecords.toArray(new Record[this._enqueueRecords.size()]), this._dequeueRecords.toArray(new Record[this._dequeueRecords.size()]));
        txn.commitTran();
        this.prePrepareTransaction();
    }

    public synchronized void rollback() throws AMQStoreException {
        if (this._timeoutFuture != null) {
            this._timeoutFuture.cancel(false);
            this._timeoutFuture = null;
        }
        if (this._transaction != null) {
            Transaction txn = this._store.newTransaction();
            txn.removeXid(this._xid.getFormat(), this._xid.getGlobalId(), this._xid.getBranchId());
            txn.commitTran();
            this._transaction.abortTran();
        }
        for (ServerTransaction.Action action : this._postTransactionActions) {
            action.onRollback();
        }
        this._postTransactionActions.clear();
    }

    public void commit() throws AMQStoreException {
        if (this._timeoutFuture != null) {
            this._timeoutFuture.cancel(false);
            this._timeoutFuture = null;
        }
        if (this._transaction == null) {
            this.prePrepareTransaction();
        } else {
            this._transaction.removeXid(this._xid.getFormat(), this._xid.getGlobalId(), this._xid.getBranchId());
        }
        this._transaction.commitTran();
        for (ServerTransaction.Action action : this._postTransactionActions) {
            action.postCommit();
        }
        this._postTransactionActions.clear();
    }

    public void prePrepareTransaction() throws AMQStoreException {
        this._transaction = this._store.newTransaction();
        for (Record enqueue : this._enqueueRecords) {
            if (!enqueue.isDurable()) continue;
            this._transaction.enqueueMessage(enqueue.getQueue(), enqueue.getMessage());
        }
        for (Record enqueue : this._dequeueRecords) {
            if (!enqueue.isDurable()) continue;
            this._transaction.dequeueMessage(enqueue.getQueue(), enqueue.getMessage());
        }
    }

    public void addPostTransactionAcion(ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
    }

    public void dequeue(BaseQueue queue, EnqueableMessage message) {
        this._dequeueRecords.add(new Record(queue, message));
    }

    public void enqueue(BaseQueue queue, EnqueableMessage message) {
        this._enqueueRecords.add(new Record(queue, message));
    }

    public void close() {
        if (this._transaction != null) {
            try {
                this._state = null;
                this._transaction.abortTran();
            }
            catch (AMQStoreException e) {
                _logger.error((Object)"Error while closing XA branch", (Throwable)e);
            }
        }
    }

    private static final class Record
    implements Transaction.Record {
        private final BaseQueue _queue;
        private final EnqueableMessage _message;

        public Record(BaseQueue queue, EnqueableMessage message) {
            this._queue = queue;
            this._message = message;
        }

        public BaseQueue getQueue() {
            return this._queue;
        }

        public EnqueableMessage getMessage() {
            return this._message;
        }

        public boolean isDurable() {
            return this._message.isPersistent() && this._queue.isDurable();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ACTIVE,
        PREPARED,
        TIMEDOUT,
        SUSPENDED,
        FORGOTTEN,
        HEUR_COM,
        HEUR_RB,
        ROLLBACK_ONLY;

    }
}

