/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.txn.ServerTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAutoCommitTransaction
implements ServerTransaction {
    static final String QPID_STRICT_ORDER_WITH_MIXED_DELIVERY_MODE = "qpid.strict_order_with_mixed_delivery_mode";
    protected static final Logger _logger = Logger.getLogger(AsyncAutoCommitTransaction.class);
    private final MessageStore _messageStore;
    private final FutureRecorder _futureRecorder;
    private boolean _strictOrderWithMixedDeliveryMode = Boolean.getBoolean("qpid.strict_order_with_mixed_delivery_mode");

    public AsyncAutoCommitTransaction(MessageStore transactionLog, FutureRecorder recorder) {
        this._messageStore = transactionLog;
        this._futureRecorder = recorder;
    }

    @Override
    public long getTransactionStartTime() {
        return 0L;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action immediateAction) {
        this.addFuture(StoreFuture.IMMEDIATE_FUTURE, immediateAction);
    }

    @Override
    public void dequeue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        Transaction txn = null;
        try {
            StoreFuture future;
            if (message.isPersistent() && queue.isDurable()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString()));
                }
                txn = this._messageStore.newTransaction();
                txn.dequeueMessage(queue, message);
                future = txn.commitTranAsync();
                txn = null;
            } else {
                future = StoreFuture.IMMEDIATE_FUTURE;
            }
            this.addFuture(future, postTransactionAction);
            postTransactionAction = null;
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
        catch (AMQException e) {
            try {
                _logger.error((Object)"Error during message dequeue", (Throwable)e);
                throw new RuntimeException("Error during message dequeue", e);
            }
            catch (Throwable throwable) {
                this.rollbackIfNecessary(postTransactionAction, txn);
                throw throwable;
            }
        }
    }

    private void addFuture(StoreFuture future, ServerTransaction.Action action) {
        if (action != null) {
            if (future.isComplete()) {
                action.postCommit();
            } else {
                this._futureRecorder.recordFuture(future, action);
            }
        }
    }

    private void addEnqueueFuture(StoreFuture future, ServerTransaction.Action action, boolean persistent) {
        if (action != null) {
            if (future.isComplete() && !persistent && !this._strictOrderWithMixedDeliveryMode) {
                action.postCommit();
            } else {
                this._futureRecorder.recordFuture(future, action);
            }
        }
    }

    @Override
    public void dequeue(Collection<QueueEntry> queueEntries, ServerTransaction.Action postTransactionAction) {
        Transaction txn = null;
        try {
            StoreFuture future;
            for (QueueEntry entry : queueEntries) {
                ServerMessage message = entry.getMessage();
                AMQQueue queue = entry.getQueue();
                if (!message.isPersistent() || !queue.isDurable()) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString()));
                }
                if (txn == null) {
                    txn = this._messageStore.newTransaction();
                }
                txn.dequeueMessage(queue, message);
            }
            if (txn != null) {
                future = txn.commitTranAsync();
                txn = null;
            } else {
                future = StoreFuture.IMMEDIATE_FUTURE;
            }
            this.addFuture(future, postTransactionAction);
            postTransactionAction = null;
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
        catch (AMQException e) {
            try {
                _logger.error((Object)"Error during message dequeues", (Throwable)e);
                throw new RuntimeException("Error during message dequeues", e);
            }
            catch (Throwable throwable) {
                this.rollbackIfNecessary(postTransactionAction, txn);
                throw throwable;
            }
        }
    }

    @Override
    public void enqueue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        Transaction txn = null;
        try {
            StoreFuture future;
            if (message.isPersistent() && queue.isDurable()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + queue.getNameShortString()));
                }
                txn = this._messageStore.newTransaction();
                txn.enqueueMessage(queue, message);
                future = txn.commitTranAsync();
                txn = null;
            } else {
                future = StoreFuture.IMMEDIATE_FUTURE;
            }
            this.addEnqueueFuture(future, postTransactionAction, message.isPersistent());
            postTransactionAction = null;
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
        catch (AMQException e) {
            try {
                _logger.error((Object)"Error during message enqueue", (Throwable)e);
                throw new RuntimeException("Error during message enqueue", e);
            }
            catch (Throwable throwable) {
                this.rollbackIfNecessary(postTransactionAction, txn);
                throw throwable;
            }
        }
    }

    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueableMessage message, ServerTransaction.Action postTransactionAction, long currentTime) {
        Transaction txn = null;
        try {
            StoreFuture future;
            if (message.isPersistent()) {
                for (BaseQueue baseQueue : queues) {
                    if (!baseQueue.isDurable()) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + baseQueue.getNameShortString()));
                    }
                    if (txn == null) {
                        txn = this._messageStore.newTransaction();
                    }
                    txn.enqueueMessage(baseQueue, message);
                }
            }
            if (txn != null) {
                future = txn.commitTranAsync();
                txn = null;
            } else {
                future = StoreFuture.IMMEDIATE_FUTURE;
            }
            this.addEnqueueFuture(future, postTransactionAction, message.isPersistent());
            postTransactionAction = null;
            this.rollbackIfNecessary(postTransactionAction, txn);
        }
        catch (AMQException e) {
            try {
                _logger.error((Object)"Error during message enqueues", (Throwable)e);
                throw new RuntimeException("Error during message enqueues", e);
            }
            catch (Throwable throwable) {
                this.rollbackIfNecessary(postTransactionAction, txn);
                throw throwable;
            }
        }
    }

    @Override
    public void commit(final Runnable immediatePostTransactionAction) {
        if (immediatePostTransactionAction != null) {
            this.addFuture(StoreFuture.IMMEDIATE_FUTURE, new ServerTransaction.Action(){

                public void postCommit() {
                    immediatePostTransactionAction.run();
                }

                public void onRollback() {
                }
            });
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    private void rollbackIfNecessary(ServerTransaction.Action postTransactionAction, Transaction txn) {
        if (txn != null) {
            try {
                txn.abortTran();
            }
            catch (AMQStoreException e) {
                _logger.error((Object)"Abort transaction failed", (Throwable)e);
            }
        }
        if (postTransactionAction != null) {
            postTransactionAction.onRollback();
        }
    }

    public static interface FutureRecorder {
        public void recordFuture(StoreFuture var1, ServerTransaction.Action var2);
    }
}

