/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.store.ConfigurationRecoveryHandler;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.util.MapJsonSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredObjectHelper {
    private MapJsonSerializer _serializer = new MapJsonSerializer();

    public void loadQueue(ConfiguredObjectRecord configuredObject, ConfigurationRecoveryHandler.QueueRecoveryHandler qrh) {
        if (Queue.class.getName().equals(configuredObject.getType())) {
            Map<String, Object> attributeMap = this._serializer.deserialize(configuredObject.getAttributes());
            String queueName = (String)attributeMap.get("name");
            String owner = (String)attributeMap.get("owner");
            boolean exclusive = (Boolean)attributeMap.get("exclusive");
            UUID alternateExchangeId = attributeMap.get("alternateExchange") == null ? null : UUID.fromString((String)attributeMap.get("alternateExchange"));
            Map queueArgumentsMap = (Map)attributeMap.get("arguments");
            FieldTable arguments = null;
            if (queueArgumentsMap != null) {
                arguments = FieldTable.convertToFieldTable((Map)queueArgumentsMap);
            }
            qrh.queue(configuredObject.getId(), queueName, owner, exclusive, arguments, alternateExchangeId);
        }
    }

    public ConfiguredObjectRecord updateQueueConfiguredObject(AMQQueue queue, ConfiguredObjectRecord queueRecord) {
        Map<String, Object> attributesMap = this._serializer.deserialize(queueRecord.getAttributes());
        attributesMap.put("name", queue.getName());
        attributesMap.put("exclusive", queue.isExclusive());
        if (queue.getAlternateExchange() != null) {
            attributesMap.put("alternateExchange", queue.getAlternateExchange().getId());
        } else {
            attributesMap.remove("alternateExchange");
        }
        if (attributesMap.containsKey("arguments")) {
            Map currentArgs = (Map)attributesMap.get("arguments");
            currentArgs.putAll(queue.getArguments());
        } else {
            attributesMap.put("arguments", queue.getArguments());
        }
        String newJson = this._serializer.serialize(attributesMap);
        ConfiguredObjectRecord newQueueRecord = new ConfiguredObjectRecord(queue.getId(), queueRecord.getType(), newJson);
        return newQueueRecord;
    }

    public ConfiguredObjectRecord createQueueConfiguredObject(AMQQueue queue, FieldTable arguments) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", queue.getName());
        attributesMap.put("owner", AMQShortString.toString((AMQShortString)queue.getOwner()));
        attributesMap.put("exclusive", queue.isExclusive());
        if (queue.getAlternateExchange() != null) {
            attributesMap.put("alternateExchange", queue.getAlternateExchange().getId());
        }
        if (arguments != null) {
            attributesMap.put("arguments", FieldTable.convertToMap((FieldTable)arguments));
        }
        String json = this._serializer.serialize(attributesMap);
        ConfiguredObjectRecord configuredObject = new ConfiguredObjectRecord(queue.getId(), Queue.class.getName(), json);
        return configuredObject;
    }

    public void loadExchange(ConfiguredObjectRecord configuredObject, ConfigurationRecoveryHandler.ExchangeRecoveryHandler erh) {
        if (org.apache.qpid.server.model.Exchange.class.getName().equals(configuredObject.getType())) {
            Map<String, Object> attributeMap = this._serializer.deserialize(configuredObject.getAttributes());
            String exchangeName = (String)attributeMap.get("name");
            String exchangeType = (String)attributeMap.get("type");
            String lifeTimePolicy = (String)attributeMap.get("lifetimePolicy");
            boolean autoDelete = lifeTimePolicy == null || LifetimePolicy.valueOf(lifeTimePolicy) == LifetimePolicy.AUTO_DELETE;
            erh.exchange(configuredObject.getId(), exchangeName, exchangeType, autoDelete);
        }
    }

    public ConfiguredObjectRecord createExchangeConfiguredObject(Exchange exchange) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", exchange.getName());
        attributesMap.put("type", AMQShortString.toString((AMQShortString)exchange.getTypeShortString()));
        attributesMap.put("lifetimePolicy", exchange.isAutoDelete() ? LifetimePolicy.AUTO_DELETE.name() : LifetimePolicy.PERMANENT.name());
        String json = this._serializer.serialize(attributesMap);
        ConfiguredObjectRecord configuredObject = new ConfiguredObjectRecord(exchange.getId(), org.apache.qpid.server.model.Exchange.class.getName(), json);
        return configuredObject;
    }

    public void loadQueueBinding(ConfiguredObjectRecord configuredObject, ConfigurationRecoveryHandler.BindingRecoveryHandler brh) {
        if (org.apache.qpid.server.model.Binding.class.getName().equals(configuredObject.getType())) {
            Map<String, Object> attributeMap = this._serializer.deserialize(configuredObject.getAttributes());
            UUID exchangeId = UUID.fromString((String)attributeMap.get("exchange"));
            UUID queueId = UUID.fromString((String)attributeMap.get("queue"));
            String bindingName = (String)attributeMap.get("name");
            Map bindingArgumentsMap = (Map)attributeMap.get("arguments");
            FieldTable arguments = null;
            if (bindingArgumentsMap != null) {
                arguments = FieldTable.convertToFieldTable((Map)bindingArgumentsMap);
            }
            ByteBuffer argumentsBB = arguments == null ? null : ByteBuffer.wrap(arguments.getDataAsBytes());
            brh.binding(configuredObject.getId(), exchangeId, queueId, bindingName, argumentsBB);
        }
    }

    public ConfiguredObjectRecord createBindingConfiguredObject(Binding binding) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        attributesMap.put("name", binding.getBindingKey());
        attributesMap.put("exchange", binding.getExchange().getId());
        attributesMap.put("queue", binding.getQueue().getId());
        Map<String, Object> arguments = binding.getArguments();
        if (arguments != null) {
            attributesMap.put("arguments", arguments);
        }
        String json = this._serializer.serialize(attributesMap);
        ConfiguredObjectRecord configuredObject = new ConfiguredObjectRecord(binding.getId(), org.apache.qpid.server.model.Binding.class.getName(), json);
        return configuredObject;
    }

    public void recoverQueues(ConfigurationRecoveryHandler.QueueRecoveryHandler qrh, List<ConfiguredObjectRecord> configuredObjects) {
        for (ConfiguredObjectRecord configuredObjectRecord : configuredObjects) {
            this.loadQueue(configuredObjectRecord, qrh);
        }
    }

    public void recoverExchanges(ConfigurationRecoveryHandler.ExchangeRecoveryHandler erh, List<ConfiguredObjectRecord> configuredObjects) {
        for (ConfiguredObjectRecord configuredObjectRecord : configuredObjects) {
            this.loadExchange(configuredObjectRecord, erh);
        }
    }

    public void recoverBindings(ConfigurationRecoveryHandler.BindingRecoveryHandler brh, List<ConfiguredObjectRecord> configuredObjects) {
        for (ConfiguredObjectRecord configuredObjectRecord : configuredObjects) {
            this.loadQueueBinding(configuredObjectRecord, brh);
        }
    }
}

