/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.stats;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsCounter {
    private static final Logger _log = LoggerFactory.getLogger(StatisticsCounter.class);
    public static final long DEFAULT_SAMPLE_PERIOD = Long.getLong("qpid.statistics.samplePeriod", 2000L);
    private static final String COUNTER = "counter";
    private static final AtomicLong _counterIds = new AtomicLong(0L);
    private long _peak = 0L;
    private long _total = 0L;
    private long _temp = 0L;
    private long _last = 0L;
    private long _rate = 0L;
    private long _start;
    private final long _period;
    private final String _name;

    public StatisticsCounter() {
        this(COUNTER);
    }

    public StatisticsCounter(String name) {
        this(name, DEFAULT_SAMPLE_PERIOD);
    }

    public StatisticsCounter(String name, long period) {
        this._period = period;
        this._name = name + "-" + _counterIds.incrementAndGet();
        this.reset();
    }

    public void registerEvent() {
        this.registerEvent(1L);
    }

    public void registerEvent(long value) {
        this.registerEvent(value, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEvent(long value, long timestamp) {
        long thisSample = timestamp / this._period;
        StatisticsCounter statisticsCounter = this;
        synchronized (statisticsCounter) {
            if (thisSample > this._last) {
                this._last = thisSample;
                this._rate = this._temp;
                this._temp = 0L;
                if (this._rate > this._peak) {
                    this._peak = this._rate;
                }
            }
            this._total += value;
            this._temp += value;
        }
    }

    private void update() {
        this.registerEvent(0L, System.currentTimeMillis());
    }

    public void reset() {
        _log.info("Resetting statistics for counter: " + this._name);
        this._peak = 0L;
        this._rate = 0L;
        this._total = 0L;
        this._start = System.currentTimeMillis();
        this._last = this._start / this._period;
    }

    public double getPeak() {
        this.update();
        return (double)this._peak / ((double)this._period / 1000.0);
    }

    public double getRate() {
        this.update();
        return (double)this._rate / ((double)this._period / 1000.0);
    }

    public long getTotal() {
        return this._total;
    }

    public long getStart() {
        return this._start;
    }

    public Date getStartTime() {
        return new Date(this._start);
    }

    public String getName() {
        return this._name;
    }

    public long getPeriod() {
        return this._period;
    }
}

