/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.plugins.Plugin;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.apache.qpid.server.security.auth.manager.IAuthenticationManagerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationManagerRegistry
implements Closeable,
IAuthenticationManagerRegistry {
    private final Map<String, AuthenticationManager> _classToAuthManagerMap = new HashMap<String, AuthenticationManager>();
    private final AuthenticationManager _defaultAuthenticationManager;
    private final Map<Integer, AuthenticationManager> _portToAuthenticationManagerMap;
    private final List<IAuthenticationManagerRegistry.RegistryChangeListener> _listeners = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationManagerRegistry(ServerConfiguration serverConfiguration, PluginManager _pluginManager) throws ConfigurationException {
        Collection<AuthenticationManagerPluginFactory<? extends Plugin>> factories = _pluginManager.getAuthenticationManagerPlugins().values();
        if (factories.size() == 0) {
            throw new ConfigurationException("No authentication manager factory plugins found. Check the desired authentication manager plugin has been placed in the plugins directory.");
        }
        SecurityManager.SecurityConfiguration securityConfiguration = (SecurityManager.SecurityConfiguration)serverConfiguration.getConfiguration(SecurityManager.SecurityConfiguration.class.getName());
        boolean willClose = true;
        try {
            this.createAuthenticationManagersRejectingDuplicates(factories, securityConfiguration);
            if (this._classToAuthManagerMap.isEmpty()) {
                throw new ConfigurationException("No authentication managers configured within the configuration file.");
            }
            this._defaultAuthenticationManager = this.getDefaultAuthenticationManager(serverConfiguration);
            this._portToAuthenticationManagerMap = this.getPortToAuthenticationManagerMap(serverConfiguration);
            willClose = false;
            Object var7_6 = null;
            if (willClose) {
                this.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (willClose) {
                this.close();
            }
            throw throwable;
        }
    }

    @Override
    public AuthenticationManager getAuthenticationManager(SocketAddress address) {
        AuthenticationManager authManager = address instanceof InetSocketAddress ? this._portToAuthenticationManagerMap.get(((InetSocketAddress)address).getPort()) : null;
        return authManager == null ? this._defaultAuthenticationManager : authManager;
    }

    public void close() {
        for (AuthenticationManager authManager : this._classToAuthManagerMap.values()) {
            authManager.close();
        }
    }

    private void createAuthenticationManagersRejectingDuplicates(Collection<AuthenticationManagerPluginFactory<? extends Plugin>> factories, SecurityManager.SecurityConfiguration securityConfiguration) throws ConfigurationException {
        for (AuthenticationManagerPluginFactory<? extends Plugin> factory : factories) {
            AuthenticationManager tmp = (AuthenticationManager)factory.newInstance(securityConfiguration);
            if (tmp == null) continue;
            if (this._classToAuthManagerMap.containsKey(tmp.getClass().getSimpleName())) {
                throw new ConfigurationException("Cannot configure more than one authentication manager of type " + tmp.getClass().getSimpleName() + "." + " Remove configuration for one of the authentication managers.");
            }
            this._classToAuthManagerMap.put(tmp.getClass().getSimpleName(), tmp);
            for (IAuthenticationManagerRegistry.RegistryChangeListener listener : this._listeners) {
                listener.authenticationManagerRegistered(tmp);
            }
        }
    }

    private AuthenticationManager getDefaultAuthenticationManager(ServerConfiguration serverConfiguration) throws ConfigurationException {
        AuthenticationManager defaultAuthenticationManager;
        if (this._classToAuthManagerMap.size() == 1) {
            defaultAuthenticationManager = this._classToAuthManagerMap.values().iterator().next();
        } else if (serverConfiguration.getDefaultAuthenticationManager() != null) {
            defaultAuthenticationManager = this._classToAuthManagerMap.get(serverConfiguration.getDefaultAuthenticationManager());
            if (defaultAuthenticationManager == null) {
                throw new ConfigurationException("No authentication managers configured of type " + serverConfiguration.getDefaultAuthenticationManager() + " which is specified as the default.  Available managers are: " + this._classToAuthManagerMap.keySet());
            }
        } else {
            throw new ConfigurationException("If more than one authentication manager is configured a default MUST be specified.");
        }
        return defaultAuthenticationManager;
    }

    private Map<Integer, AuthenticationManager> getPortToAuthenticationManagerMap(ServerConfiguration serverConfiguration) throws ConfigurationException {
        HashMap<Integer, AuthenticationManager> portToAuthenticationManagerMap = new HashMap<Integer, AuthenticationManager>();
        for (Map.Entry<Integer, String> portMapping : serverConfiguration.getPortAuthenticationMappings().entrySet()) {
            AuthenticationManager authenticationManager = this._classToAuthManagerMap.get(portMapping.getValue());
            if (authenticationManager == null) {
                throw new ConfigurationException("Unknown authentication manager class " + portMapping.getValue() + " configured for port " + portMapping.getKey());
            }
            portToAuthenticationManagerMap.put(portMapping.getKey(), authenticationManager);
        }
        return portToAuthenticationManagerMap;
    }

    @Override
    public Map<String, AuthenticationManager> getAvailableAuthenticationManagers() {
        return Collections.unmodifiableMap(new HashMap<String, AuthenticationManager>(this._classToAuthManagerMap));
    }

    @Override
    public void addRegistryChangeListener(IAuthenticationManagerRegistry.RegistryChangeListener listener) {
        this._listeners.add(listener);
    }
}

