/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.configuration.BrokerConfig;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfigurationManager;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.IAuthenticationManagerRegistry;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IApplicationRegistry
extends StatisticsGatherer {
    public void initialise() throws Exception;

    public void close();

    public ServerConfiguration getConfiguration();

    public AuthenticationManager getAuthenticationManager(SocketAddress var1);

    public IAuthenticationManagerRegistry getAuthenticationManagerRegistry();

    public VirtualHostRegistry getVirtualHostRegistry();

    public SecurityManager getSecurityManager();

    public PluginManager getPluginManager();

    public ConfigurationManager getConfigurationManager();

    public RootMessageLogger getRootMessageLogger();

    public void addAcceptor(InetSocketAddress var1, QpidAcceptor var2);

    public UUID getBrokerId();

    public QMFService getQMFService();

    public void setBrokerConfig(BrokerConfig var1);

    public BrokerConfig getBrokerConfig();

    public Broker getBroker();

    public VirtualHost createVirtualHost(VirtualHostConfiguration var1) throws Exception;

    public ConfigStore getConfigStore();

    public void setConfigStore(ConfigStore var1);

    public void initialiseStatisticsReporting();

    public Map<InetSocketAddress, QpidAcceptor> getAcceptors();

    public void addPortBindingListener(PortBindingListener var1);

    public boolean useHTTPManagement();

    public int getHTTPManagementPort();

    public boolean useHTTPSManagement();

    public int getHTTPSManagementPort();

    public void addRegistryChangeListener(IAuthenticationManagerRegistry.RegistryChangeListener var1);

    public static interface PortBindingListener {
        public void bound(QpidAcceptor var1, InetSocketAddress var2);

        public void unbound(QpidAcceptor var1);
    }
}

