/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryListFactory;
import org.apache.qpid.server.queue.SimpleQueueEntryImpl;
import org.apache.qpid.server.queue.SimpleQueueEntryList;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflationQueueList
extends SimpleQueueEntryList {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConflationQueueList.class);
    private final String _conflationKey;
    private final ConcurrentHashMap<Object, AtomicReference<QueueEntry>> _latestValuesMap = new ConcurrentHashMap();
    private final QueueEntry _deleteInProgress = new SimpleQueueEntryImpl(this);
    private final QueueEntry _newerEntryAlreadyBeenAndGone = new SimpleQueueEntryImpl(this);

    public ConflationQueueList(AMQQueue queue, String conflationKey) {
        super(queue);
        this._conflationKey = conflationKey;
    }

    public String getConflationKey() {
        return this._conflationKey;
    }

    protected ConflationQueueEntry createQueueEntry(ServerMessage message) {
        return new ConflationQueueEntry(this, message);
    }

    @Override
    public ConflationQueueEntry add(ServerMessage message) {
        ConflationQueueEntry addedEntry = (ConflationQueueEntry)super.add(message);
        Object keyValue = message.getMessageHeader().getHeader(this._conflationKey);
        if (keyValue != null) {
            boolean entryFromMapIsOlder;
            QueueEntry entryFromMap;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding entry " + addedEntry + " for message " + message.getMessageNumber() + " with conflation key " + keyValue);
            }
            AtomicReference<QueueEntry> referenceToEntry = new AtomicReference<QueueEntry>(addedEntry);
            AtomicReference<QueueEntry> entryReferenceFromMap = null;
            boolean keepTryingToUpdateEntryReference = true;
            while ((entryFromMap = (entryReferenceFromMap = this.getOrPutIfAbsent(keyValue, referenceToEntry)).get()) == this._deleteInProgress || (keepTryingToUpdateEntryReference = (entryFromMapIsOlder = entryFromMap != this._newerEntryAlreadyBeenAndGone && entryFromMap.compareTo(addedEntry) < 0) && !entryReferenceFromMap.compareAndSet(entryFromMap, addedEntry))) {
            }
            if (entryFromMap == this._newerEntryAlreadyBeenAndGone) {
                this.discardEntry(addedEntry);
            } else if (entryFromMap.compareTo(addedEntry) > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("New entry " + addedEntry.getEntryId() + " for message " + addedEntry.getMessage().getMessageNumber() + " being immediately discarded because a newer entry arrived. The newer entry is: " + entryFromMap + " for message " + entryFromMap.getMessage().getMessageNumber());
                }
                this.discardEntry(addedEntry);
            } else if (entryFromMap.compareTo(addedEntry) < 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Entry " + addedEntry + " for message " + addedEntry.getMessage().getMessageNumber() + " replacing older entry " + entryFromMap + " for message " + entryFromMap.getMessage().getMessageNumber());
                }
                this.discardEntry(entryFromMap);
            }
            addedEntry.setLatestValueReference(entryReferenceFromMap);
        }
        return addedEntry;
    }

    private AtomicReference<QueueEntry> getOrPutIfAbsent(Object key, AtomicReference<QueueEntry> referenceToAddedValue) {
        AtomicReference<QueueEntry> latestValueReference = this._latestValuesMap.putIfAbsent(key, referenceToAddedValue);
        if (latestValueReference == null && (latestValueReference = this._latestValuesMap.get(key)) == null) {
            return new AtomicReference<QueueEntry>(this._newerEntryAlreadyBeenAndGone);
        }
        return latestValueReference;
    }

    private void discardEntry(final QueueEntry entry) {
        if (entry.acquire()) {
            AutoCommitTransaction txn = new AutoCommitTransaction(this.getQueue().getVirtualHost().getMessageStore());
            txn.dequeue(entry.getQueue(), entry.getMessage(), new ServerTransaction.Action(){

                public void postCommit() {
                    entry.discard();
                }

                public void onRollback() {
                }
            });
        }
    }

    Map<Object, AtomicReference<QueueEntry>> getLatestValuesMap() {
        return Collections.unmodifiableMap(this._latestValuesMap);
    }

    static class Factory
    implements QueueEntryListFactory {
        private final String _conflationKey;

        Factory(String conflationKey) {
            this._conflationKey = conflationKey;
        }

        public ConflationQueueList createQueueEntryList(AMQQueue queue) {
            return new ConflationQueueList(queue, this._conflationKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConflationQueueEntry
    extends SimpleQueueEntryImpl {
        private AtomicReference<QueueEntry> _latestValueReference;

        public ConflationQueueEntry(SimpleQueueEntryList queueEntryList, ServerMessage message) {
            super(queueEntryList, message);
        }

        @Override
        public void release() {
            super.release();
            this.discardIfReleasedEntryIsNoLongerLatest();
        }

        @Override
        public boolean delete() {
            if (super.delete()) {
                if (this._latestValueReference != null && this._latestValueReference.compareAndSet(this, ConflationQueueList.this._deleteInProgress)) {
                    Object key = this.getMessageHeader().getHeader(ConflationQueueList.this._conflationKey);
                    ConflationQueueList.this._latestValuesMap.remove(key, this._latestValueReference);
                }
                return true;
            }
            return false;
        }

        public void setLatestValueReference(AtomicReference<QueueEntry> latestValueReference) {
            this._latestValueReference = latestValueReference;
        }

        private void discardIfReleasedEntryIsNoLongerLatest() {
            if (this._latestValueReference != null && this._latestValueReference.get() != this) {
                ConflationQueueList.this.discardEntry(this);
            }
        }
    }
}

