/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.qpid.amqp_1_0.messaging.SectionDecoder;
import org.apache.qpid.amqp_1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkListener;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.ErrorCondition;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Accepted;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.transaction.Declare;
import org.apache.qpid.amqp_1_0.type.transaction.Declared;
import org.apache.qpid.amqp_1_0.type.transaction.Discharge;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxnCoordinatorLink_1_0
implements ReceivingLinkListener,
Link_1_0 {
    private VirtualHost _vhost;
    private ReceivingLinkEndpoint _endpoint;
    private ArrayList<Transfer> _incompleteMessage;
    private SectionDecoder _sectionDecoder;
    private LinkedHashMap<Integer, ServerTransaction> _openTransactions;
    private Session_1_0 _session;

    public TxnCoordinatorLink_1_0(VirtualHost vhost, Session_1_0 session_1_0, ReceivingLinkEndpoint endpoint, LinkedHashMap<Integer, ServerTransaction> openTransactions) {
        this._vhost = vhost;
        this._session = session_1_0;
        this._endpoint = endpoint;
        this._sectionDecoder = new SectionDecoderImpl(endpoint.getSession().getConnection().getDescribedTypeRegistry());
        this._openTransactions = openTransactions;
    }

    public void messageTransfer(Transfer xfr) {
        ByteBuffer payload = null;
        if (Boolean.TRUE.equals(xfr.getMore()) && this._incompleteMessage == null) {
            this._incompleteMessage = new ArrayList();
            this._incompleteMessage.add(xfr);
            return;
        }
        if (this._incompleteMessage != null) {
            this._incompleteMessage.add(xfr);
            if (Boolean.TRUE.equals(xfr.getMore())) {
                return;
            }
            int size = 0;
            for (Transfer t : this._incompleteMessage) {
                size += t.getPayload().limit();
            }
            payload = ByteBuffer.allocate(size);
            for (Transfer t : this._incompleteMessage) {
                payload.put(t.getPayload().duplicate());
            }
            payload.flip();
            this._incompleteMessage = null;
        } else {
            payload = xfr.getPayload();
        }
        try {
            List sections = this._sectionDecoder.parseAll(payload);
            for (Section section : sections) {
                if (!(section instanceof AmqpValue)) continue;
                Object command = ((AmqpValue)section).getValue();
                if (command instanceof Declare) {
                    Integer txnId2 = 0;
                    for (Integer txnId2 : this._openTransactions.keySet()) {
                    }
                    txnId2 = txnId2 + 1;
                    this._openTransactions.put(txnId2, new LocalTransaction(this._vhost.getMessageStore()));
                    Declared state = new Declared();
                    state.setTxnId(this._session.integerToBinary(txnId2));
                    this._endpoint.updateDisposition(xfr.getDeliveryTag(), (DeliveryState)state, true);
                    continue;
                }
                if (!(command instanceof Discharge)) continue;
                Discharge discharge = (Discharge)command;
                DeliveryState state = xfr.getState();
                this.discharge(this._session.binaryToInteger(discharge.getTxnId()), discharge.getFail());
                this._endpoint.updateDisposition(xfr.getDeliveryTag(), (DeliveryState)new Accepted(), true);
            }
        }
        catch (AmqpErrorException e) {
            e.printStackTrace();
        }
    }

    public void remoteDetached(LinkEndpoint endpoint, Detach detach) {
        endpoint.detach();
    }

    private Error discharge(Integer transactionId, boolean fail) {
        Error error = null;
        ServerTransaction txn = this._openTransactions.get(transactionId);
        if (txn != null) {
            if (fail) {
                txn.rollback();
            } else {
                txn.commit();
            }
            this._openTransactions.remove(transactionId);
        } else {
            error = new Error();
            error.setCondition((ErrorCondition)AmqpError.NOT_FOUND);
            error.setDescription("Unkown transactionId" + transactionId);
        }
        return error;
    }

    @Override
    public void start() {
        this._endpoint.setLinkCredit(UnsignedInteger.ONE);
        this._endpoint.setCreditWindow();
    }
}

