/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v1_0.ReceivingLink_1_0;
import org.apache.qpid.server.protocol.v1_0.SendingLink_1_0;

public class LinkRegistry {
    private final Map<String, SendingLink_1_0> _sendingLinks = new HashMap<String, SendingLink_1_0>();
    private final Map<String, ReceivingLink_1_0> _receivingLinks = new HashMap<String, ReceivingLink_1_0>();

    public synchronized SendingLink_1_0 getDurableSendingLink(String name) {
        return this._sendingLinks.get(name);
    }

    public synchronized boolean registerSendingLink(String name, SendingLink_1_0 link) {
        if (this._sendingLinks.containsKey(name)) {
            return false;
        }
        this._sendingLinks.put(name, link);
        return true;
    }

    public synchronized boolean unregisterSendingLink(String name) {
        if (!this._sendingLinks.containsKey(name)) {
            return false;
        }
        this._sendingLinks.remove(name);
        return true;
    }

    public synchronized ReceivingLink_1_0 getDurableReceivingLink(String name) {
        return this._receivingLinks.get(name);
    }

    public synchronized boolean registerReceivingLink(String name, ReceivingLink_1_0 link) {
        if (this._receivingLinks.containsKey(name)) {
            return false;
        }
        this._receivingLinks.put(name, link);
        return true;
    }
}

