/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugins;

import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiSystemPackageUtil {
    private static final String APACHE_QPID_PKG_PREFIX = "org.apache.qpid";
    private final Map<String, String> _packageNameVersionMap;
    private final Version _qpidPackageReleaseNumber;

    public OsgiSystemPackageUtil(Version qpidPackageReleaseNumber, Map<String, String> packageNameVersionMap) {
        this._qpidPackageReleaseNumber = qpidPackageReleaseNumber;
        this._packageNameVersionMap = packageNameVersionMap;
    }

    public String getFormattedSystemPackageString() {
        if (this._packageNameVersionMap == null || this._packageNameVersionMap.size() == 0) {
            return null;
        }
        StringBuilder packages = new StringBuilder();
        Iterator<String> itr = this._packageNameVersionMap.keySet().iterator();
        while (itr.hasNext()) {
            String packageName = itr.next();
            String packageVersion = this._qpidPackageReleaseNumber != null && packageName.startsWith(APACHE_QPID_PKG_PREFIX) ? this._qpidPackageReleaseNumber.toString() : this._packageNameVersionMap.get(packageName);
            packages.append(packageName);
            packages.append("; ");
            packages.append("version=");
            packages.append(packageVersion);
            if (!itr.hasNext()) continue;
            packages.append(", ");
        }
        return packages.toString();
    }
}

