/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.connection.IConnectionRegistry;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.QueueType;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.BrokerAdapter;
import org.apache.qpid.server.model.adapter.ConnectionAdapter;
import org.apache.qpid.server.model.adapter.ExchangeAdapter;
import org.apache.qpid.server.model.adapter.QueueAdapter;
import org.apache.qpid.server.model.adapter.StatisticsAdapter;
import org.apache.qpid.server.model.adapter.VirtualHostAliasAdapter;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VirtualHostAdapter
extends AbstractAdapter
implements VirtualHost,
ExchangeRegistry.RegistryChangeListener,
QueueRegistry.RegistryChangeListener,
IConnectionRegistry.RegistryChangeListener {
    private final org.apache.qpid.server.virtualhost.VirtualHost _virtualHost;
    private final Map<AMQConnectionModel, ConnectionAdapter> _connectionAdapters = new HashMap<AMQConnectionModel, ConnectionAdapter>();
    private final Map<AMQQueue, QueueAdapter> _queueAdapters = new HashMap<AMQQueue, QueueAdapter>();
    private final Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> _exchangeAdapters = new HashMap<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter>();
    private final StatisticsAdapter _statistics;
    private final BrokerAdapter _broker;
    private final List<VirtualHostAlias> _aliases = new ArrayList<VirtualHostAlias>();

    VirtualHostAdapter(BrokerAdapter brokerAdapter, org.apache.qpid.server.virtualhost.VirtualHost virtualHost) {
        super(virtualHost.getId());
        this._broker = brokerAdapter;
        this._virtualHost = virtualHost;
        this._statistics = new VirtualHostStatisticsAdapter(virtualHost);
        virtualHost.getQueueRegistry().addRegistryChangeListener(this);
        this.populateQueues();
        virtualHost.getExchangeRegistry().addRegistryChangeListener(this);
        this.populateExchanges();
        virtualHost.getConnectionRegistry().addRegistryChangeListener(this);
        this.populateConnections();
        for (Port port : this._broker.getPorts()) {
            this._aliases.add(new VirtualHostAliasAdapter(this, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateExchanges() {
        Collection<org.apache.qpid.server.exchange.Exchange> actualExchanges = this._virtualHost.getExchangeRegistry().getExchanges();
        Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
        synchronized (map) {
            for (org.apache.qpid.server.exchange.Exchange exchange : actualExchanges) {
                if (this._exchangeAdapters.containsKey(exchange)) continue;
                this._exchangeAdapters.put(exchange, new ExchangeAdapter(this, exchange));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateQueues() {
        Collection<AMQQueue> actualQueues = this._virtualHost.getQueueRegistry().getQueues();
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            for (AMQQueue queue : actualQueues) {
                if (this._queueAdapters.containsKey(queue)) continue;
                this._queueAdapters.put(queue, new QueueAdapter(this, queue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateConnections() {
        List<AMQConnectionModel> actualConnections = this._virtualHost.getConnectionRegistry().getConnections();
        Map<AMQConnectionModel, ConnectionAdapter> map = this._connectionAdapters;
        synchronized (map) {
            for (AMQConnectionModel conn : actualConnections) {
                if (this._connectionAdapters.containsKey(conn)) continue;
                this._connectionAdapters.put(conn, new ConnectionAdapter(conn));
            }
        }
    }

    @Override
    public String getReplicationGroupName() {
        return null;
    }

    @Override
    public Collection<VirtualHostAlias> getAliases() {
        return Collections.unmodifiableCollection(this._aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Connection> getConnections() {
        Map<AMQConnectionModel, ConnectionAdapter> map = this._connectionAdapters;
        synchronized (map) {
            return new ArrayList<Connection>(this._connectionAdapters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Queue> getQueues() {
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            return new ArrayList<Queue>(this._queueAdapters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Exchange> getExchanges() {
        Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
        synchronized (map) {
            return new ArrayList<Exchange>(this._exchangeAdapters.values());
        }
    }

    public Exchange createExchange(Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        attributes = new HashMap<String, Object>(attributes);
        String name = VirtualHostAdapter.getStringAttribute("name", attributes, null);
        State state = VirtualHostAdapter.getEnumAttribute(State.class, "state", attributes, State.ACTIVE);
        boolean durable = VirtualHostAdapter.getBooleanAttribute("durable", attributes, false);
        LifetimePolicy lifetime = VirtualHostAdapter.getEnumAttribute(LifetimePolicy.class, "lifetimePolicy", attributes, LifetimePolicy.PERMANENT);
        String type = VirtualHostAdapter.getStringAttribute("type", attributes, null);
        long ttl = VirtualHostAdapter.getLongAttribute("timeToLive", attributes, 0L);
        attributes.remove("name");
        attributes.remove("state");
        attributes.remove("durable");
        attributes.remove("lifetimePolicy");
        attributes.remove("type");
        attributes.remove("timeToLive");
        return this.createExchange(name, state, durable, lifetime, ttl, type, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange createExchange(String name, State initialState, boolean durable, LifetimePolicy lifetime, long ttl, String type, Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        this.checkVHostStateIsActive();
        try {
            ExchangeRegistry exchangeRegistry = this._virtualHost.getExchangeRegistry();
            if (exchangeRegistry.isReservedExchangeName(name)) {
                throw new UnsupportedOperationException("'" + name + "' is a reserved exchange name");
            }
            ExchangeRegistry exchangeRegistry2 = exchangeRegistry;
            synchronized (exchangeRegistry2) {
                org.apache.qpid.server.exchange.Exchange exchange = exchangeRegistry.getExchange(name);
                if (exchange != null) {
                    throw new IllegalArgumentException("Exchange with name '" + name + "' already exists");
                }
                exchange = this._virtualHost.getExchangeFactory().createExchange(name, type, durable, lifetime == LifetimePolicy.AUTO_DELETE);
                this._virtualHost.getExchangeRegistry().registerExchange(exchange);
                if (durable) {
                    this._virtualHost.getMessageStore().createExchange(exchange);
                }
                Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
                synchronized (map) {
                    return this._exchangeAdapters.get(exchange);
                }
            }
        }
        catch (AMQException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Queue createQueue(Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        if ((attributes = new HashMap<String, Object>(attributes)).containsKey("type")) {
            String typeAttribute = VirtualHostAdapter.getStringAttribute("type", attributes, null);
            QueueType queueType = null;
            try {
                queueType = QueueType.valueOf(typeAttribute.toUpperCase());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unsupported queue type :" + typeAttribute);
            }
            if (queueType == QueueType.LVQ && attributes.get("lvqKey") == null) {
                attributes.put("lvqKey", "qpid.LVQ_key");
            } else if (queueType == QueueType.PRIORITY && attributes.get("priorities") == null) {
                attributes.put("priorities", 10);
            } else if (queueType == QueueType.SORTED && attributes.get("sortKey") == null) {
                throw new IllegalArgumentException("Sort key is not specified for sorted queue");
            }
        }
        String name = VirtualHostAdapter.getStringAttribute("name", attributes, null);
        State state = VirtualHostAdapter.getEnumAttribute(State.class, "state", attributes, State.ACTIVE);
        boolean durable = VirtualHostAdapter.getBooleanAttribute("durable", attributes, false);
        LifetimePolicy lifetime = VirtualHostAdapter.getEnumAttribute(LifetimePolicy.class, "lifetimePolicy", attributes, LifetimePolicy.PERMANENT);
        long ttl = VirtualHostAdapter.getLongAttribute("timeToLive", attributes, 0L);
        boolean exclusive = VirtualHostAdapter.getBooleanAttribute("exclusive", attributes, false);
        attributes.remove("name");
        attributes.remove("state");
        attributes.remove("durable");
        attributes.remove("lifetimePolicy");
        attributes.remove("timeToLive");
        ArrayList<String> attrNames = new ArrayList<String>(attributes.keySet());
        for (String attr : attrNames) {
            if (!QueueAdapter.ATTRIBUTE_MAPPINGS.containsKey(attr)) continue;
            attributes.put(QueueAdapter.ATTRIBUTE_MAPPINGS.get(attr), attributes.remove(attr));
        }
        return this.createQueue(name, state, durable, exclusive, lifetime, ttl, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue createQueue(String name, State initialState, boolean durable, boolean exclusive, LifetimePolicy lifetime, long ttl, Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        Set<Principal> principals;
        this.checkVHostStateIsActive();
        String owner = null;
        if (exclusive && (principals = SecurityManager.getThreadSubject().getPrincipals()) != null && !principals.isEmpty()) {
            owner = principals.iterator().next().getName();
        }
        try {
            QueueRegistry queueRegistry;
            QueueRegistry queueRegistry2 = queueRegistry = this._virtualHost.getQueueRegistry();
            synchronized (queueRegistry2) {
                if (this._virtualHost.getQueueRegistry().getQueue(name) != null) {
                    throw new IllegalArgumentException("Queue with name " + name + " already exists");
                }
                AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(UUIDGenerator.generateQueueUUID(name, this._virtualHost.getName()), name, durable, owner, lifetime == LifetimePolicy.AUTO_DELETE, exclusive, this._virtualHost, attributes);
                this._virtualHost.getBindingFactory().addBinding(name, queue, this._virtualHost.getExchangeRegistry().getDefaultExchange(), null);
                if (durable) {
                    this._virtualHost.getMessageStore().createQueue(queue, FieldTable.convertToFieldTable(attributes));
                }
                Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
                synchronized (map) {
                    return this._queueAdapters.get(queue);
                }
            }
        }
        catch (AMQException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getName() {
        return this._virtualHost.getName();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        throw new IllegalStateException();
    }

    @Override
    public State getActualState() {
        return this.getDesiredState();
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Exchange.class) {
            return this.getExchanges();
        }
        if (clazz == Queue.class) {
            return this.getQueues();
        }
        if (clazz == Connection.class) {
            return this.getConnections();
        }
        if (clazz == VirtualHostAlias.class) {
            return this.getAliases();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Exchange.class) {
            return (C)this.createExchange(attributes);
        }
        if (childClass == Queue.class) {
            return (C)this.createQueue(attributes);
        }
        if (childClass == VirtualHostAlias.class) {
            throw new UnsupportedOperationException();
        }
        if (childClass == Connection.class) {
            throw new UnsupportedOperationException();
        }
        throw new IllegalArgumentException("Cannot create a child of class " + childClass.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exchangeRegistered(org.apache.qpid.server.exchange.Exchange exchange) {
        ExchangeAdapter adapter = null;
        Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
        synchronized (map) {
            if (!this._exchangeAdapters.containsKey(exchange)) {
                adapter = new ExchangeAdapter(this, exchange);
                this._exchangeAdapters.put(exchange, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exchangeUnregistered(org.apache.qpid.server.exchange.Exchange exchange) {
        ExchangeAdapter adapter;
        Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
        synchronized (map) {
            adapter = this._exchangeAdapters.remove(exchange);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueRegistered(AMQQueue queue) {
        QueueAdapter adapter = null;
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            if (!this._queueAdapters.containsKey(queue)) {
                adapter = new QueueAdapter(this, queue);
                this._queueAdapters.put(queue, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueUnregistered(AMQQueue queue) {
        QueueAdapter adapter;
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            adapter = this._queueAdapters.remove(queue);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionRegistered(AMQConnectionModel connection) {
        ConnectionAdapter adapter = null;
        Map<AMQConnectionModel, ConnectionAdapter> map = this._connectionAdapters;
        synchronized (map) {
            if (!this._connectionAdapters.containsKey(connection)) {
                adapter = new ConnectionAdapter(connection);
                this._connectionAdapters.put(connection, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionUnregistered(AMQConnectionModel connection) {
        ConnectionAdapter adapter;
        Map<AMQConnectionModel, ConnectionAdapter> map = this._connectionAdapters;
        synchronized (map) {
            adapter = this._connectionAdapters.remove(connection);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueueAdapter getQueueAdapter(AMQQueue queue) {
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            return this._queueAdapters.get(queue);
        }
    }

    @Override
    public Collection<String> getExchangeTypes() {
        Collection<ExchangeType<? extends org.apache.qpid.server.exchange.Exchange>> types = this._virtualHost.getExchangeFactory().getRegisteredTypes();
        ArrayList<String> exchangeTypes = new ArrayList<String>();
        for (ExchangeType<? extends org.apache.qpid.server.exchange.Exchange> type : types) {
            exchangeTypes.add(type.getName().asString());
        }
        return Collections.unmodifiableCollection(exchangeTypes);
    }

    @Override
    public void executeTransaction(VirtualHost.TransactionalOperation op) {
        MessageStore store = this._virtualHost.getMessageStore();
        final LocalTransaction txn = new LocalTransaction(store);
        op.withinTransaction(new VirtualHost.Transaction(){

            public void dequeue(final QueueEntry entry) {
                if (entry.acquire()) {
                    txn.dequeue(entry.getQueue(), entry.getMessage(), new ServerTransaction.Action(){

                        public void postCommit() {
                            entry.discard();
                        }

                        public void onRollback() {
                        }
                    });
                }
            }

            public void copy(QueueEntry entry, Queue queue) {
                final ServerMessage message = entry.getMessage();
                final AMQQueue toQueue = ((QueueAdapter)queue).getAMQQueue();
                txn.enqueue(toQueue, message, new ServerTransaction.Action(){

                    public void postCommit() {
                        try {
                            toQueue.enqueue(message);
                        }
                        catch (AMQException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void onRollback() {
                    }
                });
            }

            public void move(final QueueEntry entry, Queue queue) {
                final ServerMessage message = entry.getMessage();
                final AMQQueue toQueue = ((QueueAdapter)queue).getAMQQueue();
                if (entry.acquire()) {
                    txn.enqueue(toQueue, message, new ServerTransaction.Action(){

                        public void postCommit() {
                            try {
                                toQueue.enqueue(message);
                            }
                            catch (AMQException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void onRollback() {
                            entry.release();
                        }
                    });
                    txn.dequeue(entry.getQueue(), message, new ServerTransaction.Action(){

                        public void postCommit() {
                            entry.discard();
                        }

                        public void onRollback() {
                        }
                    });
                }
            }
        });
        txn.commit();
    }

    org.apache.qpid.server.virtualhost.VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("state".equals(name)) {
            return State.ACTIVE;
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return LifetimePolicy.PERMANENT;
        }
        if (!("timeToLive".equals(name) || "created".equals(name) || "updated".equals(name))) {
            if ("supportedExchangeTypes".equals(name)) {
                ArrayList<String> types = new ArrayList<String>();
                for (ExchangeType<? extends org.apache.qpid.server.exchange.Exchange> type : this._virtualHost.getExchangeFactory().getRegisteredTypes()) {
                    types.add(type.getName().asString());
                }
                return Collections.unmodifiableCollection(types);
            }
            if (!"supportedQueueTypes".equals(name)) {
                if ("deadLetterQueueEnabled".equals(name)) {
                    return this._virtualHost.getConfiguration().isDeadLetterQueueEnabled();
                }
                if ("federationTag".equals(name)) {
                    return this._virtualHost.getFederationTag();
                }
                if ("housekeepingCheckPeriod".equals(name)) {
                    return this._virtualHost.getConfiguration().getHousekeepingCheckPeriod();
                }
                if ("maximumDeliveryAttempts".equals(name)) {
                    return this._virtualHost.getConfiguration().getMaxDeliveryCount();
                }
                if ("queueFlowControlSizeBytes".equals(name)) {
                    return this._virtualHost.getConfiguration().getCapacity();
                }
                if ("queueFlowResumeSizeBytes".equals(name)) {
                    return this._virtualHost.getConfiguration().getFlowResumeCapacity();
                }
                if ("storeType".equals(name)) {
                    return this._virtualHost.getMessageStore().getStoreType();
                }
                if (!"storeConfiguration".equals(name)) {
                    if ("storeTransactionIdleTimeoutClose".equals(name)) {
                        return this._virtualHost.getConfiguration().getTransactionTimeoutIdleClose();
                    }
                    if ("storeTransactionIdleTimeoutWarn".equals(name)) {
                        return this._virtualHost.getConfiguration().getTransactionTimeoutIdleWarn();
                    }
                    if ("storeTransactionOpenTimeoutClose".equals(name)) {
                        return this._virtualHost.getConfiguration().getTransactionTimeoutOpenClose();
                    }
                    if ("storeTransactionOpenTimeoutWarn".equals(name)) {
                        return this._virtualHost.getConfiguration().getTransactionTimeoutOpenWarn();
                    }
                    if ("alertRepeatGap".equals(name)) {
                        return this._virtualHost.getConfiguration().getMinimumAlertRepeatGap();
                    }
                    if ("alertThresholdMessageAge".equals(name)) {
                        return this._virtualHost.getConfiguration().getMaximumMessageAge();
                    }
                    if ("alertThresholdMessageSize".equals(name)) {
                        return this._virtualHost.getConfiguration().getMaximumMessageSize();
                    }
                    if ("alertThresholdQueueDepthBytes".equals(name)) {
                        return this._virtualHost.getConfiguration().getMaximumQueueDepth();
                    }
                    if ("alertThresholdQueueDepthMessages".equals(name)) {
                        return this._virtualHost.getConfiguration().getMaximumMessageCount();
                    }
                }
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return super.setAttribute(name, expected, desired);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    private void checkVHostStateIsActive() {
        if (!org.apache.qpid.server.virtualhost.State.ACTIVE.equals((Object)this._virtualHost.getState())) {
            throw new IllegalStateException("The virtual hosts state of " + (Object)((Object)this._virtualHost.getState()) + " does not permit this operation.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VirtualHostStatisticsAdapter
    extends StatisticsAdapter {
        private final org.apache.qpid.server.virtualhost.VirtualHost _vhost;
        private static final Collection<String> VHOST_STATS = Arrays.asList("queueCount", "exchangeCount", "connectionCount");

        public VirtualHostStatisticsAdapter(org.apache.qpid.server.virtualhost.VirtualHost virtualHost) {
            super(virtualHost);
            this._vhost = virtualHost;
        }

        @Override
        public Collection<String> getStatisticNames() {
            HashSet<String> stats = new HashSet<String>(super.getStatisticNames());
            stats.addAll(VHOST_STATS);
            return stats;
        }

        @Override
        public Object getStatistic(String name) {
            if ("queueCount".equals(name)) {
                return this._vhost.getQueueRegistry().getQueues().size();
            }
            if ("exchangeCount".equals(name)) {
                return this._vhost.getExchangeRegistry().getExchanges().size();
            }
            if ("connectionCount".equals(name)) {
                return this._vhost.getConnectionRegistry().getConnections().size();
            }
            return super.getStatistic(name);
        }
    }
}

