/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.qpid.AMQException;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.SessionAdapter;
import org.apache.qpid.server.model.adapter.StatisticsAdapter;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.stats.StatisticsGatherer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConnectionAdapter
extends AbstractAdapter
implements Connection {
    private AMQConnectionModel _connection;
    private final Map<AMQSessionModel, SessionAdapter> _sessionAdapters = new HashMap<AMQSessionModel, SessionAdapter>();
    private final Statistics _statistics;

    public ConnectionAdapter(AMQConnectionModel conn) {
        super(UUIDGenerator.generateRandomUUID());
        this._connection = conn;
        this._statistics = new ConnectionStatisticsAdapter(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Session> getSessions() {
        List<AMQSessionModel> actualSessions = this._connection.getSessionModels();
        Map<AMQSessionModel, SessionAdapter> map = this._sessionAdapters;
        synchronized (map) {
            for (AMQSessionModel session : this._sessionAdapters.keySet()) {
                if (actualSessions.contains(session)) continue;
                this._sessionAdapters.remove(session);
            }
            for (AMQSessionModel session : actualSessions) {
                if (this._sessionAdapters.containsKey(session)) continue;
                this._sessionAdapters.put(session, new SessionAdapter(session));
            }
            return new ArrayList<Session>(this._sessionAdapters.values());
        }
    }

    @Override
    public void delete() {
        try {
            this._connection.close(AMQConstant.CONNECTION_FORCED, "Connection closed by external action");
        }
        catch (AMQException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getName() {
        String remoteAddressString = this._connection.getRemoteAddressString();
        return remoteAddressString.replaceAll("/", "");
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return null;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("id")) {
            return this.getId();
        }
        if (name.equals("name")) {
            return this.getName();
        }
        if (name.equals("clientId")) {
            return this._connection.getClientId();
        }
        if (name.equals("clientVersion")) {
            return this._connection.getClientVersion();
        }
        if (!name.equals("incoming") && !name.equals("localAddress")) {
            if (name.equals("principal")) {
                return this._connection.getPrincipalAsString();
            }
            if (!name.equals("properties")) {
                if (name.equals("remoteAddress")) {
                    return this._connection.getRemoteAddressString();
                }
                if (!name.equals("remoteProcessName") && !name.equals("remoteProcessPid") && name.equals("sessionCountLimit")) {
                    return this._connection.getSessionCountLimit();
                }
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        if (name.equals("clientId") || name.equals("clientVersion") || name.equals("incoming") || name.equals("localAddress") || name.equals("principal") || name.equals("properties") || name.equals("remoteAddress") || name.equals("remoteProcessName") || name.equals("remoteProcessPid") || name.equals("sessionCountLimit")) {
            // empty if block
        }
        return super.setAttribute(name, expected, desired);
    }

    @Override
    public Collection<String> getAttributeNames() {
        HashSet<String> attrNames = new HashSet<String>(super.getAttributeNames());
        attrNames.addAll(Connection.AVAILABLE_ATTRIBUTES);
        return Collections.unmodifiableCollection(attrNames);
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Session.class) {
            return this.getSessions();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Session.class) {
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException("Cannot create a child of class " + childClass.getSimpleName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionStatisticsAdapter
    extends StatisticsAdapter {
        public ConnectionStatisticsAdapter(StatisticsGatherer applicationRegistry) {
            super(applicationRegistry);
        }

        @Override
        public Collection<String> getStatisticNames() {
            return Connection.AVAILABLE_STATISTICS;
        }

        @Override
        public Object getStatistic(String name) {
            if ("lastIoTime".equals(name)) {
                return ConnectionAdapter.this._connection.getLastIoTime();
            }
            if ("sessionCount".equals(name)) {
                return ConnectionAdapter.this._connection.getSessionModels().size();
            }
            return super.getStatistic(name);
        }
    }
}

