/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.ExchangeAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.model.adapter.QueueAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BindingAdapter
extends AbstractAdapter
implements Binding {
    private final org.apache.qpid.server.binding.Binding _binding;
    private Statistics _statistics = NoStatistics.getInstance();
    private final ExchangeAdapter _exchange;
    private QueueAdapter _queue;

    public BindingAdapter(org.apache.qpid.server.binding.Binding binding, ExchangeAdapter exchangeAdapter, QueueAdapter queueAdapter) {
        super(binding.getId());
        this._binding = binding;
        this._exchange = exchangeAdapter;
        this._queue = queueAdapter;
        this.addParent(Queue.class, queueAdapter);
        this.addParent(Exchange.class, exchangeAdapter);
    }

    public ExchangeAdapter getExchange() {
        return this._exchange;
    }

    public QueueAdapter getQueue() {
        return this._queue;
    }

    @Override
    public String getName() {
        return this._binding.getBindingKey();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return this._binding.getQueue().isDurable() && this._binding.getExchange().isDurable();
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new IllegalArgumentException("Cannot add children to a binding");
    }

    @Override
    public Map<String, Object> getArguments() {
        return new HashMap<String, Object>(this._binding.getArguments());
    }

    @Override
    public void delete() {
        try {
            this._queue.getAMQQueue().getVirtualHost().getBindingFactory().removeBinding(this._binding);
        }
        catch (AMQSecurityException e) {
            throw new AccessControlException(e.getMessage());
        }
        catch (AMQInternalException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if (!"state".equals(name)) {
            if ("durable".equals(name)) {
                return this._queue.isDurable() && this._exchange.isDurable();
            }
            if ("lifetimePolicy".equals(name)) {
                return this._queue.getLifetimePolicy() == LifetimePolicy.AUTO_DELETE || this._exchange.getLifetimePolicy() == LifetimePolicy.AUTO_DELETE ? LifetimePolicy.AUTO_DELETE : LifetimePolicy.PERMANENT;
            }
            if (!("timeToLive".equals(name) || "created".equals(name) || "updated".equals(name))) {
                if ("exchange".equals(name)) {
                    return this._exchange.getName();
                }
                if ("queue".equals(name)) {
                    return this._queue.getName();
                }
                if ("arguments".equals(name)) {
                    return this.getArguments();
                }
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return super.setAttribute(name, expected, desired);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Binding.AVAILABLE_ATTRIBUTES;
    }

    @Override
    public State setDesiredState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
        if (desiredState == State.DELETED) {
            this.delete();
            return State.DELETED;
        }
        return super.setDesiredState(currentState, desiredState);
    }
}

