/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.nio.ByteBuffer;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.MessageMetaData_0_10;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.TransferMessageReference;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.transport.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTransferMessage
extends AbstractServerMessageImpl<MessageMetaData_0_10>
implements InboundMessage {
    private Object _connectionRef;

    public MessageTransferMessage(StoredMessage<MessageMetaData_0_10> storeMessage, Object connectionRef) {
        super(storeMessage);
        this._connectionRef = connectionRef;
    }

    private MessageMetaData_0_10 getMetaData() {
        return (MessageMetaData_0_10)this.getStoredMessage().getMetaData();
    }

    @Override
    public String getRoutingKey() {
        return this.getMetaData().getRoutingKey();
    }

    @Override
    public AMQShortString getRoutingKeyShortString() {
        return AMQShortString.valueOf((String)this.getRoutingKey());
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        return this.getMetaData().getMessageHeader();
    }

    @Override
    public boolean isPersistent() {
        return this.getMetaData().isPersistent();
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        return this.getMetaData().getSize();
    }

    @Override
    public boolean isImmediate() {
        return this.getMetaData().isImmediate();
    }

    @Override
    public long getExpiration() {
        return this.getMetaData().getExpiration();
    }

    @Override
    public MessageReference newReference() {
        return new TransferMessageReference(this);
    }

    @Override
    public long getMessageNumber() {
        return this.getStoredMessage().getMessageNumber();
    }

    @Override
    public long getArrivalTime() {
        return this.getMetaData().getArrivalTime();
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        return this.getStoredMessage().getContent(offset, buf);
    }

    @Override
    public ByteBuffer getContent(int offset, int size) {
        return this.getStoredMessage().getContent(offset, size);
    }

    public Header getHeader() {
        return this.getMetaData().getHeader();
    }

    public ByteBuffer getBody() {
        return this.getContent(0, (int)this.getSize());
    }

    public Object getConnectionReference() {
        return this._connectionRef;
    }
}

