/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCancelMethodHandler
implements StateAwareMethodListener<BasicCancelBody> {
    private static final Logger _log = Logger.getLogger(BasicCancelMethodHandler.class);
    private static final BasicCancelMethodHandler _instance = new BasicCancelMethodHandler();

    public static BasicCancelMethodHandler getInstance() {
        return _instance;
    }

    private BasicCancelMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicCancelBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("BasicCancel: for:" + body.getConsumerTag() + " nowait:" + body.getNowait()));
        }
        channel.unsubscribeConsumer(body.getConsumerTag());
        if (!body.getNowait()) {
            MethodRegistry methodRegistry = session.getMethodRegistry();
            BasicCancelOkBody cancelOkBody = methodRegistry.createBasicCancelOkBody(body.getConsumerTag());
            channel.sync();
            session.writeFrame((AMQDataBlock)cancelOkBody.generateFrame(channelId));
        }
    }
}

