/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.store.DurableConfigurationStore;

public class ExchangeInitialiser {
    public void initialise(ExchangeFactory factory, ExchangeRegistry registry, DurableConfigurationStore store) throws AMQException {
        for (ExchangeType<? extends Exchange> type : factory.getRegisteredTypes()) {
            this.define(registry, factory, type.getDefaultExchangeName(), type.getName(), store);
        }
        this.define(registry, factory, ExchangeDefaults.DEFAULT_EXCHANGE_NAME, ExchangeDefaults.DIRECT_EXCHANGE_CLASS, store);
        registry.setDefaultExchange(registry.getExchange(ExchangeDefaults.DEFAULT_EXCHANGE_NAME));
    }

    private void define(ExchangeRegistry r, ExchangeFactory f, AMQShortString name, AMQShortString type, DurableConfigurationStore store) throws AMQException {
        if (r.getExchange(name) == null) {
            Exchange exchange = f.createExchange(name, type, true, false, 0);
            r.registerExchange(exchange);
            if (exchange.isDurable()) {
                store.createExchange(exchange);
            }
        }
    }
}

