/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(DirectExchange.class);
    private final ConcurrentHashMap<String, BindingSet> _bindingsByKey = new ConcurrentHashMap();
    public static final ExchangeType<DirectExchange> TYPE = new ExchangeType<DirectExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.DIRECT_EXCHANGE_CLASS;
        }

        @Override
        public Class<DirectExchange> getExchangeClass() {
            return DirectExchange.class;
        }

        @Override
        public DirectExchange newInstance(UUID id, VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            DirectExchange exch = new DirectExchange();
            exch.initialise(id, host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.DIRECT_EXCHANGE_NAME;
        }
    };

    public DirectExchange() {
        super(TYPE);
    }

    @Override
    public List<? extends BaseQueue> doRoute(InboundMessage payload) {
        String routingKey = payload.getRoutingKey();
        BindingSet bindings = this._bindingsByKey.get(routingKey == null ? "" : routingKey);
        if (bindings != null) {
            return bindings.getQueues();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        String bindingKey = routingKey == null ? "" : routingKey.toString();
        BindingSet bindings = this._bindingsByKey.get(bindingKey);
        if (bindings != null) {
            return bindings.getQueues().contains(queue);
        }
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        String bindingKey = routingKey == null ? "" : routingKey.toString();
        BindingSet bindings = this._bindingsByKey.get(bindingKey);
        return bindings != null && !bindings.getQueues().isEmpty();
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        for (BindingSet bindings : this._bindingsByKey.values()) {
            if (!bindings.getQueues().contains(queue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this.getBindings().isEmpty();
    }

    @Override
    protected void onBind(Binding binding) {
        BindingSet newBindings;
        String bindingKey = binding.getBindingKey();
        AMQQueue queue = binding.getQueue();
        AMQShortString routingKey = AMQShortString.valueOf((String)bindingKey);
        assert (queue != null);
        assert (routingKey != null);
        BindingSet bindings = this._bindingsByKey.get(bindingKey);
        if (bindings == null && (newBindings = this._bindingsByKey.putIfAbsent(bindingKey, bindings = new BindingSet())) != null) {
            bindings = newBindings;
        }
        bindings.addBinding(binding);
    }

    @Override
    protected void onUnbind(Binding binding) {
        assert (binding != null);
        BindingSet bindings = this._bindingsByKey.get(binding.getBindingKey());
        if (bindings != null) {
            bindings.removeBinding(binding);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindingSet {
        private CopyOnWriteArraySet<Binding> _bindings = new CopyOnWriteArraySet();
        private List<BaseQueue> _queues = new ArrayList<BaseQueue>();

        private BindingSet() {
        }

        public synchronized void addBinding(Binding binding) {
            this._bindings.add(binding);
            this.recalculateQueues();
        }

        public synchronized void removeBinding(Binding binding) {
            this._bindings.remove(binding);
            this.recalculateQueues();
        }

        private void recalculateQueues() {
            ArrayList<BaseQueue> queues = new ArrayList<BaseQueue>(this._bindings.size());
            for (Binding b : this._bindings) {
                if (queues.contains(b.getQueue())) continue;
                queues.add(b.getQueue());
            }
            this._queues = queues;
        }

        public List<BaseQueue> getQueues() {
            return this._queues;
        }

        public CopyOnWriteArraySet<Binding> getBindings() {
            return this._bindings;
        }
    }
}

