/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeInitialiser;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchangeRegistry
implements ExchangeRegistry {
    private static final Logger LOGGER = Logger.getLogger(DefaultExchangeRegistry.class);
    private ConcurrentMap<AMQShortString, Exchange> _exchangeMap = new ConcurrentHashMap<AMQShortString, Exchange>();
    private ConcurrentMap<String, Exchange> _exchangeMapStr = new ConcurrentHashMap<String, Exchange>();
    private Exchange _defaultExchange;
    private VirtualHost _host;
    private final Collection<ExchangeRegistry.RegistryChangeListener> _listeners = Collections.synchronizedCollection(new ArrayList());

    public DefaultExchangeRegistry(VirtualHost host) {
        this._host = host;
    }

    @Override
    public void initialise() throws AMQException {
        new ExchangeInitialiser().initialise(this._host.getExchangeFactory(), this, this.getDurableConfigurationStore());
    }

    public DurableConfigurationStore getDurableConfigurationStore() {
        return this._host.getMessageStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerExchange(Exchange exchange) throws AMQException {
        this._exchangeMap.put(exchange.getNameShortString(), exchange);
        this._exchangeMapStr.put(exchange.getNameShortString().toString(), exchange);
        Collection<ExchangeRegistry.RegistryChangeListener> collection = this._listeners;
        synchronized (collection) {
            for (ExchangeRegistry.RegistryChangeListener listener : this._listeners) {
                listener.exchangeRegistered(exchange);
            }
        }
    }

    @Override
    public void setDefaultExchange(Exchange exchange) {
        this._defaultExchange = exchange;
    }

    @Override
    public Exchange getDefaultExchange() {
        return this._defaultExchange;
    }

    @Override
    public Collection<AMQShortString> getExchangeNames() {
        return this._exchangeMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterExchange(AMQShortString name, boolean inUse) throws AMQException {
        Exchange exchange = (Exchange)this._exchangeMap.get(name);
        if (exchange == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Unknown exchange " + name, null);
        }
        if (ExchangeDefaults.DEFAULT_EXCHANGE_NAME.equals(name)) {
            throw new AMQException(AMQConstant.NOT_ALLOWED, "Cannot unregister the default exchange", null);
        }
        if (!this._host.getSecurityManager().authoriseDelete(exchange)) {
            throw new AMQSecurityException();
        }
        Exchange e = (Exchange)this._exchangeMap.remove(name);
        this._exchangeMapStr.remove(name.toString());
        if (e != null) {
            if (e.isDurable()) {
                this.getDurableConfigurationStore().removeExchange(e);
            }
            e.close();
            Collection<ExchangeRegistry.RegistryChangeListener> collection = this._listeners;
            synchronized (collection) {
                for (ExchangeRegistry.RegistryChangeListener listener : this._listeners) {
                    listener.exchangeUnregistered(exchange);
                }
            }
        } else {
            throw new AMQException("Unknown exchange " + name);
        }
    }

    @Override
    public void unregisterExchange(String name, boolean inUse) throws AMQException {
        this.unregisterExchange(new AMQShortString(name), inUse);
    }

    @Override
    public Collection<Exchange> getExchanges() {
        return new ArrayList<Exchange>(this._exchangeMap.values());
    }

    @Override
    public void addRegistryChangeListener(ExchangeRegistry.RegistryChangeListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public Exchange getExchange(AMQShortString name) {
        if (name == null || name.length() == 0) {
            return this.getDefaultExchange();
        }
        return (Exchange)this._exchangeMap.get(name);
    }

    @Override
    public Exchange getExchange(String name) {
        if (name == null || name.length() == 0) {
            return this.getDefaultExchange();
        }
        return (Exchange)this._exchangeMapStr.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAndUnregisterMbeans() {
        for (AMQShortString exchangeName : this.getExchangeNames()) {
            Exchange exchange = this.getExchange(exchangeName);
            Collection<ExchangeRegistry.RegistryChangeListener> collection = this._listeners;
            synchronized (collection) {
                for (ExchangeRegistry.RegistryChangeListener listener : this._listeners) {
                    listener.exchangeUnregistered(exchange);
                }
            }
        }
        this._exchangeMap.clear();
        this._exchangeMapStr.clear();
    }

    @Override
    public synchronized Exchange getExchange(UUID exchangeId) {
        if (exchangeId == null) {
            return this.getDefaultExchange();
        }
        Collection exchanges = this._exchangeMap.values();
        for (Exchange exchange : exchanges) {
            if (!exchange.getId().equals(exchangeId)) continue;
            return exchange;
        }
        return null;
    }

    @Override
    public boolean isReservedExchangeName(String name) {
        if (name == null || "".equals(name) || ExchangeDefaults.DEFAULT_EXCHANGE_NAME.asString().equals(name) || name.startsWith("amq.") || name.startsWith("qpid.")) {
            return true;
        }
        Collection<ExchangeType<? extends Exchange>> registeredTypes = this._host.getExchangeFactory().getRegisteredTypes();
        for (ExchangeType<? extends Exchange> type : registeredTypes) {
            if (!type.getDefaultExchangeName().toString().equals(name)) continue;
            return true;
        }
        return false;
    }
}

