/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.nio.ByteBuffer;
import org.apache.qpid.qmf.QMFBrokerRequestCommand;
import org.apache.qpid.qmf.QMFClassQueryCommand;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFGetQueryCommand;
import org.apache.qpid.qmf.QMFMethodRequestCommand;
import org.apache.qpid.qmf.QMFOperation;
import org.apache.qpid.qmf.QMFPackageQueryCommand;
import org.apache.qpid.qmf.QMFSchemaRequestCommand;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.transport.codec.BBDecoder;

public class QMFCommandDecoder {
    private BBDecoder _decoder;
    private static final QMFOperation[] OP_CODES = new QMFOperation[256];
    private final QMFService _qmfService;

    public QMFCommandDecoder(QMFService qmfService, ByteBuffer buf) {
        this._qmfService = qmfService;
        this._decoder = new BBDecoder();
        this._decoder.init(buf);
    }

    public QMFCommand decode() {
        if (this._decoder.hasRemaining()) {
            QMFCommandHeader header = this.readQMFHeader();
            switch (header.getOperation()) {
                case BROKER_REQUEST: {
                    return new QMFBrokerRequestCommand(header, this._decoder);
                }
                case PACKAGE_QUERY: {
                    return new QMFPackageQueryCommand(header, this._decoder);
                }
                case CLASS_QUERY: {
                    return new QMFClassQueryCommand(header, this._decoder);
                }
                case SCHEMA_REQUEST: {
                    return new QMFSchemaRequestCommand(header, this._decoder);
                }
                case METHOD_REQUEST: {
                    return new QMFMethodRequestCommand(header, this._decoder, this._qmfService);
                }
                case GET_QUERY: {
                    return new QMFGetQueryCommand(header, this._decoder);
                }
            }
            System.out.println("Unknown command");
            return null;
        }
        return null;
    }

    private QMFCommandHeader readQMFHeader() {
        if (this._decoder.readInt8() == 65 && this._decoder.readInt8() == 77) {
            byte version = this._decoder.readInt8();
            short opCode = this._decoder.readUint8();
            int seq = this._decoder.readInt32();
            return new QMFCommandHeader(version, seq, OP_CODES[opCode]);
        }
        return null;
    }

    static {
        QMFOperation[] arr$ = QMFOperation.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            QMFOperation op;
            QMFCommandDecoder.OP_CODES[op.getOpcode()] = op = arr$[i$];
        }
    }
}

