/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.qmf.QMFBrokerResponseCommand;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandCompletionCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFMessage;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.codec.BBDecoder;

public class QMFBrokerRequestCommand
extends QMFCommand {
    private static final Logger _qmfLogger = Logger.getLogger((String)"qpid.qmf");

    public QMFBrokerRequestCommand(QMFCommandHeader header, BBDecoder buf) {
        super(header);
    }

    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String queueName = message.getMessageHeader().getReplyToRoutingKey();
        _qmfLogger.debug((Object)("Execute: " + this));
        QMFCommand[] commands = new QMFCommand[]{new QMFBrokerResponseCommand(this, virtualHost), new QMFCommandCompletionCommand(this)};
        Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(queueName, cmd);
            List<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

