/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.io.IOException;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.log4j.Logger;
import org.apache.qpid.management.common.mbeans.UserManagement;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;

@MBeanDescription(value="User Management Interface")
public class UserManagementMBean
extends AMQManagedObject
implements UserManagement {
    private static final Logger _logger = Logger.getLogger(UserManagementMBean.class);
    private PasswordCredentialManagingAuthenticationProvider _authProvider;
    private String _mbeanName;
    private String _type;
    private static final TabularType _userlistDataType;
    private static final CompositeType _userDataType;

    public UserManagementMBean(PasswordCredentialManagingAuthenticationProvider provider, ManagedObjectRegistry registry) throws JMException {
        super(UserManagement.class, "UserManagement", registry);
        this._authProvider = provider;
        this._mbeanName = "UserManagement-" + this._authProvider.getName();
        this._type = String.valueOf(this._authProvider.getAttribute("type"));
        this.register();
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(this._mbeanName);
    }

    public boolean setPassword(String username, String password) {
        try {
            this._authProvider.setPassword(username, password);
        }
        catch (AccountNotFoundException e) {
            _logger.warn((Object)("Attempt to set password of non-existent user '" + username + "'"));
            return false;
        }
        return true;
    }

    public boolean createUser(String username, String password) {
        return this._authProvider.createUser(username, password, null);
    }

    public boolean deleteUser(String username) {
        try {
            this._authProvider.deleteUser(username);
        }
        catch (AccountNotFoundException e) {
            _logger.warn((Object)("Attempt to delete user (" + username + ") that doesn't exist"));
            return false;
        }
        return true;
    }

    public boolean reloadData() {
        try {
            this._authProvider.reload();
            return true;
        }
        catch (IOException e) {
            _logger.error((Object)"Unable to reload user data", (Throwable)e);
            return false;
        }
    }

    public TabularData viewUsers() {
        Map users = this._authProvider.getUsers();
        TabularDataSupport userList = new TabularDataSupport(_userlistDataType);
        try {
            for (String user : users.keySet()) {
                Object[] itemData = new Object[]{user, false, false, false};
                CompositeDataSupport messageData = new CompositeDataSupport(_userDataType, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), itemData);
                userList.put(messageData);
            }
        }
        catch (OpenDataException e) {
            _logger.warn((Object)"Unable to create user list due to :", (Throwable)e);
            return null;
        }
        return userList;
    }

    @Override
    public ManagedObject getParentObject() {
        return null;
    }

    public String getAuthenticationProviderType() {
        return this._type;
    }

    static {
        OpenType[] userItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN};
        try {
            _userDataType = new CompositeType("User", "User Data", COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), COMPOSITE_ITEM_DESCRIPTIONS.toArray(new String[COMPOSITE_ITEM_DESCRIPTIONS.size()]), userItemTypes);
            _userlistDataType = new TabularType("Users", "List of users", _userDataType, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
        }
        catch (OpenDataException e) {
            _logger.error((Object)"Tabular data setup for viewing users incorrect.", (Throwable)e);
            throw new ExceptionInInitializerError("Tabular data setup for viewing users incorrect");
        }
    }
}

