/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.monitor.MonitorNotification;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.apache.qpid.management.common.mbeans.ManagedQueue;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.mbeans.MBeanUtils;
import org.apache.qpid.server.jmx.mbeans.VirtualHostMBean;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.QueueNotificationListener;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class QueueMBean
extends AMQManagedObject
implements ManagedQueue,
QueueNotificationListener {
    private static final Logger LOGGER = Logger.getLogger(QueueMBean.class);
    private static final String[] VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC_ARRAY = VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC.size()]);
    private static final OpenType[] MSG_ATTRIBUTE_TYPES;
    private static final CompositeType MSG_DATA_TYPE;
    private static final TabularType MSG_LIST_DATA_TYPE;
    private static final CompositeType MSG_CONTENT_TYPE;
    private static final String[] VIEW_MSG_COMPOSITE_ITEM_NAMES_ARRAY;
    private final Queue<?> _queue;
    private final VirtualHostMBean _vhostMBean;
    public static final String JMSTIMESTAMP_DATETIME_FORMAT = "MM-dd-yy HH:mm:ss.SSS z";
    private static final FastDateFormat FAST_DATE_FORMAT;

    public QueueMBean(Queue queue, VirtualHostMBean virtualHostMBean) throws JMException {
        super(ManagedQueue.class, "Queue", virtualHostMBean.getRegistry());
        this._queue = queue;
        this._vhostMBean = virtualHostMBean;
        this.register();
        this._queue.setNotificationListener((QueueNotificationListener)this);
    }

    @Override
    public ManagedObject getParentObject() {
        return this._vhostMBean;
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(this.getName());
    }

    public String getName() {
        return this._queue.getName();
    }

    public Integer getMessageCount() {
        return this._queue.getQueueDepthMessages();
    }

    public Integer getMaximumDeliveryCount() {
        return (Integer)this._queue.getAttribute("maximumDeliveryAttempts");
    }

    public Long getReceivedMessageCount() {
        return this._queue.getTotalEnqueuedMessages();
    }

    public Long getQueueDepth() {
        return this._queue.getQueueDepthBytes();
    }

    public Integer getActiveConsumerCount() {
        return this._queue.getConsumerCountWithCredit();
    }

    public Integer getConsumerCount() {
        return this._queue.getConsumerCount();
    }

    public String getOwner() {
        return (String)this._queue.getAttribute("owner");
    }

    public String getQueueType() {
        return (String)this._queue.getAttribute("queueType");
    }

    public boolean isDurable() {
        return this._queue.isDurable();
    }

    public boolean isAutoDelete() {
        return this._queue.getLifetimePolicy() != LifetimePolicy.PERMANENT;
    }

    public Long getMaximumMessageAge() {
        return (Long)this._queue.getAttribute("alertThresholdMessageAge");
    }

    public void setMaximumMessageAge(Long age) {
        this._queue.setAttribute("alertThresholdMessageAge", (Object)this.getMaximumMessageAge(), (Object)age);
    }

    public Long getMaximumMessageSize() {
        return (Long)this._queue.getAttribute("alertThresholdMessageSize");
    }

    public void setMaximumMessageSize(Long size) {
        this._queue.setAttribute("alertThresholdMessageSize", (Object)this.getMaximumMessageSize(), (Object)size);
    }

    public Long getMaximumMessageCount() {
        return (Long)this._queue.getAttribute("alertThresholdQueueDepthMessages");
    }

    public void setMaximumMessageCount(Long value) {
        this._queue.setAttribute("alertThresholdQueueDepthMessages", (Object)this.getMaximumMessageCount(), (Object)value);
    }

    public Long getMaximumQueueDepth() {
        return (Long)this._queue.getAttribute("alertThresholdQueueDepthBytes");
    }

    public void setMaximumQueueDepth(Long value) {
        this._queue.setAttribute("alertThresholdQueueDepthBytes", (Object)this.getMaximumQueueDepth(), (Object)value);
    }

    public Long getCapacity() {
        return (Long)this._queue.getAttribute("queueFlowControlSizeBytes");
    }

    public void setCapacity(Long value) {
        this._queue.setAttribute("queueFlowControlSizeBytes", (Object)this.getCapacity(), (Object)value);
    }

    public Long getFlowResumeCapacity() {
        return (Long)this._queue.getAttribute("queueFlowResumeSizeBytes");
    }

    public void setFlowResumeCapacity(Long value) {
        this._queue.setAttribute("queueFlowResumeSizeBytes", (Object)this.getFlowResumeCapacity(), (Object)value);
    }

    public boolean isFlowOverfull() {
        return (Boolean)this._queue.getAttribute("queueFlowStopped");
    }

    public boolean isExclusive() {
        Object attribute = this._queue.getAttribute("exclusive");
        return attribute != null && attribute != ExclusivityPolicy.NONE;
    }

    public void setExclusive(boolean exclusive) {
        if (exclusive) {
            Object currentValue = this._queue.getAttribute("exclusive");
            if (currentValue == null || currentValue == ExclusivityPolicy.NONE) {
                this._queue.setAttribute("exclusive", currentValue, (Object)ExclusivityPolicy.CONTAINER);
            }
        } else {
            Object currentValue = this._queue.getAttribute("exclusive");
            if (currentValue != null && currentValue != ExclusivityPolicy.NONE) {
                this._queue.setAttribute("exclusive", currentValue, (Object)ExclusivityPolicy.NONE);
            }
        }
    }

    public void setAlternateExchange(String exchangeName) throws OperationsException {
        if (exchangeName == null || "".equals(exchangeName)) {
            this._queue.setAttribute("alternateExchange", (Object)this.getAlternateExchange(), null);
        } else {
            VirtualHost virtualHost = (VirtualHost)this._queue.getParent(VirtualHost.class);
            Exchange exchange = MBeanUtils.findExchangeFromExchangeName(virtualHost, exchangeName);
            this._queue.setAttribute("alternateExchange", (Object)this.getAlternateExchange(), (Object)exchange);
        }
    }

    public String getAlternateExchange() {
        Exchange alternateExchange = (Exchange)this._queue.getAttribute("alternateExchange");
        return alternateExchange == null ? null : alternateExchange.getName();
    }

    public TabularData viewMessages(int fromIndex, int toIndex) throws IOException, JMException {
        return this.viewMessages((long)fromIndex, (long)toIndex);
    }

    public TabularData viewMessages(long startPosition, long endPosition) throws IOException, JMException {
        if (startPosition > endPosition || startPosition < 1L) {
            throw new OperationsException("From Index = " + startPosition + ", To Index = " + endPosition + "\n\"From Index\" should be greater than 0 and less than \"To Index\"");
        }
        if (endPosition - startPosition > Integer.MAX_VALUE) {
            throw new OperationsException("Specified MessageID interval is too large. Intervals must be less than 2^31 in size");
        }
        List<QueueEntry> messages = this.getMessages(startPosition, endPosition);
        TabularDataSupport messageTable = new TabularDataSupport(MSG_LIST_DATA_TYPE);
        long position = startPosition;
        for (QueueEntry queueEntry : messages) {
            ServerMessage serverMsg = queueEntry.getMessage();
            AMQMessageHeader header = serverMsg.getMessageHeader();
            String[] headerAttributes = new String[]{"reply-to = " + header.getReplyTo(), "propertyFlags = ", "ApplicationID = " + header.getAppId(), "ClusterID = ", "UserId = " + header.getUserId(), "JMSMessageID = " + header.getMessageId(), "JMSCorrelationID = " + header.getCorrelationId(), "JMSDeliveryMode = " + (serverMsg.isPersistent() ? "Persistent" : "Non_Persistent"), "JMSPriority = " + header.getPriority(), "JMSType = " + header.getType(), "JMSExpiration = " + (header.getExpiration() == 0L ? null : FAST_DATE_FORMAT.format(header.getExpiration())), "JMSTimestamp = " + (header.getTimestamp() == 0L ? null : FAST_DATE_FORMAT.format(header.getTimestamp()))};
            Object[] itemValues = new Object[]{serverMsg.getMessageNumber(), headerAttributes, serverMsg.getSize(), queueEntry.isRedelivered(), position, queueEntry.getDeliveryCount()};
            ++position;
            CompositeDataSupport messageData = new CompositeDataSupport(MSG_DATA_TYPE, VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC_ARRAY, itemValues);
            messageTable.put(messageData);
        }
        return messageTable;
    }

    public CompositeData viewMessageContent(long messageId) throws IOException, JMException {
        byte[] msgContent;
        ByteBuffer buf;
        int stored;
        QueueEntry entry = this.getMessage(messageId);
        if (entry == null) {
            throw new OperationsException("AMQMessage with message id = " + messageId + " is not in the " + this._queue.getName());
        }
        ServerMessage serverMsg = entry.getMessage();
        int bodySize = (int)serverMsg.getSize();
        if (bodySize != (stored = serverMsg.getContent(buf = ByteBuffer.wrap(msgContent = new byte[bodySize]), 0))) {
            LOGGER.error((Object)String.format("An unexpected amount of content was retrieved (expected %d, got %d bytes) when viewing content for message with ID %d on queue '%s' in virtual host '%s'", bodySize, stored, messageId, this._queue.getName(), this._vhostMBean.getName()));
        }
        AMQMessageHeader header = serverMsg.getMessageHeader();
        String mimeType = null;
        String encoding = null;
        if (header != null) {
            mimeType = header.getMimeType();
            encoding = header.getEncoding();
        }
        Object[] itemValues = new Object[]{messageId, mimeType, encoding, msgContent};
        return new CompositeDataSupport(MSG_CONTENT_TYPE, VIEW_MSG_COMPOSITE_ITEM_NAMES_ARRAY, itemValues);
    }

    private QueueEntry getMessage(long messageId) {
        GetMessageVisitor visitor = new GetMessageVisitor(messageId);
        this._queue.visit((QueueEntryVisitor)visitor);
        return visitor.getEntry();
    }

    public void deleteMessageFromTop() throws IOException, JMException {
        VirtualHost vhost = (VirtualHost)this._queue.getParent(VirtualHost.class);
        vhost.executeTransaction(new VirtualHost.TransactionalOperation(){

            public void withinTransaction(final VirtualHost.Transaction txn) {
                QueueMBean.this._queue.visit(new QueueEntryVisitor(){

                    public boolean visit(QueueEntry entry) {
                        if (entry.acquire()) {
                            txn.dequeue((MessageInstance)entry);
                            return true;
                        }
                        return false;
                    }
                });
            }
        });
    }

    public Long clearQueue() throws IOException, JMException {
        VirtualHost vhost = (VirtualHost)this._queue.getParent(VirtualHost.class);
        final AtomicLong count = new AtomicLong();
        vhost.executeTransaction(new VirtualHost.TransactionalOperation(){

            public void withinTransaction(final VirtualHost.Transaction txn) {
                QueueMBean.this._queue.visit(new QueueEntryVisitor(){

                    public boolean visit(QueueEntry entry) {
                        ServerMessage message = entry.getMessage();
                        if (message != null) {
                            txn.dequeue((MessageInstance)entry);
                            count.incrementAndGet();
                        }
                        return false;
                    }
                });
            }
        });
        return count.get();
    }

    public void moveMessages(final long fromMessageId, final long toMessageId, String toQueue) throws IOException, JMException {
        if (fromMessageId > toMessageId || fromMessageId < 1L) {
            throw new OperationsException("\"From MessageId\" should be greater than 0 and less than \"To MessageId\"");
        }
        VirtualHost vhost = (VirtualHost)this._queue.getParent(VirtualHost.class);
        final Queue destinationQueue = MBeanUtils.findQueueFromQueueName(vhost, toQueue);
        vhost.executeTransaction(new VirtualHost.TransactionalOperation(){

            public void withinTransaction(final VirtualHost.Transaction txn) {
                QueueMBean.this._queue.visit(new QueueEntryVisitor(){

                    public boolean visit(QueueEntry entry) {
                        long messageId;
                        ServerMessage message = entry.getMessage();
                        if (message != null && (messageId = message.getMessageNumber()) >= fromMessageId && messageId <= toMessageId) {
                            txn.move((MessageInstance)entry, destinationQueue);
                        }
                        return false;
                    }
                });
            }
        });
    }

    public void deleteMessages(final long fromMessageId, final long toMessageId) throws IOException, JMException {
        VirtualHost vhost = (VirtualHost)this._queue.getParent(VirtualHost.class);
        vhost.executeTransaction(new VirtualHost.TransactionalOperation(){

            public void withinTransaction(final VirtualHost.Transaction txn) {
                QueueMBean.this._queue.visit(new QueueEntryVisitor(){

                    public boolean visit(QueueEntry entry) {
                        long messageId;
                        ServerMessage message = entry.getMessage();
                        if (message != null && (messageId = message.getMessageNumber()) >= fromMessageId && messageId <= toMessageId) {
                            txn.dequeue((MessageInstance)entry);
                        }
                        return false;
                    }
                });
            }
        });
    }

    public void copyMessages(final long fromMessageId, final long toMessageId, String toQueue) throws IOException, JMException {
        if (fromMessageId > toMessageId || fromMessageId < 1L) {
            throw new OperationsException("\"From MessageId\" should be greater than 0 and less than \"To MessageId\"");
        }
        VirtualHost vhost = (VirtualHost)this._queue.getParent(VirtualHost.class);
        final Queue destinationQueue = MBeanUtils.findQueueFromQueueName(vhost, toQueue);
        vhost.executeTransaction(new VirtualHost.TransactionalOperation(){

            public void withinTransaction(final VirtualHost.Transaction txn) {
                QueueMBean.this._queue.visit(new QueueEntryVisitor(){

                    public boolean visit(QueueEntry entry) {
                        long messageId;
                        ServerMessage message = entry.getMessage();
                        if (message != null && (messageId = message.getMessageNumber()) >= fromMessageId && messageId <= toMessageId) {
                            txn.copy((MessageInstance)entry, destinationQueue);
                        }
                        return false;
                    }
                });
            }
        });
    }

    private List<QueueEntry> getMessages(final long first, final long last) {
        final ArrayList<QueueEntry> messages = new ArrayList<QueueEntry>((int)(last - first) + 1);
        this._queue.visit(new QueueEntryVisitor(){
            private long position = 1L;

            public boolean visit(QueueEntry entry) {
                if (this.position >= first && this.position <= last) {
                    messages.add(entry);
                }
                ++this.position;
                return this.position > last;
            }
        });
        return messages;
    }

    public void notifyClients(NotificationCheck notification, Queue queue, String notificationMsg) {
        notificationMsg = notification.name() + " " + notificationMsg;
        Notification note = new Notification("jmx.monitor.counter.threshold", this, this.incrementAndGetSequenceNumber(), System.currentTimeMillis(), notificationMsg);
        this.getBroadcaster().sendNotification(note);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] notificationTypes = new String[]{"jmx.monitor.counter.threshold"};
        String name = MonitorNotification.class.getName();
        String description = "Either Message count or Queue depth or Message size has reached threshold high value";
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(notificationTypes, name, description);
        return new MBeanNotificationInfo[]{info1};
    }

    public String getDescription() {
        return (String)this._queue.getAttribute("description");
    }

    public void setDescription(String description) {
        this._queue.setAttribute("description", (Object)this.getDescription(), (Object)description);
    }

    public String getMessageGroupKey() {
        return (String)this._queue.getAttribute("messageGroupKey");
    }

    public boolean isMessageGroupSharedGroups() {
        Boolean value = (Boolean)this._queue.getAttribute("messageGroupSharedGroups");
        return value == null ? false : value;
    }

    static {
        VIEW_MSG_COMPOSITE_ITEM_NAMES_ARRAY = VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]);
        try {
            MSG_ATTRIBUTE_TYPES = new OpenType[]{SimpleType.LONG, new ArrayType(1, SimpleType.STRING), SimpleType.LONG, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.INTEGER};
            MSG_DATA_TYPE = new CompositeType("Message", "AMQ Message", VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC_ARRAY, VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC_ARRAY, MSG_ATTRIBUTE_TYPES);
            MSG_LIST_DATA_TYPE = new TabularType("Messages", "List of messages", MSG_DATA_TYPE, VIEW_MSGS_TABULAR_UNIQUE_INDEX.toArray(new String[VIEW_MSGS_TABULAR_UNIQUE_INDEX.size()]));
            OpenType[] msgContentAttrs = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, new ArrayType(SimpleType.BYTE, true)};
            MSG_CONTENT_TYPE = new CompositeType("Message Content", "AMQ Message Content", VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]), VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]), msgContentAttrs);
        }
        catch (OpenDataException e) {
            throw new ServerScopedRuntimeException((Throwable)e);
        }
        FAST_DATE_FORMAT = FastDateFormat.getInstance((String)JMSTIMESTAMP_DATETIME_FORMAT);
    }

    protected static class GetMessageVisitor
    implements QueueEntryVisitor {
        private final long _messageNumber;
        private QueueEntry _entry;

        public GetMessageVisitor(long messageId) {
            this._messageNumber = messageId;
        }

        public boolean visit(QueueEntry entry) {
            if (entry.getMessage().getMessageNumber() == this._messageNumber) {
                this._entry = entry;
                return true;
            }
            return false;
        }

        public QueueEntry getEntry() {
            return this._entry;
        }
    }
}

