/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.log4j.Logger;
import org.apache.qpid.management.common.mbeans.LoggingManagement;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.logging.log4j.LoggingFacadeException;
import org.apache.qpid.server.logging.log4j.LoggingManagementFacade;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

@MBeanDescription(value="Logging Management Interface")
public class LoggingManagementMBean
extends AMQManagedObject
implements LoggingManagement {
    public static final String INHERITED_PSUEDO_LOG_LEVEL = "INHERITED";
    private static final Logger LOGGER = Logger.getLogger(LoggingManagementMBean.class);
    private static final TabularType LOGGER_LEVEL_TABULAR_TYE;
    private static final CompositeType LOGGER_LEVEL_COMPOSITE_TYPE;
    private final LoggingManagementFacade _loggingManagementFacade;
    private final String[] _allAvailableLogLevels;

    public LoggingManagementMBean(LoggingManagementFacade loggingManagementFacade, ManagedObjectRegistry registry) throws JMException {
        super(LoggingManagement.class, "LoggingManagement", registry);
        this.register();
        this._loggingManagementFacade = loggingManagementFacade;
        this._allAvailableLogLevels = this.buildAllAvailableLoggerLevelsWithInheritedPsuedoLogLevel(this._loggingManagementFacade);
    }

    @Override
    public String getObjectInstanceName() {
        return "LoggingManagement";
    }

    @Override
    public ManagedObject getParentObject() {
        return null;
    }

    public Integer getLog4jLogWatchInterval() {
        return this._loggingManagementFacade.getLog4jLogWatchInterval();
    }

    public String[] getAvailableLoggerLevels() {
        return this._allAvailableLogLevels;
    }

    public TabularData viewEffectiveRuntimeLoggerLevels() {
        Map levels = this._loggingManagementFacade.retrieveRuntimeLoggersLevels();
        return this.createTabularDataFromLevelsMap(levels);
    }

    public String getRuntimeRootLoggerLevel() {
        return this._loggingManagementFacade.retrieveRuntimeRootLoggerLevel();
    }

    public boolean setRuntimeRootLoggerLevel(String level) {
        try {
            this.validateLevelNotAllowingInherited(level);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn((Object)(level + " is not a known level"));
            return false;
        }
        this._loggingManagementFacade.setRuntimeRootLoggerLevel(level);
        return true;
    }

    public boolean setRuntimeLoggerLevel(String logger, String level) {
        String validatedLevel;
        try {
            validatedLevel = this.getValidateLevelAllowingInherited(level);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn((Object)(level + " is not a known level"));
            return false;
        }
        try {
            this._loggingManagementFacade.setRuntimeLoggerLevel(logger, validatedLevel);
        }
        catch (LoggingFacadeException e) {
            LOGGER.error((Object)"Cannot set runtime logging level", (Throwable)e);
            return false;
        }
        return true;
    }

    public TabularData viewConfigFileLoggerLevels() {
        Map levels;
        try {
            levels = this._loggingManagementFacade.retrieveConfigFileLoggersLevels();
        }
        catch (LoggingFacadeException e) {
            LOGGER.error((Object)"Cannot determine logging levels", (Throwable)e);
            return null;
        }
        return this.createTabularDataFromLevelsMap(levels);
    }

    public String getConfigFileRootLoggerLevel() throws IOException {
        try {
            return this._loggingManagementFacade.retrieveConfigFileRootLoggerLevel().toUpperCase();
        }
        catch (LoggingFacadeException e) {
            LOGGER.warn((Object)"The log4j configuration get config request was aborted: ", (Throwable)e);
            throw new IOException("The log4j configuration get config request was aborted: " + e.getMessage());
        }
    }

    public boolean setConfigFileLoggerLevel(String logger, String level) {
        String validatedLevel;
        try {
            validatedLevel = this.getValidateLevelAllowingInherited(level);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn((Object)(level + " is not a known level"));
            return false;
        }
        try {
            this._loggingManagementFacade.setConfigFileLoggerLevel(logger, validatedLevel);
        }
        catch (LoggingFacadeException e) {
            LOGGER.warn((Object)"The log4j configuration set config request was aborted: ", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setConfigFileRootLoggerLevel(String level) {
        try {
            this.validateLevelNotAllowingInherited(level);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn((Object)(level + " is not a known level"));
            return false;
        }
        try {
            this._loggingManagementFacade.setConfigFileRootLoggerLevel(level);
            return true;
        }
        catch (LoggingFacadeException e) {
            LOGGER.warn((Object)"The log4j configuration set config request was aborted: ", (Throwable)e);
            return false;
        }
    }

    public void reloadConfigFile() throws IOException {
        try {
            this._loggingManagementFacade.reload();
        }
        catch (LoggingFacadeException e) {
            LOGGER.warn((Object)"The log4j configuration reload request was aborted: ", (Throwable)e);
            throw new IOException("The log4j configuration reload request was aborted: " + e.getMessage());
        }
    }

    private String getValidateLevelAllowingInherited(String level) {
        if (level == null || "null".equalsIgnoreCase(level) || INHERITED_PSUEDO_LOG_LEVEL.equalsIgnoreCase(level)) {
            return null;
        }
        this.validateLevelNotAllowingInherited(level);
        return level;
    }

    private void validateLevelNotAllowingInherited(String level) {
        List availableLoggerLevels = this._loggingManagementFacade.getAvailableLoggerLevels();
        if (level == null || !availableLoggerLevels.contains(level.toUpperCase())) {
            throw new IllegalArgumentException(level + " not known");
        }
    }

    private TabularData createTabularDataFromLevelsMap(Map<String, String> levels) {
        TabularDataSupport loggerLevelList = new TabularDataSupport(LOGGER_LEVEL_TABULAR_TYE);
        for (Map.Entry<String, String> entry : levels.entrySet()) {
            String loggerName = entry.getKey();
            String level = entry.getValue();
            CompositeData loggerData = this.createRow(loggerName, level);
            loggerLevelList.put(loggerData);
        }
        return loggerLevelList;
    }

    private CompositeData createRow(String loggerName, String level) {
        Object[] itemData = new Object[]{loggerName, level.toUpperCase()};
        try {
            CompositeDataSupport loggerData = new CompositeDataSupport(LOGGER_LEVEL_COMPOSITE_TYPE, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), itemData);
            return loggerData;
        }
        catch (OpenDataException ode) {
            throw new ConnectionScopedRuntimeException((Throwable)ode);
        }
    }

    private String[] buildAllAvailableLoggerLevelsWithInheritedPsuedoLogLevel(LoggingManagementFacade loggingManagementFacade) {
        List levels = loggingManagementFacade.getAvailableLoggerLevels();
        ArrayList<String> mbeanLevels = new ArrayList<String>(levels);
        mbeanLevels.add(INHERITED_PSUEDO_LOG_LEVEL);
        return mbeanLevels.toArray(new String[mbeanLevels.size()]);
    }

    static {
        try {
            OpenType[] loggerLevelItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            LOGGER_LEVEL_COMPOSITE_TYPE = new CompositeType("LoggerLevelList", "Logger Level Data", COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), COMPOSITE_ITEM_DESCRIPTIONS.toArray(new String[COMPOSITE_ITEM_DESCRIPTIONS.size()]), loggerLevelItemTypes);
            LOGGER_LEVEL_TABULAR_TYE = new TabularType("LoggerLevel", "List of loggers with levels", LOGGER_LEVEL_COMPOSITE_TYPE, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
        }
        catch (OpenDataException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

