/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.qpid.management.common.mbeans.ManagedExchange;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.mbeans.MBeanUtils;
import org.apache.qpid.server.jmx.mbeans.VirtualHostMBean;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class ExchangeMBean
extends AMQManagedObject
implements ManagedExchange {
    public static final String FANOUT_EXCHANGE_TYPE = "fanout";
    public static final String HEADERS_EXCHANGE_TYPE = "headers";
    private static final String[] TABULAR_UNIQUE_INDEX_ARRAY = TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]);
    private static final String[] COMPOSITE_ITEM_NAMES_ARRAY = COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]);
    private static final String[] COMPOSITE_ITEM_DESCRIPTIONS_ARRAY = COMPOSITE_ITEM_DESCRIPTIONS.toArray(new String[COMPOSITE_ITEM_DESCRIPTIONS.size()]);
    private static final OpenType[] BINDING_ITEM_TYPES;
    private static final CompositeType BINDING_DATA_TYPE;
    private static final OpenType[] HEADERS_BINDING_ITEM_TYPES;
    private static final CompositeType HEADERS_BINDING_DATA_TYPE;
    private static final String[] HEADERS_COMPOSITE_ITEM_NAMES_ARRAY;
    private static final String[] HEADERS_COMPOSITE_ITEM_DESCS_ARRAY;
    private static final String[] HEADERS_TABULAR_UNIQUE_INDEX_ARRAY;
    private final Exchange<?> _exchange;
    private final VirtualHostMBean _vhostMBean;

    protected ExchangeMBean(Exchange exchange, VirtualHostMBean virtualHostMBean) throws JMException {
        super(ManagedExchange.class, "Exchange", virtualHostMBean.getRegistry());
        this._exchange = exchange;
        this._vhostMBean = virtualHostMBean;
        this.register();
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(this.getName());
    }

    @Override
    public ManagedObject getParentObject() {
        return this._vhostMBean;
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        String objNameString = super.getObjectName().toString();
        objNameString = objNameString + ",ExchangeType=" + this.getExchangeType();
        return new ObjectName(objNameString);
    }

    public String getName() {
        return this._exchange.getName();
    }

    public String getExchangeType() {
        return this._exchange.getType();
    }

    public Integer getTicketNo() {
        return 0;
    }

    public boolean isDurable() {
        return this._exchange.isDurable();
    }

    public boolean isAutoDelete() {
        return this._exchange.getLifetimePolicy() != LifetimePolicy.PERMANENT;
    }

    public TabularData bindings() throws IOException, JMException {
        if (HEADERS_EXCHANGE_TYPE.equals(this._exchange.getType())) {
            return this.getHeadersBindings(this._exchange.getBindings());
        }
        return this.getNonHeadersBindings(this._exchange.getBindings());
    }

    private TabularData getHeadersBindings(Collection<? extends Binding> bindings) throws OpenDataException {
        TabularType bindinglistDataType = new TabularType("Exchange Bindings", "List of exchange bindings for " + this.getName(), HEADERS_BINDING_DATA_TYPE, HEADERS_TABULAR_UNIQUE_INDEX_ARRAY);
        TabularDataSupport bindingList = new TabularDataSupport(bindinglistDataType);
        int count = 1;
        for (Binding binding : bindings) {
            String queueName = binding.getParent(Queue.class).getName();
            Map headerMappings = binding.getArguments();
            ArrayList<String> mappingList = new ArrayList<String>();
            if (headerMappings != null) {
                for (Map.Entry entry : headerMappings.entrySet()) {
                    mappingList.add((String)entry.getKey() + "=" + entry.getValue());
                }
            }
            Object[] bindingItemValues = new Object[]{count++, queueName, mappingList.toArray(new String[0])};
            CompositeDataSupport bindingData = new CompositeDataSupport(HEADERS_BINDING_DATA_TYPE, HEADERS_COMPOSITE_ITEM_NAMES_ARRAY, bindingItemValues);
            bindingList.put(bindingData);
        }
        return bindingList;
    }

    private TabularData getNonHeadersBindings(Collection<? extends Binding> bindings) throws OpenDataException {
        TabularType bindinglistDataType = new TabularType("Exchange Bindings", "Exchange Bindings for " + this.getName(), BINDING_DATA_TYPE, TABULAR_UNIQUE_INDEX_ARRAY);
        TabularDataSupport bindingList = new TabularDataSupport(bindinglistDataType);
        HashMap<String, ArrayList<String>> bindingMap = new HashMap<String, ArrayList<String>>();
        for (Binding binding : bindings) {
            String key = FANOUT_EXCHANGE_TYPE.equals(this._exchange.getType()) ? "*" : binding.getName();
            ArrayList<String> queueList = (ArrayList<String>)bindingMap.get(key);
            if (queueList == null) {
                queueList = new ArrayList<String>();
                bindingMap.put(key, queueList);
            }
            queueList.add(binding.getParent(Queue.class).getName());
        }
        for (Map.Entry entry : bindingMap.entrySet()) {
            Object[] bindingItemValues = new Object[]{entry.getKey(), ((List)entry.getValue()).toArray(new String[0])};
            CompositeDataSupport bindingData = new CompositeDataSupport(BINDING_DATA_TYPE, COMPOSITE_ITEM_NAMES_ARRAY, bindingItemValues);
            bindingList.put(bindingData);
        }
        return bindingList;
    }

    public void createNewBinding(String queueName, String binding) throws JMException {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        this.createNewBinding(queueName, binding, arguments);
    }

    public void createNewBinding(String queueName, String binding, Map<String, Object> arguments) throws JMException {
        if (HEADERS_EXCHANGE_TYPE.equals(this._exchange.getType())) {
            arguments = new HashMap<String, Object>(arguments);
            String[] bindings = binding.split(",");
            for (int i = 0; i < bindings.length; ++i) {
                String[] keyAndValue = bindings[i].split("=");
                if (keyAndValue == null || keyAndValue.length == 0 || keyAndValue.length > 2 || keyAndValue[0].length() == 0) {
                    throw new JMException("Format for headers binding should be \"<attribute1>=<value1>,<attribute2>=<value2>\"");
                }
                if (keyAndValue.length == 1) {
                    arguments.put(keyAndValue[0], "");
                    continue;
                }
                arguments.put(keyAndValue[0], keyAndValue[1]);
            }
        }
        VirtualHost virtualHost = (VirtualHost)this._exchange.getParent(VirtualHost.class);
        Queue queue = MBeanUtils.findQueueFromQueueName(virtualHost, queueName);
        this._exchange.createBinding(binding, queue, arguments, Collections.EMPTY_MAP);
    }

    public void removeBinding(String queueName, String bindingKey) throws IOException, JMException {
        VirtualHost virtualHost = (VirtualHost)this._exchange.getParent(VirtualHost.class);
        Queue queue = MBeanUtils.findQueueFromQueueName(virtualHost, queueName);
        boolean deleted = false;
        for (Binding binding : this._exchange.getBindings()) {
            if (!queue.equals(binding.getParent(Queue.class)) || !bindingKey.equals(binding.getName())) continue;
            binding.delete();
            deleted = true;
        }
        if (!deleted) {
            throw new OperationsException("No such binding \"" + bindingKey + "\" on queue \"" + queueName + "\"");
        }
    }

    static {
        HEADERS_COMPOSITE_ITEM_NAMES_ARRAY = HEADERS_COMPOSITE_ITEM_NAMES.toArray(new String[HEADERS_COMPOSITE_ITEM_NAMES.size()]);
        HEADERS_COMPOSITE_ITEM_DESCS_ARRAY = HEADERS_COMPOSITE_ITEM_DESC.toArray(new String[HEADERS_COMPOSITE_ITEM_DESC.size()]);
        HEADERS_TABULAR_UNIQUE_INDEX_ARRAY = HEADERS_TABULAR_UNIQUE_INDEX.toArray(new String[HEADERS_TABULAR_UNIQUE_INDEX.size()]);
        try {
            BINDING_ITEM_TYPES = new OpenType[]{SimpleType.STRING, new ArrayType(1, SimpleType.STRING)};
            BINDING_DATA_TYPE = new CompositeType("Exchange Binding", "Binding key and Queue names", COMPOSITE_ITEM_NAMES_ARRAY, COMPOSITE_ITEM_DESCRIPTIONS_ARRAY, BINDING_ITEM_TYPES);
            HEADERS_BINDING_ITEM_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, new ArrayType(1, SimpleType.STRING)};
            HEADERS_BINDING_DATA_TYPE = new CompositeType("Exchange Binding", "Queue name and header bindings", HEADERS_COMPOSITE_ITEM_NAMES_ARRAY, HEADERS_COMPOSITE_ITEM_DESCS_ARRAY, HEADERS_BINDING_ITEM_TYPES);
        }
        catch (OpenDataException e) {
            throw new ServerScopedRuntimeException("Unexpected Error creating ArrayType", (Throwable)e);
        }
    }
}

