/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.io.IOException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.security.auth.Subject;
import org.apache.qpid.server.jmx.UsernameAccessor;

public class UsernameCachingRMIJRMPServer
extends RMIJRMPServerImpl
implements NotificationListener,
NotificationFilter,
UsernameAccessor {
    private final Map<String, Subject> _connectionIdUsernameMap = new ConcurrentHashMap<String, Subject>();

    UsernameCachingRMIJRMPServer(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Map<String, ?> env) throws IOException {
        super(port, csf, ssf, env);
    }

    @Override
    protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
        RMIConnection makeClient = super.makeClient(connectionId, subject);
        this._connectionIdUsernameMap.put(connectionId, subject);
        return makeClient;
    }

    @Override
    public Subject getSubjectConnectionId(String connectionId) {
        return this._connectionIdUsernameMap.get(connectionId);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String connectionId = ((JMXConnectionNotification)notification).getConnectionId();
        this.removeConnectionIdFromCache(connectionId);
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        return this.isClientDisconnectEvent(notification);
    }

    private void removeConnectionIdFromCache(String connectionId) {
        this._connectionIdUsernameMap.remove(connectionId);
    }

    private boolean isClientDisconnectEvent(Notification notification) {
        String type = notification.getType();
        return "jmx.remote.connection.closed".equals(type) || "jmx.remote.connection.failed".equals(type);
    }
}

