/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.apache.qpid.server.jmx.MBeanIntrospector;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;

public abstract class DefaultManagedObject
extends StandardMBean
implements ManagedObject {
    private static final Logger LOGGER = Logger.getLogger(DefaultManagedObject.class);
    private final Class<?> _managementInterface;
    private final String _typeName;
    private final MBeanInfo _mbeanInfo;
    private ManagedObjectRegistry _registry;

    protected DefaultManagedObject(Class<?> managementInterface, String typeName, ManagedObjectRegistry registry) throws NotCompliantMBeanException {
        super(managementInterface);
        this._registry = registry;
        this._managementInterface = managementInterface;
        this._typeName = typeName;
        this._mbeanInfo = this.buildMBeanInfo();
    }

    public ManagedObjectRegistry getRegistry() {
        return this._registry;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this._mbeanInfo;
    }

    @Override
    public String getType() {
        return this._typeName;
    }

    @Override
    public Class<?> getManagementInterface() {
        return this._managementInterface;
    }

    @Override
    public abstract ManagedObject getParentObject();

    @Override
    public void register() throws JMException {
        this._registry.registerObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() throws JMException {
        try {
            if (this._registry != null) {
                this._registry.unregisterObject(this);
            }
        }
        finally {
            this._registry = null;
        }
    }

    public String toString() {
        return this.getObjectInstanceName() + "[" + this.getType() + "]";
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        String name = this.getObjectInstanceName();
        StringBuffer objectName = new StringBuffer("org.apache.qpid");
        objectName.append(":type=");
        objectName.append(this.getHierarchicalType(this));
        objectName.append(",");
        objectName.append(this.getHierarchicalName(this));
        objectName.append("name=").append(name);
        return new ObjectName(objectName.toString());
    }

    protected ObjectName getObjectNameForSingleInstanceMBean() throws MalformedObjectNameException {
        StringBuffer objectName = new StringBuffer("org.apache.qpid");
        objectName.append(":type=");
        objectName.append(this.getHierarchicalType(this));
        String hierarchyName = this.getHierarchicalName(this);
        if (hierarchyName != null) {
            objectName.append(",");
            objectName.append(hierarchyName.substring(0, hierarchyName.lastIndexOf(",")));
        }
        return new ObjectName(objectName.toString());
    }

    protected String getHierarchicalType(ManagedObject obj) {
        if (obj.getParentObject() != null) {
            String parentType = this.getHierarchicalType(obj.getParentObject()).toString();
            return parentType + "." + obj.getType();
        }
        return obj.getType();
    }

    protected String getHierarchicalName(ManagedObject obj) {
        if (obj.getParentObject() != null) {
            String parentName = obj.getParentObject().getType() + "=" + obj.getParentObject().getObjectInstanceName() + "," + this.getHierarchicalName(obj.getParentObject());
            return parentName;
        }
        return "";
    }

    private MBeanInfo buildMBeanInfo() throws NotCompliantMBeanException {
        return new MBeanInfo(this.getClass().getName(), MBeanIntrospector.getMBeanDescription(this.getClass()), MBeanIntrospector.getMBeanAttributesInfo(this.getManagementInterface()), MBeanIntrospector.getMBeanConstructorsInfo(this.getClass()), MBeanIntrospector.getMBeanOperationsInfo(this.getManagementInterface()), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }
}

