/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.AbstractJDBCConfigurationStore;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.derby.AbstractDerbyMessageStore;
import org.apache.qpid.server.store.derby.DerbyUtils;

public class DerbyConfigurationStore
extends AbstractJDBCConfigurationStore
implements MessageStoreProvider,
DurableConfigurationStore {
    private static final Logger LOGGER = Logger.getLogger(DerbyConfigurationStore.class);
    private final AtomicBoolean _configurationStoreOpen = new AtomicBoolean();
    private final ProvidedMessageStore _providedMessageStore = new ProvidedMessageStore();
    private String _connectionURL;
    private String _storeLocation;
    private ConfiguredObject<?> _parent;
    private final Class<? extends ConfiguredObject> _rootClass;

    public DerbyConfigurationStore(Class<? extends ConfiguredObject> rootClass) {
        this._rootClass = rootClass;
    }

    public void openConfigurationStore(ConfiguredObject<?> parent, boolean overwrite, ConfiguredObjectRecord ... initialRecords) throws StoreException {
        if (this._configurationStoreOpen.compareAndSet(false, true)) {
            this._parent = parent;
            DerbyUtils.loadDerbyDriver();
            FileBasedSettings settings = (FileBasedSettings)parent;
            this._storeLocation = settings.getStorePath();
            this._connectionURL = DerbyUtils.createConnectionUrl(parent.getName(), this._storeLocation);
            this.createOrOpenConfigurationStoreDatabase(overwrite);
            if (this.hasNoConfigurationEntries()) {
                this.update(true, initialRecords);
            }
        }
    }

    public void upgradeStoreStructure() throws StoreException {
        this.checkConfigurationStoreOpen();
        this.upgradeIfNecessary(this._parent);
    }

    protected Connection getConnection() throws SQLException {
        this.checkConfigurationStoreOpen();
        return DriverManager.getConnection(this._connectionURL);
    }

    public void closeConfigurationStore() throws StoreException {
        if (this._providedMessageStore.isMessageStoreOpen()) {
            throw new IllegalStateException("Cannot close the store as the provided message store is still open");
        }
        if (this._configurationStoreOpen.compareAndSet(true, false)) {
            try {
                DerbyUtils.shutdownDatabase(this._connectionURL);
            }
            catch (SQLException e) {
                throw new StoreException("Error closing configuration store", (Throwable)e);
            }
        }
    }

    protected String getSqlBlobType() {
        return "blob";
    }

    protected String getSqlVarBinaryType(int size) {
        return "varchar(" + size + ") for bit data";
    }

    protected String getSqlBigIntType() {
        return "bigint";
    }

    protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
        return DerbyUtils.getBlobAsString(rs, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelete() {
        if (this._providedMessageStore.isMessageStoreOpen()) {
            throw new IllegalStateException("Cannot delete the store as the provided message store is still open");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deleting store " + this._storeLocation));
        }
        try {
            DerbyUtils.deleteDatabaseLocation(this._storeLocation);
        }
        catch (StoreException se) {
            LOGGER.debug((Object)("Failed to delete the store at location " + this._storeLocation));
        }
        finally {
            this._storeLocation = null;
        }
    }

    public MessageStore getMessageStore() {
        return this._providedMessageStore;
    }

    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        return DerbyUtils.tableExists(tableName, conn);
    }

    protected void checkConfigurationStoreOpen() {
        if (!this._configurationStoreOpen.get()) {
            throw new IllegalStateException("Configuration store is not open");
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private class ProvidedMessageStore
    extends AbstractDerbyMessageStore {
        private ProvidedMessageStore() {
        }

        @Override
        protected void doOpen(ConfiguredObject<?> parent) {
        }

        protected Connection getConnection() throws SQLException {
            this.checkMessageStoreOpen();
            return DerbyConfigurationStore.this.getConnection();
        }

        @Override
        protected void doClose() {
        }

        public String getStoreLocation() {
            return DerbyConfigurationStore.this._storeLocation;
        }

        protected Logger getLogger() {
            return DerbyConfigurationStore.this.getLogger();
        }
    }
}

