/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.io.File;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.store.AbstractJDBCMessageStore;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.util.FileUtils;

public class DerbyMessageStore
extends AbstractJDBCMessageStore
implements MessageStore,
DurableConfigurationStore {
    private static final Logger _logger = Logger.getLogger(DerbyMessageStore.class);
    private static final String SQL_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String MEMORY_STORE_LOCATION = ":memory:";
    private static final String TABLE_EXISTANCE_QUERY = "SELECT 1 FROM SYS.SYSTABLES WHERE TABLENAME = ?";
    public static final String DERBY_SINGLE_DB_SHUTDOWN_CODE = "08006";
    public static final String TYPE = "DERBY";
    private long _totalStoreSize;
    private boolean _limitBusted;
    private long _persistentSizeLowThreshold;
    private long _persistentSizeHighThreshold;
    protected String _connectionURL;
    private String _storeLocation;
    private Class<Driver> _driverClass;

    protected Logger getLogger() {
        return _logger;
    }

    protected String getSqlBlobType() {
        return "blob";
    }

    protected String getSqlVarBinaryType(int size) {
        return "varchar(" + size + ") for bit data";
    }

    protected String getSqlBigIntType() {
        return "bigint";
    }

    protected void doClose() {
        block2: {
            try {
                Connection conn = DriverManager.getConnection(this._connectionURL + ";shutdown=true");
                conn.close();
                this.getLogger().error((Object)"Unable to shut down the store");
            }
            catch (SQLException e) {
                if (e.getSQLState().equalsIgnoreCase(DERBY_SINGLE_DB_SHUTDOWN_CODE)) break block2;
                this.getLogger().error((Object)("Exception whilst shutting down the store: " + e));
                throw new StoreException("Error closing message store", (Throwable)e);
            }
        }
    }

    protected void implementationSpecificConfiguration(String name, VirtualHost virtualHost) throws ClassNotFoundException {
        File environmentPath;
        String databasePath;
        this._driverClass = Class.forName(SQL_DRIVER_NAME);
        String defaultPath = System.getProperty("QPID_WORK") + File.separator + "derbyDB";
        String string = databasePath = this.isConfigStoreOnly() ? (String)virtualHost.getAttribute("configStorePath") : (String)virtualHost.getAttribute("storePath");
        if (databasePath == null) {
            databasePath = defaultPath;
        }
        if (!(MEMORY_STORE_LOCATION.equals(databasePath) || (environmentPath = new File(databasePath)).exists() || environmentPath.mkdirs())) {
            throw new IllegalArgumentException("Environment path " + environmentPath + " could not be read or created. " + "Ensure the path is correct and that the permissions are correct.");
        }
        this._storeLocation = databasePath;
        Object overfullAttr = virtualHost.getAttribute("storeOverfullSize");
        Object underfullAttr = virtualHost.getAttribute("storeUnderfullSize");
        long l = overfullAttr == null ? -1L : (this._persistentSizeHighThreshold = overfullAttr instanceof Number ? ((Number)overfullAttr).longValue() : Long.parseLong(overfullAttr.toString()));
        long l2 = underfullAttr == null ? this._persistentSizeHighThreshold : (this._persistentSizeLowThreshold = underfullAttr instanceof Number ? ((Number)underfullAttr).longValue() : Long.parseLong(underfullAttr.toString()));
        if (this._persistentSizeLowThreshold > this._persistentSizeHighThreshold || this._persistentSizeLowThreshold < 0L) {
            this._persistentSizeLowThreshold = this._persistentSizeHighThreshold;
        }
        this._connectionURL = "jdbc:derby" + (databasePath.equals(MEMORY_STORE_LOCATION) ? databasePath : ":" + databasePath + "/") + name + ";create=true";
        this._eventManager.addEventListener(new EventListener(){

            public void event(Event event) {
                DerbyMessageStore.this.setInitialSize();
            }
        }, new Event[]{Event.BEFORE_ACTIVATE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialSize() {
        Connection conn = null;
        try {
            try {
                conn = this.newAutoCommitConnection();
                this._totalStoreSize = this.getSizeOnDisk(conn);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error((Object)"Unable to set initial store size", (Throwable)e);
        }
    }

    protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
        Blob blob = rs.getBlob(col);
        if (blob == null) {
            return null;
        }
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        return new String(bytes, UTF8_CHARSET);
    }

    protected byte[] getBlobAsBytes(ResultSet rs, int col) throws SQLException {
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(TABLE_EXISTANCE_QUERY);
        try {
            boolean bl;
            stmt.setString(1, tableName);
            ResultSet rs = stmt.executeQuery();
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    public String getStoreLocation() {
        return this._storeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void storedSizeChange(int delta) {
        if (this.getPersistentSizeHighThreshold() > 0L) {
            DerbyMessageStore derbyMessageStore = this;
            synchronized (derbyMessageStore) {
                long newSize = this._totalStoreSize += (long)(3 * delta);
                Connection conn = null;
                try {
                    if (!this._limitBusted && newSize > this.getPersistentSizeHighThreshold()) {
                        conn = this.newAutoCommitConnection();
                        this._totalStoreSize = this.getSizeOnDisk(conn);
                        if (this._totalStoreSize > this.getPersistentSizeHighThreshold()) {
                            this._limitBusted = true;
                            this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
                        }
                    } else if (this._limitBusted && newSize < this.getPersistentSizeLowThreshold()) {
                        long oldSize = this._totalStoreSize;
                        conn = this.newAutoCommitConnection();
                        this._totalStoreSize = this.getSizeOnDisk(conn);
                        if (oldSize <= this._totalStoreSize) {
                            this.reduceSizeOnDisk(conn);
                            this._totalStoreSize = this.getSizeOnDisk(conn);
                        }
                        if (this._totalStoreSize < this.getPersistentSizeLowThreshold()) {
                            this._limitBusted = false;
                            this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
                        }
                    }
                }
                catch (SQLException e) {
                    this.closeConnection(conn);
                    throw new StoreException("Exception while processing store size change", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reduceSizeOnDisk(Connection conn) {
        CallableStatement cs = null;
        PreparedStatement stmt = null;
        try {
            String tableQuery = "SELECT S.SCHEMANAME, T.TABLENAME FROM SYS.SYSSCHEMAS S, SYS.SYSTABLES T WHERE S.SCHEMAID = T.SCHEMAID AND T.TABLETYPE='T'";
            stmt = conn.prepareStatement(tableQuery);
            ResultSet rs = null;
            ArrayList<String> schemas = new ArrayList<String>();
            ArrayList<String> tables = new ArrayList<String>();
            try {
                rs = stmt.executeQuery();
                while (rs.next()) {
                    schemas.add(rs.getString(1));
                    tables.add(rs.getString(2));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
            for (int i = 0; i < schemas.size(); ++i) {
                cs.setString(1, (String)schemas.get(i));
                cs.setString(2, (String)tables.get(i));
                cs.setShort(3, (short)0);
                cs.execute();
            }
        }
        catch (SQLException e) {
            try {
                this.closeConnection(conn);
                throw new StoreException("Error reducing on disk size", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closePreparedStatement(stmt);
                this.closePreparedStatement(cs);
                throw throwable;
            }
        }
        this.closePreparedStatement(stmt);
        this.closePreparedStatement(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSizeOnDisk(Connection conn) {
        long l;
        PreparedStatement stmt = null;
        try {
            String sizeQuery = "SELECT SUM(T2.NUMALLOCATEDPAGES * T2.PAGESIZE) TOTALSIZE    FROM         SYS.SYSTABLES systabs,        TABLE (SYSCS_DIAG.SPACE_TABLE(systabs.tablename)) AS T2    WHERE systabs.tabletype = 'T'";
            stmt = conn.prepareStatement(sizeQuery);
            ResultSet rs = null;
            long size = 0L;
            try {
                rs = stmt.executeQuery();
                while (rs.next()) {
                    size = rs.getLong(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            l = size;
        }
        catch (SQLException e) {
            try {
                this.closeConnection(conn);
                throw new StoreException("Error establishing on disk size", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closePreparedStatement(stmt);
                throw throwable;
            }
        }
        this.closePreparedStatement(stmt);
        return l;
    }

    private long getPersistentSizeLowThreshold() {
        return this._persistentSizeLowThreshold;
    }

    private long getPersistentSizeHighThreshold() {
        return this._persistentSizeHighThreshold;
    }

    public String getStoreType() {
        return TYPE;
    }

    public void onDelete() {
        File location;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Deleting store " + this._storeLocation));
        }
        if (MEMORY_STORE_LOCATION.equals(this._storeLocation)) {
            return;
        }
        if (this._storeLocation != null && (location = new File(this._storeLocation)).exists() && !FileUtils.delete((File)location, (boolean)true)) {
            _logger.error((Object)("Cannot delete " + this._storeLocation));
        }
    }

    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this._connectionURL);
    }
}

