/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
package org.apache.qpid.server.store.derby;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.plugin.MessageStoreFactory;
import org.apache.qpid.server.store.MessageStore;

public class DerbyMessageStoreFactory implements MessageStoreFactory
{

    @Override
    public String getType()
    {
        return DerbyMessageStore.TYPE;
    }

    @Override
    public MessageStore createMessageStore()
    {
        return new DerbyMessageStore();
    }

    @Override
    public Map<String, Object> convertStoreConfiguration(Configuration configuration)
    {
        return Collections.emptyMap();
    }


    @Override
    public void validateAttributes(Map<String, Object> attributes)
    {
        Object storePath = attributes.get(VirtualHost.STORE_PATH);
        if(!(storePath instanceof String))
        {
            throw new IllegalArgumentException("Attribute '"+ VirtualHost.STORE_PATH
                                                           +"' is required and must be of type String.");

        }
    }

}
