/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type.transport.codec;

import org.apache.qpid.amqp_1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.transport.Attach;

public class AttachWriter
extends AbstractDescribedTypeWriter<Attach> {
    private Attach _value;
    private int _count = -1;
    private static ValueWriter.Factory<Attach> FACTORY = new ValueWriter.Factory<Attach>(){

        @Override
        public ValueWriter<Attach> newInstance(ValueWriter.Registry registry) {
            return new AttachWriter(registry);
        }
    };

    public AttachWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Attach value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getProperties() != null) {
            return 14;
        }
        if (this._value.getDesiredCapabilities() != null) {
            return 13;
        }
        if (this._value.getOfferedCapabilities() != null) {
            return 12;
        }
        if (this._value.getMaxMessageSize() != null) {
            return 11;
        }
        if (this._value.getInitialDeliveryCount() != null) {
            return 10;
        }
        if (this._value.getIncompleteUnsettled() != null) {
            return 9;
        }
        if (this._value.getUnsettled() != null) {
            return 8;
        }
        if (this._value.getTarget() != null) {
            return 7;
        }
        if (this._value.getSource() != null) {
            return 6;
        }
        if (this._value.getRcvSettleMode() != null) {
            return 5;
        }
        if (this._value.getSndSettleMode() != null) {
            return 4;
        }
        if (this._value.getRole() != null) {
            return 3;
        }
        if (this._value.getHandle() != null) {
            return 2;
        }
        if (this._value.getName() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(18L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Attach.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Attach> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Attach value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return AttachWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < AttachWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return AttachWriter.this._value.getName();
                }
                case 1: {
                    return AttachWriter.this._value.getHandle();
                }
                case 2: {
                    return AttachWriter.this._value.getRole();
                }
                case 3: {
                    return AttachWriter.this._value.getSndSettleMode();
                }
                case 4: {
                    return AttachWriter.this._value.getRcvSettleMode();
                }
                case 5: {
                    return AttachWriter.this._value.getSource();
                }
                case 6: {
                    return AttachWriter.this._value.getTarget();
                }
                case 7: {
                    return AttachWriter.this._value.getUnsettled();
                }
                case 8: {
                    return AttachWriter.this._value.getIncompleteUnsettled();
                }
                case 9: {
                    return AttachWriter.this._value.getInitialDeliveryCount();
                }
                case 10: {
                    return AttachWriter.this._value.getMaxMessageSize();
                }
                case 11: {
                    return AttachWriter.this._value.getOfferedCapabilities();
                }
                case 12: {
                    return AttachWriter.this._value.getDesiredCapabilities();
                }
                case 13: {
                    return AttachWriter.this._value.getProperties();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

