/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type.security.codec;

import org.apache.qpid.amqp_1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.security.SaslInit;

public class SaslInitWriter
extends AbstractDescribedTypeWriter<SaslInit> {
    private SaslInit _value;
    private int _count = -1;
    private static ValueWriter.Factory<SaslInit> FACTORY = new ValueWriter.Factory<SaslInit>(){

        @Override
        public ValueWriter<SaslInit> newInstance(ValueWriter.Registry registry) {
            return new SaslInitWriter(registry);
        }
    };

    public SaslInitWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(SaslInit value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getHostname() != null) {
            return 3;
        }
        if (this._value.getInitialResponse() != null) {
            return 2;
        }
        if (this._value.getMechanism() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(65L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(SaslInit.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<SaslInit> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(SaslInit value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return SaslInitWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < SaslInitWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return SaslInitWriter.this._value.getMechanism();
                }
                case 1: {
                    return SaslInitWriter.this._value.getInitialResponse();
                }
                case 2: {
                    return SaslInitWriter.this._value.getHostname();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

