/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type.messaging.codec;

import org.apache.qpid.amqp_1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.amqp_1_0.codec.AbstractListWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.messaging.Modified;

public class ModifiedWriter
extends AbstractDescribedTypeWriter<Modified> {
    private Modified _value;
    private int _count = -1;
    private static ValueWriter.Factory<Modified> FACTORY = new ValueWriter.Factory<Modified>(){

        @Override
        public ValueWriter<Modified> newInstance(ValueWriter.Registry registry) {
            return new ModifiedWriter(registry);
        }
    };

    public ModifiedWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Modified value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getMessageAnnotations() != null) {
            return 3;
        }
        if (this._value.getUndeliverableHere() != null) {
            return 2;
        }
        if (this._value.getDeliveryFailed() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(39L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Modified.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Modified> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Modified value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return ModifiedWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < ModifiedWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return ModifiedWriter.this._value.getDeliveryFailed();
                }
                case 1: {
                    return ModifiedWriter.this._value.getUndeliverableHere();
                }
                case 2: {
                    return ModifiedWriter.this._value.getMessageAnnotations();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

