/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.amqp_1_0.framing.OversizeFrameException;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.transport.Delivery;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.Predicate;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SendingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SequenceNumber;
import org.apache.qpid.amqp_1_0.transport.SessionEventListener;
import org.apache.qpid.amqp_1_0.transport.SessionState;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.DistributionMode;
import org.apache.qpid.amqp_1_0.type.FrameBody;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Source;
import org.apache.qpid.amqp_1_0.type.messaging.Target;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusDurability;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.amqp_1_0.type.transaction.Coordinator;
import org.apache.qpid.amqp_1_0.type.transaction.TxnCapability;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.Attach;
import org.apache.qpid.amqp_1_0.type.transport.Begin;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.Disposition;
import org.apache.qpid.amqp_1_0.type.transport.End;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.Flow;
import org.apache.qpid.amqp_1_0.type.transport.LinkError;
import org.apache.qpid.amqp_1_0.type.transport.Role;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class SessionEndpoint {
    private SessionState _state = SessionState.INACTIVE;
    private final Map<String, LinkEndpoint> _linkMap = new HashMap<String, LinkEndpoint>();
    private final Map<LinkEndpoint, UnsignedInteger> _localLinkEndpoints = new HashMap<LinkEndpoint, UnsignedInteger>();
    private final Map<UnsignedInteger, LinkEndpoint> _remoteLinkEndpoints = new HashMap<UnsignedInteger, LinkEndpoint>();
    private long _timeout;
    private ConnectionEndpoint _connection;
    private long _lastAttachedTime;
    private short _receivingChannel;
    private short _sendingChannel;
    private LinkedHashMap<UnsignedInteger, Delivery> _outgoingUnsettled;
    private LinkedHashMap<UnsignedInteger, Delivery> _incomingUnsettled;
    private static final int DEFAULT_SESSION_BUFFER_SIZE = 2048;
    private static final int BUFFER_SIZE_MASK = 2047;
    private SequenceNumber _nextIncomingTransferId;
    private SequenceNumber _nextOutgoingTransferId;
    private int _nextOutgoingDeliveryId;
    private UnsignedInteger _outgoingSessionCredit;
    private UnsignedInteger _initialOutgoingId;
    private SessionEventListener _sessionEventListener = SessionEventListener.DEFAULT;
    private int _availableIncomingCredit;
    private int _availableOutgoingCredit;
    private UnsignedInteger _lastSentIncomingLimit;
    private final Error _sessionEndedLinkError = new Error(LinkError.DETACH_FORCED, "Force detach the link because the session is remotely ended.");

    public SessionEndpoint(ConnectionEndpoint connectionEndpoint) {
        this(connectionEndpoint, UnsignedInteger.valueOf(0));
    }

    public SessionEndpoint(ConnectionEndpoint connectionEndpoint, Begin begin) {
        this(connectionEndpoint, UnsignedInteger.valueOf(0));
        this._state = SessionState.BEGIN_RECVD;
        this._nextIncomingTransferId = new SequenceNumber(begin.getNextOutgoingId().intValue());
    }

    public SessionEndpoint(ConnectionEndpoint connectionEndpoint, UnsignedInteger nextOutgoingId) {
        this._connection = connectionEndpoint;
        this._initialOutgoingId = nextOutgoingId;
        this._nextOutgoingTransferId = new SequenceNumber(nextOutgoingId.intValue());
        this._outgoingUnsettled = new LinkedHashMap(2048);
        this._incomingUnsettled = new LinkedHashMap(2048);
        this._availableIncomingCredit = 2048;
        this._availableOutgoingCredit = 2048;
    }

    public void setReceivingChannel(short receivingChannel) {
        this._receivingChannel = receivingChannel;
        switch (this._state) {
            case INACTIVE: {
                this._state = SessionState.BEGIN_RECVD;
                break;
            }
            case BEGIN_SENT: {
                this._state = SessionState.ACTIVE;
                break;
            }
            case END_PIPE: {
                this._state = SessionState.END_SENT;
                break;
            }
        }
    }

    public void setSendingChannel(short sendingChannel) {
        this._sendingChannel = sendingChannel;
        switch (this._state) {
            case INACTIVE: {
                this._state = SessionState.BEGIN_SENT;
                break;
            }
            case BEGIN_RECVD: {
                this._state = SessionState.ACTIVE;
                break;
            }
        }
    }

    public SessionState getState() {
        return this._state;
    }

    public void end() {
        this.end(new End());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(End end) {
        Object object = this.getLock();
        synchronized (object) {
            switch (this._state) {
                case BEGIN_SENT: {
                    this._connection.sendEnd(this.getSendingChannel(), end, false);
                    this._state = SessionState.END_PIPE;
                    break;
                }
                case ACTIVE: {
                    this.detachLinks();
                    short sendChannel = this.getSendingChannel();
                    this._connection.sendEnd(sendChannel, end, true);
                    this._state = SessionState.END_SENT;
                    break;
                }
                default: {
                    short sendChannel = this.getSendingChannel();
                    End reply = new End();
                    Error error = new Error();
                    error.setCondition(AmqpError.ILLEGAL_STATE);
                    error.setDescription("END called on Session which has not been opened");
                    reply.setError(error);
                    this._connection.sendEnd(sendChannel, reply, true);
                }
            }
            this.getLock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveEnd(End end) {
        Object object = this.getLock();
        synchronized (object) {
            switch (this._state) {
                case END_SENT: {
                    this._state = SessionState.ENDED;
                    break;
                }
                case ACTIVE: {
                    this.detachLinks();
                    this._sessionEventListener.remoteEnd(end);
                    short sendChannel = this.getSendingChannel();
                    this._connection.sendEnd(sendChannel, new End(), true);
                    this._state = SessionState.ENDED;
                    break;
                }
                default: {
                    short sendChannel = this.getSendingChannel();
                    End reply = new End();
                    Error error = new Error();
                    error.setCondition(AmqpError.ILLEGAL_STATE);
                    error.setDescription("END called on Session which has not been opened");
                    reply.setError(error);
                    this._connection.sendEnd(sendChannel, reply, true);
                }
            }
            this.getLock().notifyAll();
        }
    }

    private void detachLinks() {
        ArrayList<UnsignedInteger> handles = new ArrayList<UnsignedInteger>(this._remoteLinkEndpoints.keySet());
        for (UnsignedInteger handle : handles) {
            Detach detach = new Detach();
            detach.setClosed(false);
            detach.setHandle(handle);
            detach.setError(this._sessionEndedLinkError);
            this.detach(handle, detach);
        }
    }

    public boolean isSyntheticError(Error error) {
        return error == this._sessionEndedLinkError;
    }

    public short getSendingChannel() {
        return this._sendingChannel;
    }

    public void receiveAttach(Attach attach) {
        UnsignedInteger handle;
        if (this._state == SessionState.ACTIVE && !this._remoteLinkEndpoints.containsKey(handle = attach.getHandle())) {
            LinkEndpoint endpoint = this.getLinkMap().get(attach.getName());
            if (endpoint == null) {
                endpoint = attach.getRole() == Role.RECEIVER ? new SendingLinkEndpoint(this, attach) : new ReceivingLinkEndpoint(this, attach);
                endpoint.setSource(attach.getSource());
                endpoint.setTarget(attach.getTarget());
            }
            if (attach.getRole() == Role.SENDER) {
                endpoint.setDeliveryCount(attach.getInitialDeliveryCount());
            }
            this._remoteLinkEndpoints.put(handle, endpoint);
            if (!this._localLinkEndpoints.containsKey(endpoint)) {
                UnsignedInteger localHandle = this.findNextAvailableHandle();
                endpoint.setLocalHandle(localHandle);
                this._localLinkEndpoints.put(endpoint, localHandle);
                this._sessionEventListener.remoteLinkCreation(endpoint);
            } else {
                endpoint.receiveAttach(attach);
            }
        }
    }

    private void send(FrameBody frameBody) {
        this._connection.send(this.getSendingChannel(), frameBody);
    }

    private int send(FrameBody frameBody, ByteBuffer payload) {
        return this._connection.send(this.getSendingChannel(), frameBody, payload);
    }

    private UnsignedInteger findNextAvailableHandle() {
        int i = 0;
        do {
            if (this._localLinkEndpoints.containsValue(UnsignedInteger.valueOf(i))) continue;
            return UnsignedInteger.valueOf(i);
        } while (++i != 0);
        throw new RuntimeException();
    }

    public void receiveDetach(Detach detach) {
        UnsignedInteger handle = detach.getHandle();
        this.detach(handle, detach);
    }

    private void detach(UnsignedInteger handle, Detach detach) {
        if (this._remoteLinkEndpoints.containsKey(handle)) {
            LinkEndpoint endpoint = this._remoteLinkEndpoints.remove(handle);
            endpoint.remoteDetached(detach);
            this._localLinkEndpoints.remove(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveTransfer(Transfer transfer) {
        Object object = this.getLock();
        synchronized (object) {
            Delivery delivery;
            UnsignedInteger deliveryId;
            this._nextIncomingTransferId.incr();
            UnsignedInteger handle = transfer.getHandle();
            LinkEndpoint endpoint = this._remoteLinkEndpoints.get(handle);
            if (endpoint == null) {
                System.err.println("Unknown endpoint " + transfer);
            }
            if ((deliveryId = transfer.getDeliveryId()) == null) {
                deliveryId = ((ReceivingLinkEndpoint)endpoint).getLastDeliveryId();
            }
            if ((delivery = this._incomingUnsettled.get(deliveryId)) == null) {
                delivery = new Delivery(transfer, endpoint);
                this._incomingUnsettled.put(deliveryId, delivery);
                if (delivery.isSettled() || Boolean.TRUE.equals(transfer.getAborted())) {
                    // empty if block
                }
                if (Boolean.TRUE.equals(transfer.getMore())) {
                    ((ReceivingLinkEndpoint)endpoint).setLastDeliveryId(transfer.getDeliveryId());
                }
            } else if (delivery.getDeliveryId().equals(deliveryId)) {
                delivery.addTransfer(transfer);
                if (delivery.isSettled() || Boolean.TRUE.equals(transfer.getAborted())) {
                    // empty if block
                }
                if (!Boolean.TRUE.equals(transfer.getMore())) {
                    ((ReceivingLinkEndpoint)endpoint).setLastDeliveryId(null);
                }
            } else {
                System.err.println("Incorrect transfer id " + transfer);
            }
            if (endpoint != null) {
                endpoint.receiveTransfer(transfer, delivery);
            }
            if (delivery.isComplete() && delivery.isSettled() || Boolean.TRUE.equals(transfer.getAborted())) {
                this._incomingUnsettled.remove(deliveryId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFlow(Flow flow) {
        Object object = this.getLock();
        synchronized (object) {
            UnsignedInteger handle = flow.getHandle();
            LinkEndpoint endpoint = handle == null ? null : this._remoteLinkEndpoints.get(handle);
            UnsignedInteger nextOutgoingId = flow.getNextIncomingId() == null ? this._initialOutgoingId : flow.getNextIncomingId();
            int limit = nextOutgoingId.intValue() + flow.getIncomingWindow().intValue();
            this._outgoingSessionCredit = UnsignedInteger.valueOf(limit - this._nextOutgoingTransferId.intValue());
            if (endpoint != null) {
                endpoint.receiveFlow(flow);
            } else {
                final Collection<LinkEndpoint> allLinkEndpoints = this._remoteLinkEndpoints.values();
                this.getConnection().addPostLockAction(new Runnable(){

                    @Override
                    public void run() {
                        for (LinkEndpoint le : allLinkEndpoints) {
                            le.flowStateChanged();
                        }
                    }
                });
            }
            this.getLock().notifyAll();
        }
    }

    public void receiveDisposition(Disposition disposition) {
        Role dispositionRole = disposition.getRole();
        LinkedHashMap<UnsignedInteger, Delivery> unsettledTransfers = dispositionRole == Role.RECEIVER ? this._outgoingUnsettled : this._incomingUnsettled;
        UnsignedInteger deliveryId = disposition.getFirst();
        UnsignedInteger last = disposition.getLast();
        if (last == null) {
            last = deliveryId;
        }
        while (deliveryId.compareTo(last) <= 0) {
            Delivery delivery = unsettledTransfers.get(deliveryId);
            if (delivery != null) {
                delivery.getLinkEndpoint().receiveDeliveryState(delivery, disposition.getState(), disposition.getSettled());
            }
            deliveryId = deliveryId.add(UnsignedInteger.ONE);
        }
        if (disposition.getSettled().booleanValue()) {
            this.checkSendFlow();
        }
    }

    private void checkSendFlow() {
    }

    public SendingLinkEndpoint createSendingLinkEndpoint(String name, String targetAddr, String sourceAddr) {
        return this.createSendingLinkEndpoint(name, targetAddr, sourceAddr, null);
    }

    public SendingLinkEndpoint createSendingLinkEndpoint(String name, String targetAddr, String sourceAddr, Map<Binary, Outcome> unsettled) {
        return this.createSendingLinkEndpoint(name, targetAddr, sourceAddr, false, unsettled);
    }

    public SendingLinkEndpoint createSendingLinkEndpoint(String name, String targetAddr, String sourceAddr, boolean durable, Map<Binary, Outcome> unsettled) {
        Source source = new Source();
        source.setAddress(sourceAddr);
        Target target = new Target();
        target.setAddress(targetAddr);
        if (durable) {
            target.setDurable(TerminusDurability.UNSETTLED_STATE);
            target.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
        }
        return this.createSendingLinkEndpoint(name, source, target, unsettled);
    }

    public SendingLinkEndpoint createSendingLinkEndpoint(String name, Source source, org.apache.qpid.amqp_1_0.type.Target target) {
        return this.createSendingLinkEndpoint(name, source, target, null);
    }

    public SendingLinkEndpoint createSendingLinkEndpoint(String name, Source source, org.apache.qpid.amqp_1_0.type.Target target, Map<Binary, Outcome> unsettled) {
        return this.createSendingLinkEndpoint(name, source, target, unsettled, null);
    }

    public SendingLinkEndpoint createSendingLinkEndpoint(String name, Source source, org.apache.qpid.amqp_1_0.type.Target target, Map<Binary, Outcome> unsettled, DeliveryStateHandler deliveryStateHandler) {
        SendingLinkEndpoint endpoint = new SendingLinkEndpoint(this, name, unsettled, deliveryStateHandler);
        endpoint.setSource(source);
        endpoint.setTarget(target);
        UnsignedInteger handle = this.findNextAvailableHandle();
        this._localLinkEndpoints.put(endpoint, handle);
        endpoint.setLocalHandle(handle);
        this.getLinkMap().put(name, endpoint);
        return endpoint;
    }

    public void sendAttach(Attach attach) {
        this.send(attach);
    }

    public void sendTransfer(Transfer xfr, SendingLinkEndpoint endpoint, boolean newDelivery) {
        UnsignedInteger deliveryId;
        this._nextOutgoingTransferId.incr();
        if (newDelivery) {
            deliveryId = UnsignedInteger.valueOf(this._nextOutgoingDeliveryId++);
            endpoint.setLastDeliveryId(deliveryId);
        } else {
            deliveryId = endpoint.getLastDeliveryId();
        }
        xfr.setDeliveryId(deliveryId);
        if (!Boolean.TRUE.equals(xfr.getSettled())) {
            Delivery delivery = this._outgoingUnsettled.get(deliveryId);
            if (delivery == null) {
                delivery = new Delivery(xfr, endpoint);
                this._outgoingUnsettled.put(deliveryId, delivery);
            } else {
                delivery.addTransfer(xfr);
            }
            this._outgoingSessionCredit = this._outgoingSessionCredit.subtract(UnsignedInteger.ONE);
            endpoint.addUnsettled(delivery);
        }
        try {
            ByteBuffer payload = xfr.getPayload();
            int payloadSent = this.send(xfr, payload);
            if (payload != null && payloadSent < payload.remaining() && payloadSent >= 0) {
                payload = payload.duplicate();
                payload.position(payload.position() + payloadSent);
                Transfer secondTransfer = new Transfer();
                secondTransfer.setDeliveryTag(xfr.getDeliveryTag());
                secondTransfer.setHandle(xfr.getHandle());
                secondTransfer.setSettled(xfr.getSettled());
                secondTransfer.setState(xfr.getState());
                secondTransfer.setMessageFormat(xfr.getMessageFormat());
                secondTransfer.setPayload(payload);
                this.sendTransfer(secondTransfer, endpoint, false);
            }
        }
        catch (OversizeFrameException e) {
            e.printStackTrace();
        }
    }

    public Object getLock() {
        return this._connection.getLock();
    }

    public long getSyncTimeout() {
        return this._connection.getSyncTimeout();
    }

    public void waitUntil(Predicate predicate) throws TimeoutException, InterruptedException {
        this._connection.waitUntil(predicate);
    }

    public void waitUntil(Predicate predicate, long timeout) throws TimeoutException, InterruptedException {
        this._connection.waitUntil(predicate, timeout);
    }

    public ReceivingLinkEndpoint createReceivingLinkEndpoint(String name, String targetAddr, String sourceAddr, UnsignedInteger initialCredit, DistributionMode distributionMode) {
        Source source = new Source();
        source.setAddress(sourceAddr);
        source.setDistributionMode(distributionMode);
        Target target = new Target();
        target.setAddress(targetAddr);
        return this.createReceivingLinkEndpoint(name, target, source, initialCredit);
    }

    public ReceivingLinkEndpoint createReceivingLinkEndpoint(String name, Target target, Source source, UnsignedInteger initialCredit) {
        ReceivingLinkEndpoint endpoint = new ReceivingLinkEndpoint(this, name);
        endpoint.setLinkCredit(initialCredit);
        endpoint.setSource(source);
        endpoint.setTarget(target);
        UnsignedInteger handle = this.findNextAvailableHandle();
        this._localLinkEndpoints.put(endpoint, handle);
        endpoint.setLocalHandle(handle);
        this.getLinkMap().put(name, endpoint);
        return endpoint;
    }

    public void updateDisposition(Role role, UnsignedInteger first, UnsignedInteger last, DeliveryState state, boolean settled) {
        Disposition disposition = new Disposition();
        disposition.setRole(role);
        disposition.setFirst(first);
        disposition.setLast(last);
        disposition.setSettled(settled);
        disposition.setState(state);
        if (settled && role == Role.RECEIVER) {
            SequenceNumber pos = new SequenceNumber(first.intValue());
            SequenceNumber end = new SequenceNumber(last.intValue());
            while (pos.compareTo(end) <= 0) {
                Delivery d = (Delivery)this._incomingUnsettled.remove(new UnsignedInteger(pos.intValue()));
                pos.incr();
            }
        }
        this.send(disposition);
        this.checkSendFlow();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void settle(Role role, UnsignedInteger deliveryId) {
        if (role == Role.RECEIVER) {
            Delivery d = (Delivery)this._incomingUnsettled.remove(deliveryId);
            if (d == null) return;
        }
        Delivery delivery = (Delivery)this._outgoingUnsettled.remove(deliveryId);
    }

    public void sendFlow() {
        this.sendFlow(new Flow());
    }

    public void sendFlow(Flow flow) {
        if (this._nextIncomingTransferId != null) {
            int nextIncomingId = this._nextIncomingTransferId.intValue();
            flow.setNextIncomingId(UnsignedInteger.valueOf(nextIncomingId));
            this._lastSentIncomingLimit = UnsignedInteger.valueOf(nextIncomingId + this._availableIncomingCredit);
        }
        flow.setIncomingWindow(UnsignedInteger.valueOf(this._availableIncomingCredit));
        flow.setNextOutgoingId(UnsignedInteger.valueOf(this._nextOutgoingTransferId.intValue()));
        flow.setOutgoingWindow(UnsignedInteger.valueOf(this._availableOutgoingCredit));
        this.send(flow);
    }

    public void sendFlowConditional() {
        if (this._nextIncomingTransferId != null) {
            UnsignedInteger clientsCredit = this._lastSentIncomingLimit.subtract(UnsignedInteger.valueOf(this._nextIncomingTransferId.intValue()));
            int i = UnsignedInteger.valueOf(this._availableIncomingCredit).subtract(clientsCredit).compareTo(clientsCredit);
            if (i >= 0) {
                this.sendFlow();
            }
        }
    }

    public void sendDetach(Detach detach) {
        this.send(detach);
    }

    void doEnd(End end) {
    }

    public void setNextIncomingId(UnsignedInteger nextIncomingId) {
        this._nextIncomingTransferId = new SequenceNumber(nextIncomingId.intValue());
    }

    public void setOutgoingSessionCredit(UnsignedInteger outgoingSessionCredit) {
        this._outgoingSessionCredit = outgoingSessionCredit;
    }

    public UnsignedInteger getNextOutgoingId() {
        return UnsignedInteger.valueOf(this._nextOutgoingTransferId.intValue());
    }

    public UnsignedInteger getOutgoingWindowSize() {
        return UnsignedInteger.valueOf(this._availableOutgoingCredit);
    }

    public boolean hasCreditToSend() {
        boolean b = this._outgoingSessionCredit != null && this._outgoingSessionCredit.intValue() > 0;
        boolean b1 = this.getOutgoingWindowSize() != null && this.getOutgoingWindowSize().compareTo(UnsignedInteger.ZERO) > 0;
        return b && b1;
    }

    public UnsignedInteger getIncomingWindowSize() {
        return UnsignedInteger.valueOf(this._availableIncomingCredit);
    }

    public SessionEventListener getSessionEventListener() {
        return this._sessionEventListener;
    }

    public void setSessionEventListener(SessionEventListener sessionEventListener) {
        this._sessionEventListener = sessionEventListener;
    }

    public ConnectionEndpoint getConnection() {
        return this._connection;
    }

    public SendingLinkEndpoint createTransactionController(String name, TxnCapability ... capabilities) {
        Coordinator coordinator = new Coordinator();
        coordinator.setCapabilities(capabilities);
        Source src = new Source();
        return this.createSendingLinkEndpoint(name, src, coordinator);
    }

    Map<String, LinkEndpoint> getLinkMap() {
        return this._linkMap;
    }

    public Collection<LinkEndpoint> getLocalLinkEndpoints() {
        return new ArrayList<LinkEndpoint>(this._localLinkEndpoints.keySet());
    }

    public boolean isEnded() {
        return this._state == SessionState.ENDED || this._connection.isClosed();
    }

    public boolean isActive() {
        return this._state == SessionState.ACTIVE;
    }
}

