/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.amqp_1_0.transport.Delivery;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.LinkEventListener;
import org.apache.qpid.amqp_1_0.transport.Predicate;
import org.apache.qpid.amqp_1_0.transport.SessionEndpoint;
import org.apache.qpid.amqp_1_0.transport.SessionState;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.Source;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.Target;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.transport.Attach;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.Flow;
import org.apache.qpid.amqp_1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.amqp_1_0.type.transport.Role;
import org.apache.qpid.amqp_1_0.type.transport.SenderSettleMode;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public abstract class LinkEndpoint<T extends LinkEventListener> {
    private T _linkEventListener;
    private DeliveryStateHandler _deliveryStateHandler;
    private Object _flowTransactionId;
    private SenderSettleMode _sendingSettlementMode;
    private ReceiverSettleMode _receivingSettlementMode;
    private Map _initialUnsettledMap;
    private Map _localUnsettled;
    private UnsignedInteger _lastSentCreditLimit;
    private final String _name;
    private SessionEndpoint _session;
    private volatile State _state = State.DETACHED;
    private Source _source;
    private Target _target;
    private UnsignedInteger _deliveryCount;
    private UnsignedInteger _linkCredit;
    private UnsignedInteger _available;
    private Boolean _drain;
    private UnsignedInteger _localHandle;
    private UnsignedLong _maxMessageSize;
    private Map<Binary, Delivery> _unsettledTransfers = new HashMap<Binary, Delivery>();

    LinkEndpoint(SessionEndpoint sessionEndpoint, String name, Map<Binary, Outcome> unsettled) {
        this(sessionEndpoint, name, unsettled, null);
    }

    LinkEndpoint(SessionEndpoint sessionEndpoint, String name, Map<Binary, Outcome> unsettled, DeliveryStateHandler deliveryStateHandler) {
        this._name = name;
        this._session = sessionEndpoint;
        this._linkCredit = UnsignedInteger.valueOf(0);
        this._drain = Boolean.FALSE;
        this._localUnsettled = unsettled;
        this._deliveryStateHandler = deliveryStateHandler;
    }

    LinkEndpoint(SessionEndpoint sessionEndpoint, Attach attach) {
        this._session = sessionEndpoint;
        this._name = attach.getName();
        this._initialUnsettledMap = attach.getUnsettled();
        this._state = State.ATTACH_RECVD;
    }

    public String getName() {
        return this._name;
    }

    public abstract Role getRole();

    public Source getSource() {
        return this._source;
    }

    public void setSource(Source source) {
        this._source = source;
    }

    public Target getTarget() {
        return this._target;
    }

    public void setTarget(Target target) {
        this._target = target;
    }

    public void setDeliveryCount(UnsignedInteger deliveryCount) {
        this._deliveryCount = deliveryCount;
    }

    public void setLinkCredit(UnsignedInteger linkCredit) {
        this._linkCredit = linkCredit;
    }

    public void setAvailable(UnsignedInteger available) {
        this._available = available;
    }

    public void setDrain(Boolean drain) {
        this._drain = drain;
    }

    public UnsignedInteger getDeliveryCount() {
        return this._deliveryCount;
    }

    public UnsignedInteger getAvailable() {
        return this._available;
    }

    public Boolean getDrain() {
        return this._drain;
    }

    public UnsignedInteger getLinkCredit() {
        return this._linkCredit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteDetached(Detach detach) {
        Object object = this.getLock();
        synchronized (object) {
            switch (this._state) {
                case DETACH_SENT: {
                    this._state = State.DETACHED;
                    break;
                }
                case ATTACHED: {
                    this._state = State.DETACH_RECVD;
                    this._linkEventListener.remoteDetached(this, detach);
                }
            }
            this.getLock().notifyAll();
        }
    }

    public void receiveTransfer(Transfer transfer, Delivery delivery) {
    }

    public void settledByPeer(Binary deliveryTag) {
    }

    public void receiveFlow(Flow flow) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnsettled(Delivery unsettled) {
        Object object = this.getLock();
        synchronized (object) {
            this._unsettledTransfers.put(unsettled.getDeliveryTag(), unsettled);
            this.getLock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDeliveryState(Delivery unsettled, DeliveryState state, Boolean settled) {
        Object object = this.getLock();
        synchronized (object) {
            if (this._deliveryStateHandler != null) {
                this._deliveryStateHandler.handle(unsettled.getDeliveryTag(), state, settled);
            }
            if (settled.booleanValue()) {
                this.settle(unsettled.getDeliveryTag());
            }
            this.getLock().notifyAll();
        }
    }

    public void settle(Binary deliveryTag) {
        Delivery delivery = this._unsettledTransfers.remove(deliveryTag);
        if (delivery != null) {
            this.getSession().settle(this.getRole(), delivery.getDeliveryId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnsettledCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this._unsettledTransfers.size();
        }
    }

    public void setLocalHandle(UnsignedInteger localHandle) {
        this._localHandle = localHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveAttach(Attach attach) {
        Object object = this.getLock();
        synchronized (object) {
            switch (this._state) {
                case ATTACH_SENT: {
                    this._state = State.ATTACHED;
                    this.getLock().notifyAll();
                    this._initialUnsettledMap = attach.getUnsettled();
                    break;
                }
                case DETACHED: {
                    this._state = State.ATTACHED;
                    this.getLock().notifyAll();
                }
            }
            if (attach.getRole() == Role.SENDER) {
                this._source = attach.getSource();
            } else {
                this._target = attach.getTarget();
            }
            if (this.getRole() == Role.SENDER) {
                this._maxMessageSize = attach.getMaxMessageSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached() {
        Object object = this.getLock();
        synchronized (object) {
            return this._state == State.ATTACHED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDetached() {
        Object object = this.getLock();
        synchronized (object) {
            return this._state == State.DETACHED || this._session.isEnded();
        }
    }

    public SessionEndpoint getSession() {
        return this._session;
    }

    public UnsignedInteger getLocalHandle() {
        return this._localHandle;
    }

    public Object getLock() {
        return this._session.getLock();
    }

    public long getSyncTimeout() {
        return this._session.getSyncTimeout();
    }

    public void waitUntil(Predicate predicate) throws TimeoutException, InterruptedException {
        this._session.waitUntil(predicate);
    }

    public void waitUntil(Predicate predicate, long timeout) throws TimeoutException, InterruptedException {
        this._session.waitUntil(predicate, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach() {
        Object object = this.getLock();
        synchronized (object) {
            Attach attachToSend = new Attach();
            attachToSend.setName(this.getName());
            attachToSend.setRole(this.getRole());
            attachToSend.setHandle(this.getLocalHandle());
            attachToSend.setSource(this.getSource());
            attachToSend.setTarget(this.getTarget());
            attachToSend.setSndSettleMode(this.getSendingSettlementMode());
            attachToSend.setRcvSettleMode(this.getReceivingSettlementMode());
            attachToSend.setUnsettled(this._localUnsettled);
            if (this.getRole() == Role.SENDER) {
                attachToSend.setInitialDeliveryCount(this._deliveryCount);
            }
            switch (this._state) {
                case DETACHED: {
                    this._state = State.ATTACH_SENT;
                    break;
                }
                case ATTACH_RECVD: {
                    this._state = State.ATTACHED;
                    break;
                }
            }
            this.getSession().sendAttach(attachToSend);
            this.getLock().notifyAll();
        }
    }

    public void detach() {
        this.detach(null, false);
    }

    public void close() {
        this.detach(null, true);
    }

    public void close(Error error) {
        this.detach(error, true);
    }

    public void detach(Error error) {
        this.detach(error, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach(Error error, boolean close) {
        Object object = this.getLock();
        synchronized (object) {
            switch (this._state) {
                case ATTACHED: {
                    this._state = State.DETACH_SENT;
                    break;
                }
                case DETACH_RECVD: {
                    this._state = State.DETACHED;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.getSession().getState() != SessionState.END_RECVD) {
                Detach detach = new Detach();
                detach.setHandle(this.getLocalHandle());
                if (close) {
                    detach.setClosed(close);
                }
                detach.setError(error);
                this.getSession().sendDetach(detach);
            }
            this.getLock().notifyAll();
        }
    }

    public void setTransactionId(Object txnId) {
        this._flowTransactionId = txnId;
    }

    public void sendFlowConditional() {
        if (this._lastSentCreditLimit != null) {
            UnsignedInteger clientsCredit = this._lastSentCreditLimit.subtract(this._deliveryCount);
            int i = this._linkCredit.subtract(clientsCredit).compareTo(clientsCredit);
            if (i >= 0) {
                this.sendFlow(this._flowTransactionId != null);
            } else {
                this.getSession().sendFlowConditional();
            }
        } else {
            this.sendFlow(this._flowTransactionId != null);
        }
    }

    public void sendFlow() {
        this.sendFlow(this._flowTransactionId != null);
    }

    public void sendFlowWithEcho() {
        this.sendFlow(this._flowTransactionId != null, true);
    }

    public void sendFlow(boolean setTransactionId) {
        this.sendFlow(setTransactionId, false);
    }

    public void sendFlow(boolean setTransactionId, boolean echo) {
        if (this._state == State.ATTACHED || this._state == State.ATTACH_SENT) {
            Flow flow = new Flow();
            flow.setLinkCredit(this._linkCredit);
            flow.setDeliveryCount(this._deliveryCount);
            flow.setEcho(echo);
            this._lastSentCreditLimit = this._linkCredit.add(this._deliveryCount);
            flow.setAvailable(this._available);
            flow.setDrain(this._drain);
            if (setTransactionId) {
                flow.setProperties(Collections.singletonMap(Symbol.valueOf("txn-id"), this._flowTransactionId));
            }
            flow.setHandle(this.getLocalHandle());
            this.getSession().sendFlow(flow);
        }
    }

    public T getLinkEventListener() {
        return this._linkEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinkEventListener(T linkEventListener) {
        Object object = this.getLock();
        synchronized (object) {
            this._linkEventListener = linkEventListener;
        }
    }

    public DeliveryStateHandler getDeliveryStateHandler() {
        return this._deliveryStateHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeliveryStateHandler(DeliveryStateHandler deliveryStateHandler) {
        Object object = this.getLock();
        synchronized (object) {
            this._deliveryStateHandler = deliveryStateHandler;
        }
    }

    public void setSendingSettlementMode(SenderSettleMode sendingSettlementMode) {
        this._sendingSettlementMode = sendingSettlementMode;
    }

    public SenderSettleMode getSendingSettlementMode() {
        return this._sendingSettlementMode;
    }

    public ReceiverSettleMode getReceivingSettlementMode() {
        return this._receivingSettlementMode;
    }

    public void setReceivingSettlementMode(ReceiverSettleMode receivingSettlementMode) {
        this._receivingSettlementMode = receivingSettlementMode;
    }

    public Map getInitialUnsettledMap() {
        return this._initialUnsettledMap;
    }

    public abstract void flowStateChanged();

    public void setLocalUnsettled(Map unsettled) {
        this._localUnsettled = unsettled;
    }

    public String toString() {
        return "LinkEndpoint{_name='" + this._name + '\'' + ", _session=" + this._session + ", _state=" + (Object)((Object)this._state) + ", _role=" + this.getRole() + ", _source=" + this._source + ", _target=" + this._target + ", _transferCount=" + this._deliveryCount + ", _linkCredit=" + this._linkCredit + ", _available=" + this._available + ", _drain=" + this._drain + ", _localHandle=" + this._localHandle + ", _maxMessageSize=" + this._maxMessageSize + '}';
    }

    private static enum State {
        DETACHED,
        ATTACH_SENT,
        ATTACH_RECVD,
        ATTACHED,
        DETACH_SENT,
        DETACH_RECVD;

    }
}

