/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class SmallLongConstructor
implements TypeConstructor {
    private static final SmallLongConstructor INSTANCE = new SmallLongConstructor();

    public static SmallLongConstructor getInstance() {
        return INSTANCE;
    }

    private SmallLongConstructor() {
    }

    public Object construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.hasRemaining()) {
            byte b = in.get();
            return (long)b;
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct long: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

